/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import me.desht.pneumaticcraft.client.gui.widget.ITooltipProvider;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.thirdparty.ModNameCache;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.client.resources.I18n;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class WidgetTank
extends Widget
implements ITooltipProvider {
    private final IFluidTank tank;

    public WidgetTank(int x, int y, IFluidTank tank) {
        super(x, y, 16, 64, "");
        this.tank = tank;
    }

    public WidgetTank(int x, int y, FluidStack stack) {
        this(x, y, (IFluidTank)WidgetTank.makeTank(stack, 160000));
    }

    public WidgetTank(int x, int y, int width, int height, FluidStack stack) {
        super(x, y, width, height, "");
        this.tank = WidgetTank.makeTank(stack, stack.getAmount());
    }

    private static FluidTank makeTank(FluidStack stack, int capacity) {
        FluidTank tank = new FluidTank(capacity);
        tank.fill(stack, IFluidHandler.FluidAction.EXECUTE);
        return tank;
    }

    public void renderButton(int mouseX, int mouseY, float partialTick) {
        RenderSystem.disableLighting();
        GuiUtils.drawFluid(new Rectangle2d(this.x, this.y, this.width, this.height), this.getFluid(), (IFluidTank)this.getTank());
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)0.0, (double)0.0, (double)300.0);
        for (int i = 3; i < this.height - 1; i += 4) {
            int width = (i - 3) % 20 == 0 ? 16 : 2;
            AbstractGui.fill((int)this.x, (int)(this.y + i), (int)(this.x + width), (int)(this.y + i + 1), (int)-13684945);
        }
        RenderSystem.popMatrix();
    }

    @Override
    public void addTooltip(double mouseX, double mouseY, List<String> curTip, boolean shift) {
        Fluid fluid = this.tank.getFluid().getFluid();
        int amt = this.tank.getFluidAmount();
        int capacity = this.tank.getCapacity();
        curTip.add(amt + "/" + capacity + " mb");
        if (fluid == Fluids.field_204541_a || amt == 0 || capacity == 0) {
            curTip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"pneumaticcraft.gui.liquid.empty", (Object[])new Object[0]));
        } else {
            curTip.add(TextFormatting.GRAY + new FluidStack(fluid, amt).getDisplayName().func_150254_d());
            curTip.add(TextFormatting.BLUE + "" + TextFormatting.ITALIC + ModNameCache.getModName(fluid.getRegistryName().func_110624_b()));
        }
    }

    public FluidStack getFluid() {
        return this.tank.getFluid();
    }

    public FluidTank getTank() {
        return (FluidTank)this.tank;
    }
}

