/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.crafting.TemperatureRange;
import me.desht.pneumaticcraft.client.gui.widget.ITooltipProvider;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.heat.HeatUtil;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;

public class WidgetTemperature
extends Widget
implements ITooltipProvider {
    private int temperature;
    private int tickInterval;
    private TemperatureRange totalRange;
    private TemperatureRange operatingRange;
    private boolean drawText = true;
    private boolean showOperatingRange = true;

    public WidgetTemperature(int xIn, int yIn, TemperatureRange totalRange, int initialTemp, int tickInterval) {
        super(xIn, yIn, 13, 50, "");
        this.totalRange = totalRange;
        this.temperature = initialTemp;
        this.tickInterval = tickInterval;
        this.operatingRange = null;
    }

    public void setTotalRange(@Nonnull TemperatureRange totalRange) {
        this.totalRange = totalRange;
    }

    public TemperatureRange getTotalRange() {
        return this.totalRange;
    }

    public WidgetTemperature setOperatingRange(@Nullable TemperatureRange operatingRange) {
        this.operatingRange = operatingRange;
        return this;
    }

    public int getTemperature() {
        return this.temperature;
    }

    public void setTemperature(int temperature) {
        this.temperature = temperature;
    }

    public void setTickInterval(int tickInterval) {
        this.tickInterval = tickInterval;
    }

    public <T extends WidgetTemperature> T setDrawText(boolean drawText) {
        this.drawText = drawText;
        return (T)this;
    }

    public WidgetTemperature setShowOperatingRange(boolean showOperatingRange) {
        this.showOperatingRange = showOperatingRange;
        return this;
    }

    public void renderButton(int mouseX, int mouseY, float partialTicks) {
        if (this.visible) {
            RenderSystem.disableLighting();
            Minecraft.func_71410_x().func_110434_K().func_110577_a(Textures.WIDGET_TEMPERATURE);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            WidgetTemperature.blit((int)(this.x + 6), (int)this.y, (float)6.0f, (float)0.0f, (int)7, (int)50, (int)18, (int)50);
            int barLength = this.getYPos(this.temperature);
            WidgetTemperature.blit((int)(this.x + 7), (int)(this.y - 1 + this.height - barLength), (float)13.0f, (float)(this.height - barLength - 2), (int)5, (int)barLength, (int)18, (int)50);
            this.drawTicks();
            if (this.drawText) {
                GuiUtils.drawScaledText(Minecraft.func_71410_x().field_71466_p, TemperatureRange.TemperatureScale.CELSIUS.symbol(), this.x + 7, this.y + this.height + 1, -12566464, 0.5f);
            }
            this.drawOperatingTempMarkers();
        }
    }

    public void drawTicks() {
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        int n = 0;
        for (int tickTempC = WidgetTemperature.findNearest(this.totalRange.getMin() - 273, this.tickInterval); tickTempC <= this.totalRange.getMax() - 273; tickTempC += this.tickInterval) {
            int yOffset = this.getYPos(tickTempC + 273);
            this.hLine(this.x + 4, this.x + 6, this.y - 1 + this.height - yOffset, -1606401984);
            if (yOffset != 0 && yOffset != this.height - 1) {
                this.hLine(this.x + 6, this.x + 8, this.y - 1 + this.height - yOffset, -2134851392);
            }
            if (this.drawText && n % 2 == 0) {
                String s = Integer.toString(tickTempC);
                GuiUtils.drawScaledText(font, s, this.x + 4 - font.func_78256_a(s) / 2, this.y - 2 + this.height - yOffset, -12566464, 0.5f);
            }
            ++n;
        }
    }

    public void drawOperatingTempMarkers() {
        if (this.operatingRange != null) {
            int yOffset;
            if (this.totalRange.inRange(this.operatingRange.getMax())) {
                yOffset = this.getYPos(this.operatingRange.getMax());
                this.hLine(this.x + 7, this.x + 11, this.y + 1 + this.height - yOffset, -2039744);
                this.hLine(this.x + 9, this.x + 9, this.y + this.height - yOffset, -2132746176);
                this.hLine(this.x + 8, this.x + 10, this.y - 1 + this.height - yOffset, -2132746176);
                this.hLine(this.x + 7, this.x + 11, this.y - 2 + this.height - yOffset, -2132746176);
            }
            if (this.totalRange.inRange(this.operatingRange.getMin())) {
                yOffset = this.getYPos(this.operatingRange.getMin());
                this.hLine(this.x + 7, this.x + 11, this.y - 1 + this.height - yOffset, -2039744);
                this.hLine(this.x + 9, this.x + 9, this.y + this.height - yOffset, -2132746176);
                this.hLine(this.x + 8, this.x + 10, this.y + 1 + this.height - yOffset, -2132746176);
                this.hLine(this.x + 7, this.x + 11, this.y + 2 + this.height - yOffset, -2132746176);
            }
        }
    }

    private int getYPos(int temp) {
        int h = this.height - 1;
        return MathHelper.func_76125_a((int)((temp - this.totalRange.getMin()) * h / (this.totalRange.getMax() - this.totalRange.getMin())), (int)0, (int)(h + 4));
    }

    private static int findNearest(int temp, int interval) {
        int q = temp % interval;
        if (q == 0) {
            return temp;
        }
        int n = temp - q;
        return Math.max(-273, n - interval);
    }

    @Override
    public void addTooltip(double mouseX, double mouseY, List<String> curTip, boolean shift) {
        curTip.add(HeatUtil.formatHeatString(this.temperature).func_150254_d());
        if (this.operatingRange != null && this.showOperatingRange) {
            TextFormatting tf = this.operatingRange.inRange(this.temperature) ? TextFormatting.GREEN : TextFormatting.GOLD;
            curTip.add(tf + I18n.func_135052_a((String)"pneumaticcraft.gui.misc.requiredTemperatureString", (Object[])new Object[]{this.operatingRange.asString(TemperatureRange.TemperatureScale.CELSIUS)}));
        }
    }

    public void autoScaleForTemperature() {
        if (this.temperature < 173) {
            this.setTotalRange(TemperatureRange.of(0, 275));
            this.setTickInterval(25);
        } else if (this.temperature < 273) {
            this.setTotalRange(TemperatureRange.of(123, 373));
            this.setTickInterval(25);
        } else if (this.temperature < 373) {
            this.setTotalRange(TemperatureRange.of(273, 373));
            this.setTickInterval(25);
        } else if (this.temperature < 473) {
            this.setTotalRange(TemperatureRange.of(273, 473));
            this.setTickInterval(25);
        } else if (this.temperature < 773) {
            this.setTotalRange(TemperatureRange.of(273, 773));
            this.setTickInterval(50);
        } else if (this.temperature < 1273) {
            this.setTotalRange(TemperatureRange.of(273, 1273));
            this.setTickInterval(100);
        } else {
            this.setTotalRange(TemperatureRange.of(273, 2273));
            this.setTickInterval(200);
        }
    }

    public static int roundDownK(int tempK, int interval) {
        int tempC = tempK - 273;
        int rem = tempC % interval;
        return tempK - rem;
    }

    public static int roundUpK(int tempK, int interval) {
        return WidgetTemperature.roundDownK(tempK, interval) + interval;
    }

    public static WidgetTemperature fromOperatingRange(int x, int y, TemperatureRange range) {
        int interval = WidgetTemperature.calcInterval(range.getMax() - range.getMin());
        int max = range.hasMax() ? WidgetTemperature.findNearest(range.getMax(), interval) + 273 + interval : WidgetTemperature.findNearest(range.getMin(), interval) + 273 + interval;
        int min = range.hasMin() ? WidgetTemperature.findNearest(range.getMin(), interval) + 273 : (range.getMin() < 273 ? 0 : 273);
        return new WidgetTemperature(x, y, TemperatureRange.of(min, max), min, WidgetTemperature.calcInterval(max - min)).setOperatingRange(range);
    }

    public static int calcInterval(int r) {
        int r1 = r / 10;
        if (r1 >= 200) {
            return 200;
        }
        if (r1 >= 100) {
            return 100;
        }
        if (r1 >= 50) {
            return 50;
        }
        if (r1 >= 15) {
            return 25;
        }
        if (r1 >= 5) {
            return 10;
        }
        return 5;
    }
}

