/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.BlockTrackEvent;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IBlockTrackEntry;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IGuiScreen;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IOptionPage;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IUpgradeRenderHandler;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.GuiBlockTrackOptions;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.WidgetKeybindCheckBox;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.HUDHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.RenderBlockTarget;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.block_tracker.BlockTrackEntryList;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.SearchUpgradeHandler;
import me.desht.pneumaticcraft.common.config.PNCConfig;
import me.desht.pneumaticcraft.common.config.subconfig.ArmorHUDLayout;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.CapabilityItemHandler;

public class BlockTrackUpgradeHandler
implements IUpgradeRenderHandler {
    static final int BLOCK_TRACKING_RANGE = 30;
    private static final int HARD_MAX_BLOCKS_PER_TICK = 50000;
    private final Map<BlockPos, RenderBlockTarget> blockTargets = new HashMap<BlockPos, RenderBlockTarget>();
    private WidgetAnimatedStat blockTrackInfo;
    private final Map<String, Integer> blockTypeCount = new HashMap<String, Integer>();
    private final Map<String, Integer> blockTypeCountPartial = new HashMap<String, Integer>();
    private int xOff = 0;
    private int yOff = 0;
    private int zOff = 0;
    private RenderBlockTarget focusedTarget = null;
    private Direction focusedFace = null;

    @Override
    public String getUpgradeID() {
        return "blockTracker";
    }

    @Override
    public void tick(PlayerEntity player, int rangeUpgrades) {
        SearchUpgradeHandler searchHandler = HUDHandler.instance().getSpecificRenderer(SearchUpgradeHandler.class);
        int blockTrackRange = 30 + Math.min(rangeUpgrades, 5) * 5;
        long now = System.nanoTime();
        BlockPos.Mutable pos = new BlockPos.Mutable();
        for (int i = 0; i < 50000 && ((i & 0xFF) != 0 || System.nanoTime() - now <= (long)(PNCConfig.Client.Armor.blockTrackerMaxTimePerTick * 500000)); ++i) {
            List<IBlockTrackEntry> entries;
            TileEntity te;
            this.nextScanPos(pos, player, blockTrackRange);
            if (!player.field_70170_p.isAreaLoaded((BlockPos)pos, 0)) break;
            if (player.field_70170_p.func_175623_d((BlockPos)pos) || MinecraftForge.EVENT_BUS.post((Event)new BlockTrackEvent(player.field_70170_p, (BlockPos)pos, te = player.field_70170_p.func_175625_s((BlockPos)pos)))) continue;
            if (searchHandler != null && te != null && te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).isPresent()) {
                searchHandler.checkInventoryForItems(te, null, WidgetKeybindCheckBox.isHandlerEnabled(searchHandler));
            }
            if ((entries = BlockTrackEntryList.instance.getEntriesForCoordinate((IBlockReader)player.field_70170_p, (BlockPos)pos, te)).isEmpty()) continue;
            entries.forEach(entry -> {
                String k = entry.getEntryName();
                this.blockTypeCountPartial.put(k, this.blockTypeCountPartial.getOrDefault(k, 0) + 1);
            });
            RenderBlockTarget blockTarget = this.blockTargets.get(pos);
            if (blockTarget != null) {
                blockTarget.ticksExisted = Math.abs(blockTarget.ticksExisted);
                blockTarget.setTileEntity(te);
                continue;
            }
            RenderBlockTarget target = this.addBlockTarget(new RenderBlockTarget(player.field_70170_p, player, pos.func_185334_h(), te, this));
            target.maybeRefreshFromServer(entries);
        }
        this.checkBlockFocus(player, blockTrackRange);
        this.processTrackerEntries(player, blockTrackRange);
        this.updateTrackerText();
    }

    private void checkBlockFocus(PlayerEntity player, int blockTrackRange) {
        Vec3d eyes;
        this.focusedTarget = null;
        this.focusedFace = null;
        Vec3d v = eyes = player.func_174824_e(1.0f);
        Vec3d lookVec = player.func_70040_Z();
        for (int i = 0; i < blockTrackRange * 4; ++i) {
            BlockState state;
            BlockRayTraceResult brtr;
            v = v.func_178787_e(lookVec.func_186678_a(0.25));
            BlockPos checkPos = new BlockPos(v.field_72450_a, v.field_72448_b, v.field_72449_c);
            if (!this.blockTargets.containsKey(checkPos) || (brtr = (state = player.field_70170_p.func_180495_p(checkPos)).func_196954_c((IBlockReader)player.field_70170_p, checkPos).func_212433_a(eyes, v, checkPos)) == null || brtr.func_216346_c() != RayTraceResult.Type.BLOCK) continue;
            this.focusedTarget = this.blockTargets.get(checkPos);
            this.focusedFace = brtr.func_216354_b();
            break;
        }
    }

    public BlockPos getFocusedPos() {
        return this.focusedTarget == null ? null : this.focusedTarget.getPos();
    }

    public Direction getFocusedFace() {
        return this.focusedFace;
    }

    private void nextScanPos(BlockPos.Mutable pos, PlayerEntity player, int range) {
        Direction dir = PneumaticCraftUtils.getDirectionFacing((LivingEntity)player, true);
        switch (dir) {
            case UP: {
                if (++this.xOff <= range) break;
                this.xOff = -range;
                if (++this.yOff <= range) break;
                this.yOff = 0;
                if (++this.zOff <= range) break;
                this.zOff = -range;
                this.updateBlockTypeCounts();
                break;
            }
            case DOWN: {
                if (++this.xOff <= range) break;
                this.xOff = -range;
                if (--this.yOff >= -range) break;
                this.yOff = 0;
                if (++this.zOff <= range) break;
                this.zOff = -range;
                this.updateBlockTypeCounts();
                break;
            }
            case EAST: {
                if (++this.xOff <= range) break;
                this.xOff = 0;
                if (++this.yOff <= range) break;
                this.yOff = -range;
                if (++this.zOff <= range) break;
                this.zOff = -range;
                this.updateBlockTypeCounts();
                break;
            }
            case WEST: {
                if (--this.xOff >= -range) break;
                this.xOff = 0;
                if (++this.yOff <= range) break;
                this.yOff = -range;
                if (++this.zOff <= range) break;
                this.zOff = -range;
                this.updateBlockTypeCounts();
                break;
            }
            case NORTH: {
                if (++this.xOff <= range) break;
                this.xOff = -range;
                if (++this.yOff <= range) break;
                this.yOff = -range;
                if (--this.zOff >= -range) break;
                this.zOff = 0;
                this.updateBlockTypeCounts();
                break;
            }
            case SOUTH: {
                if (++this.xOff <= range) break;
                this.xOff = -range;
                if (++this.yOff <= range) break;
                this.yOff = -range;
                if (++this.zOff <= range) break;
                this.zOff = 0;
                this.updateBlockTypeCounts();
            }
        }
        pos.func_189532_c(player.func_226277_ct_() + (double)this.xOff, MathHelper.func_151237_a((double)(player.func_226278_cu_() + (double)this.yOff), (double)0.0, (double)255.0), player.func_226281_cx_() + (double)this.zOff);
    }

    private void updateBlockTypeCounts() {
        this.blockTypeCount.clear();
        this.blockTypeCountPartial.forEach(this.blockTypeCount::put);
        this.blockTypeCountPartial.clear();
    }

    private void processTrackerEntries(PlayerEntity player, int blockTrackRange) {
        ArrayList<RenderBlockTarget> toRemove = new ArrayList<RenderBlockTarget>();
        for (RenderBlockTarget blockTarget : this.blockTargets.values()) {
            boolean wasNegative = blockTarget.ticksExisted < 0;
            blockTarget.ticksExisted += CommonArmorHandler.getHandlerForPlayer(player).getSpeedFromUpgrades(EquipmentSlotType.HEAD);
            if (blockTarget.ticksExisted >= 0 && wasNegative) {
                blockTarget.ticksExisted = -1;
            }
            blockTarget.update();
            if (!(blockTarget.getDistanceToEntity((Entity)player) > (double)(blockTrackRange + 5)) && blockTarget.isTargetStillValid()) continue;
            if (blockTarget.ticksExisted > 0) {
                blockTarget.ticksExisted = -60;
                continue;
            }
            if (blockTarget.ticksExisted != -1) continue;
            toRemove.add(blockTarget);
        }
        toRemove.forEach(this::removeBlockTarget);
    }

    private void updateTrackerText() {
        ArrayList<String> textList = new ArrayList<String>();
        if (this.focusedTarget != null) {
            this.blockTrackInfo.setTitle(this.focusedTarget.stat.getTitle());
            textList.addAll(this.focusedTarget.textList);
        } else {
            this.blockTrackInfo.setTitle("Current tracked blocks:");
            this.blockTypeCount.forEach((k, v) -> {
                if (v > 0 && WidgetKeybindCheckBox.fromKeyBindingName((String)k).checked) {
                    textList.add(v + " " + I18n.func_135052_a((String)("pneumaticcraft.armor.upgrade." + k), (Object[])new Object[0]));
                }
            });
            if (textList.size() == 0) {
                textList.add("Tracking no blocks currently.");
            }
        }
        this.blockTrackInfo.setText(textList);
    }

    private RenderBlockTarget addBlockTarget(RenderBlockTarget blockTarget) {
        this.blockTargets.put(blockTarget.getPos(), blockTarget);
        return blockTarget;
    }

    private void removeBlockTarget(RenderBlockTarget blockTarget) {
        this.blockTargets.remove(blockTarget.getPos());
    }

    public int countBlockTrackersOfType(IBlockTrackEntry type) {
        return this.blockTypeCount.getOrDefault(type.getEntryName(), 0);
    }

    @Override
    public void render3D(MatrixStack matrixStack, IRenderTypeBuffer buffer, float partialTicks) {
        this.blockTargets.values().forEach(t -> t.render(matrixStack, buffer, partialTicks));
    }

    @Override
    public void render2D(float partialTicks, boolean helmetEnabled) {
    }

    @Override
    public EnumUpgrade[] getRequiredUpgrades() {
        return new EnumUpgrade[]{EnumUpgrade.BLOCK_TRACKER};
    }

    @Override
    public void reset() {
        this.blockTypeCountPartial.clear();
        this.blockTypeCount.clear();
        this.blockTrackInfo = null;
    }

    @Override
    public float getEnergyUsage(int rangeUpgrades, PlayerEntity player) {
        return 1.0f * (1.0f + (float)Math.min(5, rangeUpgrades) * 5.0f / 30.0f) * (float)CommonArmorHandler.getHandlerForPlayer(player).getSpeedFromUpgrades(EquipmentSlotType.HEAD);
    }

    @Override
    public IOptionPage getGuiOptionsPage(IGuiScreen screen) {
        return new GuiBlockTrackOptions(screen, this);
    }

    @Override
    public EquipmentSlotType getEquipmentSlot() {
        return EquipmentSlotType.HEAD;
    }

    @Override
    public WidgetAnimatedStat getAnimatedStat() {
        if (this.blockTrackInfo == null) {
            WidgetAnimatedStat.StatIcon icon = WidgetAnimatedStat.StatIcon.of(EnumUpgrade.BLOCK_TRACKER.getItemStack());
            this.blockTrackInfo = new WidgetAnimatedStat(null, "Current tracked blocks:", icon, 0x3000AA00, null, ArmorHUDLayout.INSTANCE.blockTrackerStat);
            this.blockTrackInfo.setMinDimensionsAndReset(0, 0);
        }
        return this.blockTrackInfo;
    }

    public void hack() {
        for (RenderBlockTarget target : this.blockTargets.values()) {
            target.hack();
        }
    }

    public RenderBlockTarget getTargetForCoord(BlockPos pos) {
        return this.blockTargets.get(pos);
    }

    public boolean scroll(InputEvent.MouseScrollEvent event) {
        for (RenderBlockTarget target : this.blockTargets.values()) {
            if (!target.scroll(event)) continue;
            this.getAnimatedStat().mouseScrolled(event.getMouseX(), event.getMouseY(), event.getScrollDelta());
            return true;
        }
        return false;
    }

    @Override
    public void onResolutionChanged() {
        this.blockTrackInfo = null;
    }
}

