/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pressure_gauge;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;

public class PressureGaugeRenderer {
    static final int CIRCLE_POINTS = 500;
    static final double RADIUS = 20.0;
    private static final double START_ANGLE = 4.1887902047863905;
    static final double STOP_ANGLE = -1.0471975511965976;
    static final int GAUGE_POINTS = 416;
    static final float[] RED = new float[]{0.7f, 0.0f, 0.0f, 1.0f};
    static final float[] GREEN = new float[]{0.0f, 0.7f, 0.0f, 1.0f};
    static final float[] YELLOW = new float[]{0.9f, 0.9f, 0.0f, 1.0f};

    public static void drawPressureGauge(FontRenderer fontRenderer, float minPressure, float maxPressure, float dangerPressure, float minWorkingPressure, float currentPressure, int xPos, int yPos) {
        PressureGaugeRenderer.drawPressureGauge(fontRenderer, minPressure, maxPressure, dangerPressure, minWorkingPressure, currentPressure, xPos, yPos, -16777216);
    }

    public static void drawPressureGauge(FontRenderer fontRenderer, float minPressure, float maxPressure, float dangerPressure, float minWorkingPressure, float currentPressure, int xPos, int yPos, int fgColor) {
        RenderSystem.disableTexture();
        RenderSystem.lineWidth((float)2.0f);
        BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
        wr.func_181668_a(6, DefaultVertexFormats.field_181706_f);
        PressureGaugeRenderer.drawGaugeBackground((IVertexBuilder)wr, minPressure, maxPressure, dangerPressure, minWorkingPressure, xPos, yPos);
        Tessellator.func_178181_a().func_78381_a();
        wr.func_181668_a(2, DefaultVertexFormats.field_181706_f);
        PressureGaugeRenderer.drawGaugeSurround((IVertexBuilder)wr, xPos, yPos, fgColor);
        Tessellator.func_178181_a().func_78381_a();
        int currentScale = (int)maxPressure;
        ArrayList<TextScaler> textScalers = new ArrayList<TextScaler>();
        wr.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        PressureGaugeRenderer.drawScale((IVertexBuilder)wr, minPressure, maxPressure, xPos, yPos, currentScale, textScalers);
        Tessellator.func_178181_a().func_78381_a();
        double angleIndicator = 416 - (int)((currentPressure - minPressure) / (maxPressure - minPressure) * 416.0f);
        angleIndicator = -angleIndicator / 500.0 * 2.0 * Math.PI - -1.0471975511965976;
        wr.func_181668_a(2, DefaultVertexFormats.field_181706_f);
        PressureGaugeRenderer.drawNeedle((IVertexBuilder)wr, xPos, yPos, angleIndicator, fgColor);
        Tessellator.func_178181_a().func_78381_a();
        RenderSystem.enableTexture();
        PressureGaugeRenderer.drawText(fontRenderer, xPos, yPos, fgColor, textScalers);
    }

    private static void drawNeedle(IVertexBuilder builder, int xPos, int yPos, double angle, int fgColor) {
        float[] cols = RenderUtils.decomposeColorF(fgColor);
        builder.func_225582_a_(Math.cos(angle + 2.796017461694916) * 20.0 * 0.3 + (double)xPos, Math.sin(angle + 2.796017461694916) * 20.0 * 0.3 + (double)yPos, 0.0).func_227885_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
        builder.func_225582_a_(Math.cos(angle + 3.4871678454846706) * 20.0 * 0.3 + (double)xPos, Math.sin(angle + 3.4871678454846706) * 20.0 * 0.3 + (double)yPos, 0.0).func_227885_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
        builder.func_225582_a_(Math.cos(angle) * 20.0 * 0.8 + (double)xPos, Math.sin(angle) * 20.0 * 0.8 + (double)yPos, 0.0).func_227885_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
    }

    private static void drawScale(IVertexBuilder builder, float minPressure, float maxPressure, int xPos, int yPos, int currentScale, List<TextScaler> textScalers) {
        for (int i = 0; i <= 416; ++i) {
            double angle = (double)(-i) / 500.0 * 2.0 * Math.PI - -1.0471975511965976;
            if (i != 416 - (int)(((float)currentScale - minPressure) / (maxPressure - minPressure) * 416.0f)) continue;
            double x = Math.cos(angle);
            double y = Math.sin(angle);
            textScalers.add(new TextScaler(currentScale, (int)(x * 20.0 * 1.25), (int)(y * 20.0 * 1.25)));
            --currentScale;
            double r1 = maxPressure > 10.0f && textScalers.size() % 5 == 1 ? 0.8 : 0.92;
            double r2 = maxPressure > 10.0f && textScalers.size() % 5 == 1 ? 1.15 : 1.08;
            builder.func_225582_a_(x * 20.0 * r1 + (double)xPos, y * 20.0 * r1 + (double)yPos, 0.0).func_225586_a_(0, 0, 0, 1).func_181675_d();
            builder.func_225582_a_(x * 20.0 * r2 + (double)xPos, y * 20.0 * r2 + (double)yPos, 0.0).func_225586_a_(0, 0, 0, 1).func_181675_d();
        }
    }

    private static void drawText(FontRenderer fontRenderer, int xPos, int yPos, int fgColor, List<TextScaler> textScalers) {
        for (int i = 0; i < textScalers.size(); ++i) {
            if (textScalers.size() > 11 && i % 5 != 0) continue;
            TextScaler scaler = textScalers.get(i);
            RenderSystem.pushMatrix();
            RenderSystem.translated((double)((double)(xPos + scaler.x) - 1.5), (double)((double)(yPos + scaler.y) - 1.5), (double)0.0);
            RenderSystem.scaled((double)0.5, (double)0.5, (double)1.0);
            fontRenderer.func_211126_b(Integer.toString(scaler.pressure), 0.0f, 0.0f, fgColor);
            RenderSystem.popMatrix();
        }
    }

    private static void drawGaugeBackground(IVertexBuilder builder, float minPressure, float maxPressure, float dangerPressure, float minWorkingPressure, int xPos, int yPos) {
        float[] color = RED;
        builder.func_225582_a_((double)xPos, (double)yPos, 0.0).func_227885_a_(color[0], color[1], color[2], color[3]).func_181675_d();
        int explodeBoundary = 416 - (int)((dangerPressure - minPressure) / (maxPressure - minPressure) * 416.0f);
        int workingBoundary = 416 - (int)((minWorkingPressure - minPressure) / (maxPressure - minPressure) * 416.0f);
        boolean changedColorGreen = false;
        boolean changedColorYellow = false;
        for (int i = 0; i < 416; ++i) {
            if (i == explodeBoundary && !changedColorGreen) {
                color = minWorkingPressure < 0.0f && minWorkingPressure >= -1.0f ? YELLOW : GREEN;
                builder.func_225582_a_((double)xPos, (double)yPos, 0.0).func_227885_a_(color[0], color[1], color[2], color[3]).func_181675_d();
                --i;
                changedColorGreen = true;
            }
            if (i == workingBoundary && !changedColorYellow) {
                color = minWorkingPressure < 0.0f && minWorkingPressure >= -1.0f ? GREEN : YELLOW;
                builder.func_225582_a_((double)xPos, (double)yPos, 0.0).func_227885_a_(color[0], color[1], color[2], color[3]).func_181675_d();
                --i;
                changedColorYellow = true;
            }
            double angle = (double)(-i) / 500.0 * 2.0 * Math.PI - -1.0471975511965976;
            builder.func_225582_a_(Math.cos(angle) * 20.0 + (double)xPos, Math.sin(angle) * 20.0 + (double)yPos, 0.0).func_227885_a_(color[0], color[1], color[2], color[3]).func_181675_d();
        }
    }

    private static void drawGaugeSurround(IVertexBuilder builder, int xPos, int yPos, int fgColor) {
        float[] cols = RenderUtils.decomposeColorF(fgColor);
        for (int i = 0; i < 500; ++i) {
            double angle = (double)i / 500.0 * 2.0 * Math.PI;
            builder.func_225582_a_(Math.cos(angle) * 20.0 + (double)xPos, Math.sin(angle) * 20.0 + (double)yPos, 0.0).func_227885_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
        }
    }

    static class TextScaler {
        final int pressure;
        final int x;
        final int y;

        TextScaler(int pressure, int x, int y) {
            this.pressure = pressure;
            this.x = x;
            this.y = y;
        }
    }
}

