/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.util;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;

public class GuiUtils {
    private static final ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
    private static final int TEX_WIDTH = 16;
    private static final int TEX_HEIGHT = 16;

    public static void drawItemStack(ItemStack stack, int x, int y) {
        RenderSystem.enableRescaleNormal();
        RenderHelper.func_227780_a_();
        GlStateManager.func_227734_k_();
        itemRenderer.func_180450_b(stack, x, y);
        RenderHelper.func_74518_a();
        RenderSystem.disableRescaleNormal();
    }

    public static void drawItemStack(@Nonnull ItemStack stack, int x, int y, String text) {
        RenderSystem.enableRescaleNormal();
        RenderSystem.enableDepthTest();
        RenderHelper.func_227780_a_();
        RenderSystem.pushMatrix();
        FontRenderer font = null;
        if (!stack.func_190926_b()) {
            font = stack.func_77973_b().getFontRenderer(stack);
        }
        if (font == null) {
            font = Minecraft.func_71410_x().field_71466_p;
        }
        itemRenderer.func_180450_b(stack, x, y);
        itemRenderer.func_180453_a(font, stack, x, y, text);
        RenderSystem.popMatrix();
        RenderHelper.func_74518_a();
        RenderSystem.disableRescaleNormal();
    }

    public static void drawFluid(Rectangle2d bounds, @Nullable FluidStack fluidStack, @Nullable IFluidTank tank) {
        int scaledAmount;
        if (fluidStack == null || fluidStack.getFluid() == null) {
            return;
        }
        Fluid fluid = fluidStack.getFluid();
        ResourceLocation fluidStill = fluid.getAttributes().getStillTexture(fluidStack);
        TextureAtlasSprite fluidStillSprite = fluidStill != null ? (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(fluidStill) : null;
        int fluidColor = fluid.getAttributes().getColor(fluidStack);
        int n = scaledAmount = tank == null ? bounds.func_199317_d() : fluidStack.getAmount() * bounds.func_199317_d() / tank.getCapacity();
        if (fluidStack.getAmount() > 0 && scaledAmount < 1) {
            scaledAmount = 1;
        }
        scaledAmount = Math.min(scaledAmount, bounds.func_199317_d());
        Minecraft.func_71410_x().func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        GuiUtils.glColorHex(fluidColor);
        int xTileCount = bounds.func_199316_c() / 16;
        int xRemainder = bounds.func_199316_c() - xTileCount * 16;
        int yTileCount = scaledAmount / 16;
        int yRemainder = scaledAmount - yTileCount * 16;
        int yStart = bounds.func_199319_b() + bounds.func_199317_d();
        if (fluid.getAttributes().getDensity() < 0) {
            yStart -= bounds.func_199317_d() - scaledAmount;
        }
        for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            for (int yTile = 0; yTile <= yTileCount; ++yTile) {
                int w = xTile == xTileCount ? xRemainder : 16;
                int h = yTile == yTileCount ? yRemainder : 16;
                int x = bounds.func_199318_a() + xTile * 16;
                int y = yStart - (yTile + 1) * 16;
                if (bounds.func_199316_c() <= 0 || h <= 0) continue;
                int maskTop = 16 - h;
                int maskRight = 16 - w;
                GuiUtils.drawFluidTexture(x, y, fluidStillSprite, maskTop, maskRight, 100.0);
            }
        }
        RenderSystem.disableBlend();
    }

    private static void drawFluidTexture(double xCoord, double yCoord, TextureAtlasSprite textureSprite, int maskTop, int maskRight, double zLevel) {
        float uMin = textureSprite.func_94209_e();
        float uMax = textureSprite.func_94212_f();
        float vMin = textureSprite.func_94206_g();
        float vMax = textureSprite.func_94210_h();
        uMax -= (float)maskRight / 16.0f * (uMax - uMin);
        vMax -= (float)maskTop / 16.0f * (vMax - vMin);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldrenderer.func_225582_a_(xCoord, yCoord + 16.0, zLevel).func_225583_a_(uMin, vMax).func_181675_d();
        worldrenderer.func_225582_a_(xCoord + 16.0 - (double)maskRight, yCoord + 16.0, zLevel).func_225583_a_(uMax, vMax).func_181675_d();
        worldrenderer.func_225582_a_(xCoord + 16.0 - (double)maskRight, yCoord + (double)maskTop, zLevel).func_225583_a_(uMax, vMin).func_181675_d();
        worldrenderer.func_225582_a_(xCoord, yCoord + (double)maskTop, zLevel).func_225583_a_(uMin, vMin).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void showPopupHelpScreen(Screen screen, FontRenderer fontRenderer, List<String> helpText) {
        int y;
        int x;
        int boxWidth = 0;
        int n = helpText.size();
        fontRenderer.getClass();
        int boxHeight = n * 9;
        for (String s : helpText) {
            boxWidth = Math.max(boxWidth, fontRenderer.func_78256_a(s));
        }
        if (screen instanceof ContainerScreen) {
            x = (((ContainerScreen)screen).getXSize() - boxWidth) / 2;
            y = (((ContainerScreen)screen).getYSize() - boxHeight) / 2;
        } else {
            x = (screen.width - boxWidth) / 2;
            y = (screen.height - boxHeight) / 2;
        }
        RenderSystem.translated((double)0.0, (double)0.0, (double)400.0);
        AbstractGui.fill((int)(x - 4), (int)(y - 4), (int)(x + boxWidth + 8), (int)(y + boxHeight + 8), (int)-1073741824);
        AbstractGui.fill((int)(x - 4), (int)(y - 4), (int)(x + boxWidth + 8), (int)(y - 3), (int)-8355712);
        AbstractGui.fill((int)(x - 4), (int)(y + boxHeight + 8), (int)(x + boxWidth + 8), (int)(y + boxHeight + 9), (int)-8355712);
        AbstractGui.fill((int)(x - 4), (int)(y - 4), (int)(x - 3), (int)(y + boxHeight + 8), (int)-8355712);
        AbstractGui.fill((int)(x + boxWidth + 8), (int)(y - 4), (int)(x + boxWidth + 9), (int)(y + boxHeight + 8), (int)-8355712);
        for (String s : helpText) {
            fontRenderer.func_211126_b(s, (float)x, (float)y, -2039584);
            fontRenderer.getClass();
            y += 9;
        }
        RenderSystem.translated((double)0.0, (double)0.0, (double)-400.0);
    }

    public static void drawTexture(ResourceLocation texture, int x, int y) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        RenderSystem.enableTexture();
        BufferBuilder builder = Tessellator.func_178181_a().func_178180_c();
        builder.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
        builder.func_225582_a_((double)x, (double)(y + 16), 0.0).func_225586_a_(255, 255, 255, 255).func_225583_a_(0.0f, 1.0f).func_181675_d();
        builder.func_225582_a_((double)(x + 16), (double)(y + 16), 0.0).func_225586_a_(255, 255, 255, 255).func_225583_a_(1.0f, 1.0f).func_181675_d();
        builder.func_225582_a_((double)(x + 16), (double)y, 0.0).func_225586_a_(255, 255, 255, 255).func_225583_a_(1.0f, 0.0f).func_181675_d();
        builder.func_225582_a_((double)x, (double)y, 0.0).func_225586_a_(255, 255, 255, 255).func_225583_a_(0.0f, 0.0f).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    public static void drawUntexturedQuad(BufferBuilder renderer, double x, double y, double z, double width, int height, int red, int green, int blue, int alpha) {
        renderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        renderer.func_225582_a_(x, y, z).func_225586_a_(red, green, blue, alpha).func_181675_d();
        renderer.func_225582_a_(x, y + (double)height, z).func_225586_a_(red, green, blue, alpha).func_181675_d();
        renderer.func_225582_a_(x + width, y + (double)height, z).func_225586_a_(red, green, blue, alpha).func_181675_d();
        renderer.func_225582_a_(x + width, y, z).func_225586_a_(red, green, blue, alpha).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    public static void drawOutline(BufferBuilder renderer, double x, double y, double z, double width, int height, int red, int green, int blue, int alpha) {
        renderer.func_181668_a(2, DefaultVertexFormats.field_181706_f);
        renderer.func_225582_a_(x, y, z).func_225586_a_(red, green, blue, alpha).func_181675_d();
        renderer.func_225582_a_(x, y + (double)height, z).func_225586_a_(red, green, blue, alpha).func_181675_d();
        renderer.func_225582_a_(x + width, y + (double)height, z).func_225586_a_(red, green, blue, alpha).func_181675_d();
        renderer.func_225582_a_(x + width, y, z).func_225586_a_(red, green, blue, alpha).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    public static void glColorHex(int color) {
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        RenderSystem.color4f((float)red, (float)green, (float)blue, (float)alpha);
    }

    public static void glColorHex(int color, int alpha) {
        GuiUtils.glColorHex(color | alpha << 24);
    }

    public static void drawScaledText(FontRenderer fr, String text, int x, int y, int color, float scale) {
        if (scale != 1.0f) {
            RenderSystem.pushMatrix();
            RenderSystem.translated((double)x, (double)y, (double)0.0);
            RenderSystem.scaled((double)scale, (double)scale, (double)scale);
            fr.func_211126_b(text, 0.0f, 0.0f, color);
            RenderSystem.popMatrix();
        } else {
            fr.func_211126_b(text, (float)x, (float)y, color);
        }
    }
}

