/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.ai;

import me.desht.pneumaticcraft.common.ai.DroneEntityBase;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.config.PNCConfig;
import me.desht.pneumaticcraft.common.progwidgets.IEntityProvider;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class DroneAIEntityImport
extends DroneEntityBase<IEntityProvider, Entity> {
    public DroneAIEntityImport(IDroneBase drone, IEntityProvider progWidget) {
        super(drone, progWidget);
    }

    @Override
    protected boolean isEntityValid(Entity entity) {
        if (entity instanceof LivingEntity || entity instanceof AbstractMinecartEntity || entity instanceof BoatEntity) {
            return this.drone.getCarryingEntities().isEmpty();
        }
        if (PNCConfig.Common.General.dronesCanImportXPOrbs && entity instanceof ExperienceOrbEntity) {
            return (Boolean)this.drone.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).map(handler -> PneumaticCraftUtils.fillTankWithOrb(handler, (ExperienceOrbEntity)entity, IFluidHandler.FluidAction.SIMULATE)).orElse((Object)false);
        }
        return false;
    }

    @Override
    protected boolean doAction() {
        if (PNCConfig.Common.General.dronesCanImportXPOrbs && this.targetedEntity instanceof ExperienceOrbEntity) {
            this.drone.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).ifPresent(handler -> {
                if (PneumaticCraftUtils.fillTankWithOrb(handler, (ExperienceOrbEntity)this.targetedEntity, IFluidHandler.FluidAction.EXECUTE)) {
                    this.targetedEntity.func_70106_y();
                }
            });
        } else {
            this.drone.setCarryingEntity(this.targetedEntity);
        }
        return false;
    }
}

