/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import me.desht.pneumaticcraft.common.block.BlockPressureChamberWallBase;
import me.desht.pneumaticcraft.common.block.IBlockPressureChamber;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPressureChamberValve;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPressureChamberWall;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;

public class BlockPressureChamberWall
extends BlockPressureChamberWallBase {
    private static final EnumProperty<EnumWallState> WALL_STATE = EnumProperty.func_177709_a((String)"wall_state", EnumWallState.class);

    public BlockPressureChamberWall() {
        super(IBlockPressureChamber.pressureChamberBlockProps());
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{WALL_STATE});
    }

    public BlockState updateState(BlockState state, IBlockReader world, BlockPos pos) {
        return PneumaticCraftUtils.getTileEntityAt(world, pos, TileEntityPressureChamberWall.class).map(wall -> {
            EnumWallState wallState = EnumWallState.NONE;
            TileEntityPressureChamberValve core = wall.getCore();
            if (core != null) {
                boolean zMax;
                boolean xMin = pos.func_177958_n() == core.multiBlockX;
                boolean yMin = pos.func_177956_o() == core.multiBlockY;
                boolean zMin = pos.func_177952_p() == core.multiBlockZ;
                boolean xMax = pos.func_177958_n() == core.multiBlockX + core.multiBlockSize - 1;
                boolean yMax = pos.func_177956_o() == core.multiBlockY + core.multiBlockSize - 1;
                boolean bl = zMax = pos.func_177952_p() == core.multiBlockZ + core.multiBlockSize - 1;
                wallState = xMin && yMin && zMin || xMax && yMax && zMax ? EnumWallState.XMIN_YMIN_ZMIN : (xMin && yMin && zMax || xMax && yMax && zMin ? EnumWallState.XMIN_YMIN_ZMAX : (xMin && yMax && zMax || xMax && yMin && zMin ? EnumWallState.XMIN_YMAX_ZMAX : (xMin && yMax && zMin || xMax && yMin && zMax ? EnumWallState.XMIN_YMAX_ZMIN : (yMin && xMin || yMax && xMax || yMin && xMax || yMax && xMin ? EnumWallState.XEDGE : (yMin && zMin || yMax && zMax || yMin && zMax || yMax && zMin ? EnumWallState.ZEDGE : (!yMin && !yMax ? (xMin && zMin || xMax && zMax || xMin && zMax || xMax && zMin ? EnumWallState.YEDGE : EnumWallState.CENTER) : EnumWallState.CENTER))))));
            }
            return (BlockState)state.func_206870_a(WALL_STATE, (Comparable)((Object)wallState));
        }).orElse(state);
    }

    public static enum EnumWallState implements IStringSerializable
    {
        NONE,
        CENTER,
        XEDGE,
        ZEDGE,
        YEDGE,
        XMIN_YMIN_ZMIN,
        XMIN_YMIN_ZMAX,
        XMIN_YMAX_ZMIN,
        XMIN_YMAX_ZMAX;


        public String func_176610_l() {
            return this.toString().toLowerCase();
        }
    }
}

