/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.tubes;

import java.util.List;
import java.util.Objects;
import me.desht.pneumaticcraft.common.block.tubes.INetworkedModule;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.item.ItemTubeModule;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketOpenTubeModuleGui;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPressureTube;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class TubeModule {
    public static final float MAX_VALUE = 30.0f;
    private final ItemTubeModule item;
    protected TileEntityPressureTube pressureTube;
    protected Direction dir = Direction.UP;
    private final VoxelShape[] boundingBoxes;
    protected boolean upgraded;
    public float lowerBound = 4.9f;
    public float higherBound = 0.0f;
    private boolean fake;
    public boolean advancedConfig;
    public boolean shouldDrop;

    public TubeModule(ItemTubeModule item) {
        this.item = item;
        double w = this.getWidth() / 2.0;
        double h = this.getHeight();
        this.boundingBoxes = new VoxelShape[]{Block.func_208617_a((double)(8.0 - w), (double)(6.0 - h), (double)(8.0 - w), (double)(8.0 + w), (double)6.0, (double)(8.0 + w)), Block.func_208617_a((double)(8.0 - w), (double)10.0, (double)(8.0 - w), (double)(8.0 + w), (double)(10.0 + h), (double)(8.0 + w)), Block.func_208617_a((double)(8.0 - w), (double)(8.0 - w), (double)(6.0 - h), (double)(8.0 + w), (double)(8.0 + w), (double)6.0), Block.func_208617_a((double)(8.0 - w), (double)(8.0 - w), (double)10.0, (double)(8.0 + w), (double)(8.0 + w), (double)(10.0 + h)), Block.func_208617_a((double)(6.0 - h), (double)(8.0 - w), (double)(8.0 - w), (double)6.0, (double)(8.0 + w), (double)(8.0 + w)), Block.func_208617_a((double)10.0, (double)(8.0 - w), (double)(8.0 - w), (double)(10.0 + h), (double)(8.0 + w), (double)(8.0 + w))};
    }

    public void markFake() {
        this.fake = true;
    }

    public boolean isFake() {
        return this.fake;
    }

    public void setTube(TileEntityPressureTube pressureTube) {
        this.pressureTube = pressureTube;
    }

    public TileEntityPressureTube getTube() {
        return this.pressureTube;
    }

    public double getWidth() {
        return 4.0;
    }

    protected double getHeight() {
        return 6.0;
    }

    public float getThreshold(int redstone) {
        double slope = (this.higherBound - this.lowerBound) / 15.0f;
        double threshold = (double)this.lowerBound + slope * (double)redstone;
        return (float)threshold;
    }

    public NonNullList<ItemStack> getDrops() {
        NonNullList drops = NonNullList.func_191196_a();
        if (this.shouldDrop) {
            drops.add((Object)new ItemStack((IItemProvider)this.getItem()));
            if (this.upgraded) {
                drops.add((Object)new ItemStack((IItemProvider)ModItems.ADVANCED_PCB.get()));
            }
        }
        return drops;
    }

    public Item getItem() {
        return this.item;
    }

    public void setDirection(Direction dir) {
        this.dir = dir;
    }

    public Direction getDirection() {
        return this.dir;
    }

    public void readFromNBT(CompoundNBT nbt) {
        this.dir = Direction.func_82600_a((int)nbt.func_74762_e("dir"));
        this.upgraded = nbt.func_74767_n("upgraded");
        this.lowerBound = nbt.func_74760_g("lowerBound");
        this.higherBound = nbt.func_74760_g("higherBound");
        this.advancedConfig = !nbt.func_74764_b("advancedConfig") || nbt.func_74767_n("advancedConfig");
    }

    public void writeToNBT(CompoundNBT nbt) {
        nbt.func_74768_a("dir", this.dir.ordinal());
        nbt.func_74757_a("upgraded", this.upgraded);
        nbt.func_74776_a("lowerBound", this.lowerBound);
        nbt.func_74776_a("higherBound", this.higherBound);
        nbt.func_74757_a("advancedConfig", this.advancedConfig);
    }

    public void update() {
    }

    public void onNeighborTileUpdate() {
    }

    public void onNeighborBlockUpdate() {
    }

    public final ResourceLocation getType() {
        return this.item.getRegistryName();
    }

    public int getRedstoneLevel() {
        return 0;
    }

    void updateNeighbors() {
        this.pressureTube.func_145831_w().func_195593_d(this.pressureTube.func_174877_v(), this.pressureTube.func_145831_w().func_180495_p(this.pressureTube.func_174877_v()).func_177230_c());
    }

    public boolean isInline() {
        return false;
    }

    public void sendDescriptionPacket() {
        this.pressureTube.sendDescriptionPacket();
    }

    public void addInfo(List<ITextComponent> curInfo) {
        if (this.upgraded) {
            ItemStack stack = new ItemStack((IItemProvider)ModItems.ADVANCED_PCB.get());
            curInfo.add(stack.func_200301_q().func_150258_a(" installed").func_211708_a(TextFormatting.GREEN));
        }
        if (this instanceof INetworkedModule) {
            int colorChannel = ((INetworkedModule)((Object)this)).getColorChannel();
            String key = "color.minecraft." + DyeColor.func_196056_a((int)colorChannel);
            curInfo.add(new TranslationTextComponent("pneumaticcraft.waila.logisticsModule.channel", new Object[0]).func_150258_a(" ").func_150257_a(new TranslationTextComponent(key, new Object[0]).func_211708_a(TextFormatting.YELLOW)));
        }
    }

    public boolean canUpgrade() {
        return true;
    }

    public void upgrade() {
        this.upgraded = true;
    }

    public boolean isUpgraded() {
        return this.upgraded;
    }

    public boolean onActivated(PlayerEntity player, Hand hand) {
        if (!player.field_70170_p.field_72995_K && this.hasGui()) {
            NetworkHandler.sendToPlayer(new PacketOpenTubeModuleGui(this.getType(), this.pressureTube.func_174877_v()), (ServerPlayerEntity)player);
        }
        return true;
    }

    public boolean hasGui() {
        return false;
    }

    public VoxelShape getShape() {
        return this.boundingBoxes[this.getDirection().func_176745_a()];
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TubeModule)) {
            return false;
        }
        TubeModule that = (TubeModule)o;
        return Objects.equals(this.pressureTube.func_174877_v(), that.pressureTube.func_174877_v()) && this.dir == that.dir;
    }

    public int hashCode() {
        return Objects.hash(this.pressureTube.func_174877_v(), this.dir);
    }

    public void onPlaced() {
    }
}

