/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.tubes;

import java.util.List;
import me.desht.pneumaticcraft.common.block.tubes.TubeModule;
import me.desht.pneumaticcraft.common.item.ItemTubeModule;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;

public abstract class TubeModuleRedstoneReceiving
extends TubeModule {
    private int redstoneLevel;

    TubeModuleRedstoneReceiving(ItemTubeModule item) {
        super(item);
    }

    @Override
    public void readFromNBT(CompoundNBT tag) {
        super.readFromNBT(tag);
        this.redstoneLevel = tag.func_74762_e("redstone");
    }

    @Override
    public void writeToNBT(CompoundNBT tag) {
        super.writeToNBT(tag);
        tag.func_74768_a("redstone", this.redstoneLevel);
    }

    @Override
    public void addInfo(List<ITextComponent> curInfo) {
        super.addInfo(curInfo);
        curInfo.add(PneumaticCraftUtils.xlate("pneumaticcraft.waila.redstoneModule.receiving", this.redstoneLevel));
        curInfo.add(PneumaticCraftUtils.xlate("pneumaticcraft.waila.tubeModule.threshold", PneumaticCraftUtils.roundNumberTo(this.getThreshold(), 1)));
    }

    @Override
    public void onNeighborBlockUpdate() {
        this.redstoneLevel = this.pressureTube.func_145831_w().func_175687_A(this.pressureTube.func_174877_v());
    }

    public int getReceivingRedstoneLevel() {
        return this.redstoneLevel;
    }

    public float getThreshold() {
        return this.getThreshold(this.redstoneLevel);
    }

    @Override
    public boolean hasGui() {
        return this.upgraded;
    }

    @Override
    public void update() {
        if (this.upgraded && !this.advancedConfig && this.higherBound != this.lowerBound) {
            this.higherBound = this.lowerBound;
            if (!this.getTube().func_145831_w().field_72995_K) {
                this.sendDescriptionPacket();
            }
        }
    }
}

