/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.capabilities;

import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class FluidItemWrapper
implements ICapabilityProvider {
    private ItemStack stack;
    private final String tankName;
    private final int capacity;
    private final Predicate<Fluid> fluidPredicate;
    private final LazyOptional<IFluidHandlerItem> holder = LazyOptional.of(() -> new Handler());

    public FluidItemWrapper(ItemStack stack, String tankName, int capacity, Predicate<Fluid> fluidPredicate) {
        this.stack = stack;
        this.tankName = tankName;
        this.capacity = capacity;
        this.fluidPredicate = fluidPredicate;
    }

    public FluidItemWrapper(ItemStack stack, String tankName, int capacity) {
        this(stack, tankName, capacity, fluid -> true);
    }

    private void serializeTank(FluidTank tank, String tagName) {
        ItemStack newStack = this.stack.func_77946_l();
        CompoundNBT tag = newStack.func_190925_c("BlockEntityTag");
        CompoundNBT subTag = tag.func_74775_l("SavedTanks");
        if (!tank.getFluid().isEmpty()) {
            subTag.func_218657_a(tagName, (INBT)tank.writeToNBT(new CompoundNBT()));
        } else {
            subTag.func_82580_o(tagName);
        }
        if (!subTag.isEmpty()) {
            tag.func_218657_a("SavedTanks", (INBT)subTag);
        } else {
            tag.func_82580_o("SavedTanks");
            if (tag.isEmpty()) {
                newStack.func_77978_p().func_82580_o("BlockEntityTag");
                if (newStack.func_77978_p().isEmpty()) {
                    newStack.func_77982_d(null);
                }
            }
        }
        this.stack = newStack;
    }

    static FluidTank deserializeTank(ItemStack stack, String tagName, int capacity) {
        CompoundNBT tag = stack.func_179543_a("BlockEntityTag");
        if (tag != null && tag.func_74764_b("SavedTanks")) {
            FluidTank tank = new FluidTank(capacity);
            CompoundNBT subTag = tag.func_74775_l("SavedTanks");
            return tank.readFromNBT(subTag.func_74775_l(tagName));
        }
        return null;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        return CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY.orEmpty(capability, this.holder);
    }

    class Handler
    implements IFluidHandlerItem {
        private final FluidTank fluidTank;

        Handler() {
            FluidTank tank = FluidItemWrapper.deserializeTank(FluidItemWrapper.this.stack, FluidItemWrapper.this.tankName, FluidItemWrapper.this.capacity);
            this.fluidTank = tank == null ? new FluidTank(FluidItemWrapper.this.capacity) : tank;
        }

        @Nonnull
        public ItemStack getContainer() {
            return FluidItemWrapper.this.stack;
        }

        public int getTanks() {
            return this.fluidTank == null ? 0 : this.fluidTank.getTanks();
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return this.fluidTank == null ? FluidStack.EMPTY : this.fluidTank.getFluidInTank(tank);
        }

        public int getTankCapacity(int tank) {
            return this.fluidTank == null ? 0 : this.fluidTank.getTankCapacity(tank);
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return this.fluidTank != null && FluidItemWrapper.this.fluidPredicate.test(stack.getFluid()) && this.fluidTank.isFluidValid(tank, stack);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction doFill) {
            if (this.fluidTank == null) {
                return 0;
            }
            int filled = this.fluidTank.fill(resource, doFill);
            if (filled > 0 && doFill == IFluidHandler.FluidAction.EXECUTE) {
                FluidItemWrapper.this.serializeTank(this.fluidTank, FluidItemWrapper.this.tankName);
            }
            return filled;
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction doDrain) {
            if (this.fluidTank == null) {
                return FluidStack.EMPTY;
            }
            FluidStack drained = this.fluidTank.drain(resource, doDrain);
            if (!drained.isEmpty() && doDrain == IFluidHandler.FluidAction.EXECUTE) {
                FluidItemWrapper.this.serializeTank(this.fluidTank, FluidItemWrapper.this.tankName);
            }
            return drained;
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction doDrain) {
            if (this.fluidTank == null) {
                return FluidStack.EMPTY;
            }
            FluidStack drained = this.fluidTank.drain(maxDrain, doDrain);
            if (!drained.isEmpty() && doDrain == IFluidHandler.FluidAction.EXECUTE) {
                FluidItemWrapper.this.serializeTank(this.fluidTank, FluidItemWrapper.this.tankName);
            }
            return drained;
        }
    }
}

