/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.variables.GlobalVariableManager;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.BlockPosArgument;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.dimension.DimensionType;

public class ModCommands {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.func_197057_a((String)"dumpNBT").executes(ModCommands::dumpNBT));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"amadrone_deliver").then(Commands.func_197056_a((String)"toPos", (ArgumentType)BlockPosArgument.func_197276_a()).then(Commands.func_197056_a((String)"fromPos", (ArgumentType)BlockPosArgument.func_197276_a()).executes(ctx -> ModCommands.amadroneDeliver((CommandSource)ctx.getSource(), BlockPosArgument.func_197273_a((CommandContext)ctx, (String)"toPos"), BlockPosArgument.func_197273_a((CommandContext)ctx, (String)"fromPos")))))).then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).then(Commands.func_197056_a((String)"fromPos", (ArgumentType)BlockPosArgument.func_197276_a()).executes(ctx -> ModCommands.amadroneDeliver((CommandSource)ctx.getSource(), EntityArgument.func_197089_d((CommandContext)ctx, (String)"player").func_180425_c(), BlockPosArgument.func_197273_a((CommandContext)ctx, (String)"fromPos"))))));
        dispatcher.register((LiteralArgumentBuilder)Commands.func_197057_a((String)"get_global_var").then(Commands.func_197056_a((String)"varname", (ArgumentType)StringArgumentType.string()).executes(c -> ModCommands.getGlobalVar((CommandContext<CommandSource>)c, StringArgumentType.getString((CommandContext)c, (String)"varname")))));
        dispatcher.register((LiteralArgumentBuilder)Commands.func_197057_a((String)"set_global_var").then(Commands.func_197056_a((String)"varname", (ArgumentType)StringArgumentType.string()).then(Commands.func_197056_a((String)"pos", (ArgumentType)BlockPosArgument.func_197276_a()).executes(c -> ModCommands.setGlobalVar((CommandContext<CommandSource>)c, StringArgumentType.getString((CommandContext)c, (String)"varname"), BlockPosArgument.func_197273_a((CommandContext)c, (String)"pos"))))));
    }

    private static int dumpNBT(CommandContext<CommandSource> ctx) {
        CommandSource source = (CommandSource)ctx.getSource();
        if (source.func_197022_f() instanceof PlayerEntity) {
            ItemStack held = ((PlayerEntity)source.func_197022_f()).func_184614_ca();
            if (held.func_77978_p() == null) {
                source.func_197021_a((ITextComponent)new StringTextComponent("No NBT"));
                return 0;
            }
            if (held.func_77978_p().isEmpty()) {
                source.func_197021_a((ITextComponent)new StringTextComponent("Empty NBT"));
                return 0;
            }
            source.func_197030_a((ITextComponent)new StringTextComponent(held.func_77978_p().toString()), false);
            return 1;
        }
        return 0;
    }

    private static int amadroneDeliver(CommandSource source, BlockPos toPos, BlockPos fromPos) {
        TileEntity te = source.func_197023_e().func_175625_s(fromPos);
        int status = (Integer)IOHelper.getInventoryForTE(te).map(inv -> {
            ArrayList<ItemStack> deliveredStacks = new ArrayList<ItemStack>();
            for (int i = 0; i < inv.getSlots() && deliveredStacks.size() < 65; ++i) {
                if (inv.getStackInSlot(i).func_190926_b()) continue;
                deliveredStacks.add(inv.getStackInSlot(i));
            }
            if (deliveredStacks.size() > 0) {
                GlobalPos gPos = GlobalPos.func_218179_a((DimensionType)source.func_197023_e().field_73011_w.func_186058_p(), (BlockPos)toPos);
                PneumaticRegistry.getInstance().getDroneRegistry().deliverItemsAmazonStyle(gPos, deliveredStacks.toArray(new ItemStack[0]));
                source.func_197030_a(PneumaticCraftUtils.xlate("pneumaticcraft.command.deliverAmazon.success", PneumaticCraftUtils.posToString(fromPos), PneumaticCraftUtils.posToString(toPos)), false);
                return 1;
            }
            source.func_197021_a(PneumaticCraftUtils.xlate("pneumaticcraft.command.deliverAmazon.noItems", PneumaticCraftUtils.posToString(fromPos)));
            return 0;
        }).orElse((Object)-1);
        if (status == -1) {
            source.func_197021_a(PneumaticCraftUtils.xlate("pneumaticcraft.command.deliverAmazon.noInventory", PneumaticCraftUtils.posToString(fromPos)));
        }
        return status;
    }

    private static int getGlobalVar(CommandContext<CommandSource> ctx, String varName) {
        CommandSource source = (CommandSource)ctx.getSource();
        if (varName.startsWith("#")) {
            varName = varName.substring(1);
        }
        BlockPos pos = GlobalVariableManager.getInstance().getPos(varName);
        ItemStack stack = GlobalVariableManager.getInstance().getItem(varName);
        source.func_197030_a(PneumaticCraftUtils.xlate("pneumaticcraft.command.getGlobalVariable.output", varName, pos.toString(), stack.func_200301_q().func_150254_d()), false);
        return 1;
    }

    private static int setGlobalVar(CommandContext<CommandSource> ctx, String varName, BlockPos pos) {
        CommandSource source = (CommandSource)ctx.getSource();
        if (varName.startsWith("#")) {
            varName = varName.substring(1);
        }
        GlobalVariableManager.getInstance().set(varName, pos);
        source.func_197030_a(PneumaticCraftUtils.xlate("pneumaticcraft.command.setGlobalVariable.output", varName, pos.toString()), false);
        return 1;
    }
}

