/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.core;

import me.desht.pneumaticcraft.api.harvesting.HarvestHandler;
import me.desht.pneumaticcraft.common.harvesting.HarvestHandlerCactusLike;
import me.desht.pneumaticcraft.common.harvesting.HarvestHandlerCropLike;
import me.desht.pneumaticcraft.common.harvesting.HarvestHandlerCrops;
import me.desht.pneumaticcraft.common.harvesting.HarvestHandlerLeaves;
import me.desht.pneumaticcraft.common.harvesting.HarvestHandlerTree;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.CocoaBlock;
import net.minecraft.block.NetherWartBlock;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModHarvestHandlers {
    @SubscribeEvent
    public static void register(RegistryEvent.Register<HarvestHandler> event) {
        IForgeRegistry r = event.getRegistry();
        ModHarvestHandlers.register((IForgeRegistry<HarvestHandler>)r, "crops", new HarvestHandlerCrops());
        ModHarvestHandlers.register((IForgeRegistry<HarvestHandler>)r, "nether_wart", new HarvestHandlerCropLike(state -> state.func_177230_c() == Blocks.field_150388_bm, NetherWartBlock.field_176486_a, stack -> stack.func_77973_b() == Items.field_151075_bm));
        ModHarvestHandlers.register((IForgeRegistry<HarvestHandler>)r, "cocoa_beans", new HarvestHandlerCropLike(state -> state.func_177230_c() == Blocks.field_150375_by, CocoaBlock.field_176501_a, stack -> stack.func_77973_b() == Items.field_196130_bo));
        ModHarvestHandlers.register((IForgeRegistry<HarvestHandler>)r, "cactus_like", new HarvestHandlerCactusLike(state -> state.func_177230_c() == Blocks.field_150434_aF || state.func_177230_c() == Blocks.field_196608_cF));
        ModHarvestHandlers.register((IForgeRegistry<HarvestHandler>)r, "pumpkin_like", new HarvestHandler.SimpleHarvestHandler(Blocks.field_150423_aK, Blocks.field_150440_ba));
        ModHarvestHandlers.register((IForgeRegistry<HarvestHandler>)r, "leaves", new HarvestHandlerLeaves());
        ModHarvestHandlers.register((IForgeRegistry<HarvestHandler>)r, "trees", new HarvestHandlerTree());
    }

    private static void register(IForgeRegistry<HarvestHandler> r, String name, HarvestHandler handler) {
        r.register(handler.setRegistryName(PneumaticCraftUtils.RL(name)));
    }

    public static enum TreePart {
        LOG,
        LEAVES,
        SAPLING;


        public Block convert(Block in, TreePart to) {
            ResourceLocation rl = new ResourceLocation(in.getRegistryName().toString().replace("_" + this.toString().toLowerCase(), "_" + to.toString().toLowerCase()));
            return (Block)ForgeRegistries.BLOCKS.getValue(rl);
        }
    }
}

