/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.entity.projectile;

import com.mojang.authlib.GameProfile;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.common.core.ModEntities;
import me.desht.pneumaticcraft.common.util.fakeplayer.FakeNetHandlerPlayerServer;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.commons.lang3.Validate;

public class EntityTumblingBlock
extends ThrowableEntity {
    private static final DataParameter<BlockPos> ORIGIN = EntityDataManager.func_187226_a(EntityTumblingBlock.class, (IDataSerializer)DataSerializers.field_187200_j);
    private static final DataParameter<ItemStack> STATE_STACK = EntityDataManager.func_187226_a(EntityTumblingBlock.class, (IDataSerializer)DataSerializers.field_187196_f);
    private static FakePlayer fakePlayer;

    public EntityTumblingBlock(EntityType<EntityTumblingBlock> type, World worldIn) {
        super(type, worldIn);
    }

    public EntityTumblingBlock(World worldIn, LivingEntity thrower, double x, double y, double z, @Nonnull ItemStack stack) {
        super((EntityType)ModEntities.TUMBLING_BLOCK.get(), worldIn);
        Validate.isTrue((!stack.func_190926_b() && stack.func_77973_b() instanceof BlockItem ? 1 : 0) != 0);
        this.field_70192_c = thrower;
        this.field_70156_m = true;
        this.func_70107_b(x, y + (double)((1.0f - this.func_213302_cg()) / 2.0f), z);
        this.func_213293_j(0.0, 0.0, 0.0);
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
        this.setOrigin(new BlockPos((Entity)this));
        this.field_70180_af.func_187227_b(STATE_STACK, (Object)stack);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(ORIGIN, (Object)BlockPos.field_177992_a);
        this.field_70180_af.func_187214_a(STATE_STACK, (Object)ItemStack.field_190927_a);
    }

    public void func_184538_a(Entity entityThrower, float rotationPitchIn, float rotationYawIn, float pitchOffset, float velocity, float inaccuracy) {
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
    }

    public ItemStack getStack() {
        return (ItemStack)this.field_70180_af.func_187225_a(STATE_STACK);
    }

    @OnlyIn(value=Dist.CLIENT)
    public BlockPos getOrigin() {
        return (BlockPos)this.field_70180_af.func_187225_a(ORIGIN);
    }

    private void setOrigin(BlockPos pos) {
        this.field_70180_af.func_187227_b(ORIGIN, (Object)pos);
    }

    public void func_70071_h_() {
        this.field_70169_q = this.func_226277_ct_();
        this.field_70167_r = this.func_226278_cu_();
        this.field_70166_s = this.func_226281_cx_();
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            BlockPos blockpos1 = new BlockPos((Entity)this);
            if (!(this.field_70122_E || (this.field_70173_aa <= 100 || blockpos1.func_177956_o() >= 1 && blockpos1.func_177956_o() <= 256) && this.field_70173_aa <= 600)) {
                this.dropAsItem();
                this.func_70106_y();
            }
        }
    }

    protected void func_70184_a(RayTraceResult result) {
        if (!this.field_70170_p.field_72995_K) {
            this.func_70106_y();
            if (result.func_216346_c() == RayTraceResult.Type.BLOCK) {
                if (!this.tryPlaceAsBlock((BlockRayTraceResult)result)) {
                    this.dropAsItem();
                }
            } else {
                this.dropAsItem();
            }
        }
    }

    private boolean tryPlaceAsBlock(BlockRayTraceResult brtr) {
        BlockSnapshot snapshot;
        BlockPos pos;
        ItemStack stack = this.getStack();
        if (!(stack.func_77973_b() instanceof BlockItem)) {
            return false;
        }
        BlockPos pos0 = brtr.func_216350_a();
        Direction face = brtr.func_216354_b();
        PlayerEntity placer = this.func_85052_h() instanceof PlayerEntity ? (PlayerEntity)this.func_85052_h() : this.getFakePlayer();
        BlockState state = this.field_70170_p.func_180495_p(pos0);
        LocalBlockItemUseContext ctx = new LocalBlockItemUseContext(new ItemUseContext(placer, Hand.MAIN_HAND, brtr));
        BlockPos blockPos = pos = state.func_196953_a((BlockItemUseContext)ctx) ? pos0 : pos0.func_177972_a(face);
        if (this.field_70170_p.func_180495_p(pos).func_196953_a((BlockItemUseContext)ctx) && !ForgeEventFactory.onBlockPlace((Entity)placer, (BlockSnapshot)(snapshot = BlockSnapshot.getBlockSnapshot((IWorld)this.field_70170_p, (BlockPos)pos)), (Direction)face)) {
            ActionResultType res = ((BlockItem)stack.func_77973_b()).func_195942_a((BlockItemUseContext)ctx);
            return res == ActionResultType.SUCCESS;
        }
        return false;
    }

    private void dropAsItem() {
        if (this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
            this.func_70099_a(this.getStack().func_77946_l(), 0.0f);
        }
    }

    private PlayerEntity getFakePlayer() {
        if (fakePlayer == null) {
            fakePlayer = FakePlayerFactory.get((ServerWorld)((ServerWorld)this.field_70170_p), (GameProfile)new GameProfile(null, "[Tumbling Block]"));
            EntityTumblingBlock.fakePlayer.field_71135_a = new FakeNetHandlerPlayerServer(ServerLifecycleHooks.getCurrentServer(), (ServerPlayerEntity)fakePlayer);
        }
        fakePlayer.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        fakePlayer.func_184611_a(Hand.MAIN_HAND, this.getStack());
        return fakePlayer;
    }

    private static class LocalBlockItemUseContext
    extends BlockItemUseContext {
        private final ItemStack stack;

        public LocalBlockItemUseContext(ItemUseContext context) {
            super(context);
            this.stack = context.func_195996_i().func_77946_l();
        }

        public ItemStack func_195996_i() {
            return this.stack == null ? ItemStack.field_190927_a : this.stack;
        }
    }
}

