/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.entity.semiblock;

import java.util.List;
import me.desht.pneumaticcraft.api.semiblock.IDirectionalSemiblock;
import me.desht.pneumaticcraft.common.entity.semiblock.EntitySemiblockBase;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;

public class EntityTransferGadget
extends EntitySemiblockBase
implements IDirectionalSemiblock {
    private static final int TRANSFER_INTERVAL = 40;
    private static final double INDENT = 0.0625;
    private static final double THICKNESS = 0.03125;
    private static final double ANTI_Z_FIGHT = 0.001;
    private static final DataParameter<Integer> IO_MODE = EntityDataManager.func_187226_a(EntityTransferGadget.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> SIDE = EntityDataManager.func_187226_a(EntityTransferGadget.class, (IDataSerializer)DataSerializers.field_187192_b);
    private int counter;
    public Vec3d renderingOffset;

    public EntityTransferGadget(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(IO_MODE, (Object)EnumInputOutput.OUTPUT.ordinal());
        this.func_184212_Q().func_187214_a(SIDE, (Object)Direction.UP.ordinal());
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.func_70089_S() && ++this.counter >= 40) {
            this.counter = 0;
            this.doTransfer();
        }
    }

    @Override
    public void onPlaced(PlayerEntity player, ItemStack stack, Direction facing) {
        super.onPlaced(player, stack, facing);
        this.setIOMode(EnumInputOutput.OUTPUT);
        this.setSide(facing);
    }

    @Override
    public boolean onRightClickWithConfigurator(PlayerEntity player, Direction side) {
        if (this.getSide() == side) {
            this.setIOMode(this.getIOMode().toggle());
            player.func_184185_a(SoundEvents.field_187638_cR, 1.0f, 1.0f);
            return true;
        }
        return super.onRightClickWithConfigurator(player, side);
    }

    @Override
    public boolean canStay() {
        return this.canPlace(this.getSide());
    }

    @Override
    public boolean canPlace(Direction facing) {
        TileEntity te = this.getCachedTileEntity();
        return te != null && te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing).isPresent();
    }

    @Override
    public Direction getSide() {
        return Direction.values()[(Integer)this.func_184212_Q().func_187225_a(SIDE)];
    }

    @Override
    public void setSide(Direction facing) {
        this.func_184212_Q().func_187227_b(SIDE, (Object)facing.ordinal());
    }

    public void func_184206_a(DataParameter<?> param) {
        if (param == SIDE) {
            this.renderingOffset = this.calcRenderingOffset(this.func_174813_aQ(), this.getSide());
        }
    }

    private Vec3d calcRenderingOffset(AxisAlignedBB aabb, Direction d) {
        double xl = aabb.func_216364_b() / 2.0;
        double zl = aabb.func_216362_d() / 2.0;
        switch (d) {
            case DOWN: {
                return new Vec3d(0.0, -0.03125, 0.0);
            }
            case UP: {
                return new Vec3d(0.0, aabb.func_216360_c(), 0.0);
            }
            case NORTH: {
                return new Vec3d(-0.015625, -0.015625, -zl);
            }
            case SOUTH: {
                return new Vec3d(0.0, -0.015625, zl);
            }
            case WEST: {
                return new Vec3d(-xl - 0.03125, -0.015625, 0.0);
            }
            case EAST: {
                return new Vec3d(xl, -0.015625, 0.0);
            }
        }
        throw new IllegalArgumentException();
    }

    public EnumInputOutput getIOMode() {
        return EnumInputOutput.values()[(Integer)this.func_184212_Q().func_187225_a(IO_MODE)];
    }

    private void setIOMode(EnumInputOutput mode) {
        this.func_184212_Q().func_187227_b(IO_MODE, (Object)mode.ordinal());
    }

    @Override
    protected void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.counter = compound.func_74762_e("counter");
        this.setSide(Direction.func_82600_a((int)compound.func_74771_c("facing")));
        this.setIOMode(compound.func_74767_n("input") ? EnumInputOutput.INPUT : EnumInputOutput.OUTPUT);
    }

    @Override
    protected void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("counter", this.counter);
        compound.func_74774_a("facing", (byte)this.getSide().func_176745_a());
        compound.func_74757_a("input", this.getIOMode() == EnumInputOutput.INPUT);
    }

    @Override
    public void addTooltip(List<ITextComponent> curInfo, PlayerEntity player, CompoundNBT tag, boolean extended) {
        curInfo.add(PneumaticCraftUtils.xlate("pneumaticcraft.gui.logistics_frame.facing", this.getSide()));
    }

    @Override
    public AxisAlignedBB getBlockBounds() {
        AxisAlignedBB b = super.getBlockBounds();
        switch (this.getSide()) {
            case UP: {
                return new AxisAlignedBB(b.field_72340_a - 0.03125, b.field_72337_e - 0.0625, b.field_72339_c - 0.03125, b.field_72336_d + 0.03125, b.field_72337_e + 0.03125, b.field_72334_f + 0.03125);
            }
            case DOWN: {
                return new AxisAlignedBB(b.field_72340_a - 0.03125, -0.001, b.field_72339_c - 0.03125, b.field_72336_d + 0.03125, b.field_72338_b + 0.0625, b.field_72334_f + 0.03125);
            }
            case NORTH: {
                return new AxisAlignedBB(b.field_72340_a - 0.03125, b.field_72338_b - 0.03125, -0.001, b.field_72336_d + 0.03125, b.field_72337_e + 0.03125, b.field_72339_c + 0.0625);
            }
            case SOUTH: {
                return new AxisAlignedBB(b.field_72340_a - 0.03125, b.field_72338_b - 0.03125, b.field_72334_f - 0.0625, b.field_72336_d + 0.03125, b.field_72337_e + 0.03125, 1.001);
            }
            case WEST: {
                return new AxisAlignedBB(-0.001, b.field_72338_b - 0.03125, b.field_72339_c - 0.03125, b.field_72340_a + 0.0625, b.field_72337_e + 0.03125, b.field_72334_f + 0.03125);
            }
            case EAST: {
                return new AxisAlignedBB(b.field_72336_d - 0.0625, b.field_72338_b - 0.03125, b.field_72339_c - 0.03125, 1.001, b.field_72337_e + 0.03125, b.field_72334_f + 0.03125);
            }
        }
        return b;
    }

    private void doTransfer() {
        TileEntity inputTE = this.getCachedTileEntity();
        TileEntity outputTE = this.field_70170_p.func_175625_s(this.getBlockPos().func_177972_a(this.getSide()));
        if (inputTE != null && outputTE != null) {
            if (this.getIOMode() == EnumInputOutput.OUTPUT) {
                this.tryTransferItem(inputTE, outputTE);
                this.tryTransferFluid(inputTE, outputTE);
            } else {
                this.tryTransferItem(outputTE, inputTE);
                this.tryTransferFluid(outputTE, inputTE);
            }
        }
    }

    private void tryTransferItem(TileEntity inputTE, TileEntity outputTE) {
        inputTE.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.getSide()).ifPresent(input -> outputTE.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.getSide().func_176734_d()).ifPresent(output -> IOHelper.transferOneItem(input, output)));
    }

    private void tryTransferFluid(TileEntity inputTE, TileEntity outputTE) {
        inputTE.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.getSide()).ifPresent(input -> outputTE.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.getSide().func_176734_d()).ifPresent(output -> FluidUtil.tryFluidTransfer((IFluidHandler)output, (IFluidHandler)input, (int)100, (boolean)true)));
    }

    public static enum EnumInputOutput {
        INPUT,
        OUTPUT;


        EnumInputOutput toggle() {
            return this == INPUT ? OUTPUT : INPUT;
        }
    }
}

