/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.fluid;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import me.desht.pneumaticcraft.api.fuel.IFuelRegistry;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.fluid.Fluid;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;

public enum FuelRegistry implements IFuelRegistry
{
    INSTANCE;

    private static final Pair<Integer, Float> MISSING;
    public final Map<ResourceLocation, Pair<Integer, Float>> liquidFuels = new HashMap<ResourceLocation, Pair<Integer, Float>>();

    public static FuelRegistry getInstance() {
        return INSTANCE;
    }

    @Override
    public void registerFuel(Fluid fluid, int mLPerBucket) {
        this.registerFuel(fluid, mLPerBucket, 1.0f);
    }

    @Override
    public void registerFuel(Fluid fluid, int mLPerBucket, float burnRateMultiplier) {
        Validate.notNull((Object)fluid);
        Validate.isTrue((mLPerBucket >= 0 ? 1 : 0) != 0, (String)"mlPerBucket can't be < 0!", (Object[])new Object[0]);
        Validate.isTrue((burnRateMultiplier > 0.0f ? 1 : 0) != 0, (String)"burnRate can't be <= 0!", (Object[])new Object[0]);
        if (this.liquidFuels.containsKey(fluid.getRegistryName())) {
            Log.warning("Overriding liquid fuel entry %s (%s) with a fuel value of %d (previous value %d)", new FluidStack(fluid, 1).getDisplayName().func_150254_d(), fluid.getRegistryName().toString(), mLPerBucket, this.liquidFuels.get(fluid.getRegistryName()));
            if (mLPerBucket == 0) {
                this.liquidFuels.remove(fluid.getRegistryName());
            }
        }
        if (mLPerBucket > 0) {
            this.liquidFuels.put(fluid.getRegistryName(), (Pair<Integer, Float>)Pair.of((Object)mLPerBucket, (Object)Float.valueOf(burnRateMultiplier)));
            Log.info("Registering liquid fuel entry '%s': %d mL air/bucket, burn rate %f", fluid.getRegistryName(), mLPerBucket, Float.valueOf(burnRateMultiplier));
        }
    }

    @Override
    public int getFuelValue(Fluid fluid) {
        return (Integer)this.liquidFuels.getOrDefault(fluid.getRegistryName(), MISSING).getLeft();
    }

    @Override
    public float getBurnRateMultiplier(Fluid fluid) {
        return ((Float)this.liquidFuels.getOrDefault(fluid.getRegistryName(), MISSING).getRight()).floatValue();
    }

    @Override
    public Collection<Fluid> registeredFuels() {
        return this.liquidFuels.keySet().stream().map(arg_0 -> ((IForgeRegistry)ForgeRegistries.FLUIDS).getValue(arg_0)).collect(Collectors.toList());
    }

    static {
        MISSING = Pair.of((Object)0, (Object)Float.valueOf(1.0f));
    }
}

