/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.inventory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.crafting.AmadronTradeResource;
import me.desht.pneumaticcraft.common.DroneRegistry;
import me.desht.pneumaticcraft.common.config.PNCConfig;
import me.desht.pneumaticcraft.common.core.ModContainers;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.entity.living.EntityAmadrone;
import me.desht.pneumaticcraft.common.inventory.ContainerAmadronAddTrade;
import me.desht.pneumaticcraft.common.inventory.ContainerPneumaticBase;
import me.desht.pneumaticcraft.common.inventory.SlotUntouchable;
import me.desht.pneumaticcraft.common.item.ItemAmadronTablet;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketAmadronTradeRemoved;
import me.desht.pneumaticcraft.common.network.PacketPlaySound;
import me.desht.pneumaticcraft.common.recipes.amadron.AmadronOffer;
import me.desht.pneumaticcraft.common.recipes.amadron.AmadronOfferManager;
import me.desht.pneumaticcraft.common.recipes.amadron.AmadronPlayerOffer;
import me.desht.pneumaticcraft.common.tileentity.TileEntityBase;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class ContainerAmadron
extends ContainerPneumaticBase<TileEntityBase> {
    public static final int ROWS = 4;
    public static final int OFFERS_PER_PAGE = 8;
    public final List<AmadronOffer> activeOffers = new ArrayList<AmadronOffer>(AmadronOfferManager.getInstance().getActiveOffers());
    private final ItemStackHandler inv = new ItemStackHandler(16);
    @GuiSynced
    private final int[] shoppingItems = new int[8];
    @GuiSynced
    private final int[] shoppingAmounts = new int[8];
    @GuiSynced
    public final boolean[] buyableOffers = new boolean[this.activeOffers.size()];
    private final Hand hand;
    @GuiSynced
    public EnumProblemState problemState = EnumProblemState.NO_PROBLEMS;
    @GuiSynced
    public int maxOffers = 0;
    @GuiSynced
    public int currentOffers = 0;
    @GuiSynced
    private boolean basketEmpty = true;

    public ContainerAmadron(int windowId, PlayerInventory invPlayer, Hand hand) {
        super((ContainerType)ModContainers.AMADRON.get(), windowId, invPlayer);
        this.hand = hand;
        this.addSyncedFields(this);
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 2; ++x) {
                this.func_75146_a((Slot)new SlotUntouchable((IItemHandler)this.inv, y * 4 + x * 2, x * 73 + 12, y * 35 + 70));
                this.func_75146_a((Slot)new SlotUntouchable((IItemHandler)this.inv, y * 4 + x * 2 + 1, x * 73 + 57, y * 35 + 70));
            }
        }
        Arrays.fill(this.shoppingItems, -1);
        PlayerEntity player = invPlayer.field_70458_d;
        if (!player.field_70170_p.field_72995_K) {
            HashMap<ResourceLocation, Integer> liveIndex = new HashMap<ResourceLocation, Integer>();
            LazyOptional<IItemHandler> itemCap = ItemAmadronTablet.getItemCapability(player.func_184586_b(hand));
            LazyOptional<IFluidHandler> fluidCap = ItemAmadronTablet.getFluidCapability(player.func_184586_b(hand));
            for (int i = 0; i < this.activeOffers.size(); ++i) {
                int amount = this.capShoppingAmount(this.activeOffers.get(i), 1, itemCap, fluidCap);
                this.buyableOffers[i] = amount > 0;
                liveIndex.put(this.activeOffers.get(i).func_199560_c(), i);
            }
            this.problemState = EnumProblemState.NO_PROBLEMS;
            Map<ResourceLocation, Integer> shoppingCart = ItemAmadronTablet.loadShoppingCart(player.func_184586_b(hand));
            if (!shoppingCart.isEmpty()) {
                shoppingCart.forEach((id, count) -> {
                    int offerId;
                    int index;
                    if (liveIndex.containsKey(id) && (index = this.getCartSlot(offerId = ((Integer)liveIndex.get(id)).intValue())) >= 0) {
                        this.shoppingItems[index] = offerId;
                        this.shoppingAmounts[index] = count;
                    }
                });
            }
            this.basketEmpty = Arrays.stream(this.shoppingAmounts).noneMatch(shoppingAmount -> shoppingAmount > 0);
            this.currentOffers = AmadronOfferManager.getInstance().countOffers(player.func_146103_bH().getId().toString());
            this.maxOffers = PneumaticCraftUtils.isPlayerOp(player) ? Integer.MAX_VALUE : PNCConfig.Common.Amadron.maxTradesPerPlayer;
        }
    }

    public ContainerAmadron(int windowId, PlayerInventory playerInventory, PacketBuffer buffer) {
        this(windowId, playerInventory, buffer.readBoolean() ? Hand.MAIN_HAND : Hand.OFF_HAND);
    }

    public boolean isBasketEmpty() {
        return this.basketEmpty;
    }

    public Hand getHand() {
        return this.hand;
    }

    public void func_75141_a(int slot, @Nonnull ItemStack stack) {
    }

    @Override
    public boolean func_75145_c(PlayerEntity player) {
        if (player.func_184586_b(this.hand).func_77973_b() == ModItems.AMADRON_TABLET.get()) {
            return (Boolean)player.func_184586_b(this.hand).getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).map(h -> {
                h.addAir(-1);
                if (h.getPressure() > 0.0f) {
                    return true;
                }
                player.func_146105_b((ITextComponent)new TranslationTextComponent("pneumaticcraft.gui.tab.problems.notEnoughPressure", new Object[0]), false);
                return false;
            }).orElse((Object)false);
        }
        return false;
    }

    public void clearStacks() {
        for (int i = 0; i < this.inv.getSlots(); ++i) {
            this.inv.setStackInSlot(i, ItemStack.field_190927_a);
        }
    }

    public void setStack(int index, ItemStack stack) {
        this.inv.setStackInSlot(index, stack);
    }

    @Override
    @Nonnull
    public ItemStack func_82846_b(PlayerEntity p_82846_1_, int p_82846_2_) {
        return ItemStack.field_190927_a;
    }

    public void clickOffer(int offerId, int mouseButton, boolean shiftPressed, PlayerEntity player) {
        this.problemState = EnumProblemState.NO_PROBLEMS;
        int cartSlot = this.getCartSlot(offerId);
        if (cartSlot >= 0) {
            if (mouseButton == 2) {
                this.shoppingAmounts[cartSlot] = 0;
            } else if (shiftPressed) {
                if (mouseButton == 0) {
                    int n = cartSlot;
                    this.shoppingAmounts[n] = this.shoppingAmounts[n] / 2;
                } else {
                    AmadronOffer offer = this.activeOffers.get(offerId);
                    if (offer instanceof AmadronPlayerOffer) {
                        this.removeCustomOffer(player, (AmadronPlayerOffer)offer);
                    } else {
                        int n = cartSlot;
                        this.shoppingAmounts[n] = this.shoppingAmounts[n] * 2;
                        if (this.shoppingAmounts[cartSlot] == 0) {
                            this.shoppingAmounts[cartSlot] = 1;
                        }
                    }
                }
            } else if (mouseButton == 0) {
                int n = cartSlot;
                this.shoppingAmounts[n] = this.shoppingAmounts[n] - 1;
            } else {
                int n = cartSlot;
                this.shoppingAmounts[n] = this.shoppingAmounts[n] + 1;
            }
            if (this.shoppingAmounts[cartSlot] <= 0) {
                this.shoppingAmounts[cartSlot] = 0;
                this.shoppingItems[cartSlot] = -1;
            } else {
                this.shoppingAmounts[cartSlot] = this.capShoppingAmount(offerId, this.shoppingAmounts[cartSlot], player);
                this.shoppingItems[cartSlot] = this.shoppingAmounts[cartSlot] > 0 ? offerId : -1;
            }
        }
        this.basketEmpty = Arrays.stream(this.shoppingAmounts).noneMatch(shoppingAmount -> shoppingAmount > 0);
    }

    private void removeCustomOffer(PlayerEntity player, AmadronPlayerOffer offer) {
        if (offer.getPlayerId().equals(player.func_146103_bH().getId().toString()) && AmadronOfferManager.getInstance().removePlayerOffer(offer)) {
            if (PNCConfig.Common.Amadron.notifyOfTradeRemoval) {
                NetworkHandler.sendToAll(new PacketAmadronTradeRemoved(offer));
            }
            offer.returnStock();
            player.func_71053_j();
        }
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, PlayerEntity player) {
        super.handleGUIButtonPress(tag, shiftHeld, player);
        if (tag.equals("order")) {
            boolean placed = false;
            for (int i = 0; i < this.shoppingItems.length; ++i) {
                GlobalPos fluidGPos;
                GlobalPos itemGPos;
                AmadronOffer offer;
                EntityAmadrone drone;
                if (this.shoppingItems[i] >= 0 && (drone = ContainerAmadron.retrieveOrderItems(offer = this.activeOffers.get(this.shoppingItems[i]), this.shoppingAmounts[i], itemGPos = ItemAmadronTablet.getItemProvidingLocation(player.func_184586_b(this.hand)), fluidGPos = ItemAmadronTablet.getFluidProvidingLocation(player.func_184586_b(this.hand)))) != null) {
                    drone.setHandlingOffer(offer.func_199560_c(), this.shoppingAmounts[i], player.func_184586_b(this.hand), player.func_200200_C_().func_150254_d(), EntityAmadrone.AmadronAction.TAKING_PAYMENT);
                    placed = true;
                }
                if (!placed || !(player instanceof ServerPlayerEntity)) continue;
                NetworkHandler.sendToPlayer(new PacketPlaySound((SoundEvent)ModSounds.CHIRP.get(), SoundCategory.PLAYERS, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 0.2f, 1.0f, false), (ServerPlayerEntity)player);
            }
            Arrays.fill(this.shoppingAmounts, 0);
            Arrays.fill(this.shoppingItems, -1);
            this.basketEmpty = true;
        } else if (tag.equals("addPlayerTrade")) {
            this.openTradeGui(player);
        }
    }

    private void openTradeGui(PlayerEntity player) {
        NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new INamedContainerProvider(){

            public ITextComponent func_145748_c_() {
                return new StringTextComponent("");
            }

            @Nullable
            public Container createMenu(int windowId, PlayerInventory playerInventory, PlayerEntity playerEntity) {
                return new ContainerAmadronAddTrade(windowId, playerInventory);
            }
        });
    }

    public static EntityAmadrone retrieveOrderItems(AmadronOffer offer, int times, GlobalPos itemGPos, GlobalPos liquidGPos) {
        if (offer.getInput().getType() == AmadronTradeResource.Type.ITEM) {
            ItemStack stack;
            if (itemGPos == null) {
                return null;
            }
            ItemStack queryingItems = offer.getInput().getItem();
            NonNullList stacks = NonNullList.func_191196_a();
            for (int amount = queryingItems.func_190916_E() * times; amount > 0; amount -= stack.func_190916_E()) {
                stack = queryingItems.func_77946_l();
                stack.func_190920_e(Math.min(amount, stack.func_77976_d()));
                stacks.add((Object)stack);
            }
            return (EntityAmadrone)DroneRegistry.getInstance().retrieveItemsAmazonStyle(itemGPos, (ItemStack[])stacks.toArray((Object[])new ItemStack[0]));
        }
        if (offer.getInput().getType() == AmadronTradeResource.Type.FLUID) {
            if (liquidGPos == null) {
                return null;
            }
            FluidStack queryingFluid = offer.getInput().getFluid().copy();
            queryingFluid.setAmount(queryingFluid.getAmount() * times);
            return (EntityAmadrone)DroneRegistry.getInstance().retrieveFluidAmazonStyle(liquidGPos, queryingFluid);
        }
        return null;
    }

    private int capShoppingAmount(int offerId, int wantedAmount, PlayerEntity player) {
        ItemStack tablet = player.func_184586_b(this.hand);
        return this.capShoppingAmount(this.activeOffers.get(offerId), wantedAmount, ItemAmadronTablet.getItemCapability(tablet), ItemAmadronTablet.getFluidCapability(tablet));
    }

    private int capShoppingAmount(AmadronOffer offer, int wantedAmount, LazyOptional<IItemHandler> itemCap, LazyOptional<IFluidHandler> fluidCap) {
        return this.capShoppingAmount(offer, wantedAmount, itemCap, itemCap, fluidCap, fluidCap);
    }

    private int capShoppingAmount(AmadronOffer offer, int wantedTradeCount, LazyOptional<IItemHandler> itemCapIn, LazyOptional<IItemHandler> itemCapOut, LazyOptional<IFluidHandler> fluidCapIn, LazyOptional<IFluidHandler> fluidCapOut) {
        int availableTrades;
        EnumProblemState problem = null;
        if (offer.getStock() >= 0 && wantedTradeCount > offer.getStock()) {
            wantedTradeCount = offer.getStock();
            problem = EnumProblemState.OUT_OF_STOCK;
        }
        if (offer.getInput().getType() == AmadronTradeResource.Type.ITEM) {
            if (itemCapIn.isPresent()) {
                availableTrades = offer.getInput().countTradesInInventory(itemCapIn);
                if (availableTrades < wantedTradeCount) {
                    problem = EnumProblemState.NOT_ENOUGH_ITEMS;
                    wantedTradeCount = availableTrades;
                }
            } else if (!itemCapOut.isPresent()) {
                wantedTradeCount = 0;
                problem = EnumProblemState.NO_ITEM_PROVIDER;
            }
        } else if (offer.getInput().getType() == AmadronTradeResource.Type.FLUID) {
            if (fluidCapIn.isPresent()) {
                availableTrades = offer.getInput().countTradesInTank(fluidCapIn);
                if (availableTrades < wantedTradeCount) {
                    problem = EnumProblemState.NOT_ENOUGH_FLUID;
                    wantedTradeCount = availableTrades;
                }
            } else if (!fluidCapOut.isPresent()) {
                wantedTradeCount = 0;
                problem = EnumProblemState.NO_FLUID_PROVIDER;
            }
        }
        if (offer.getOutput().getType() == AmadronTradeResource.Type.ITEM) {
            if (itemCapOut.isPresent()) {
                int availableSpace = offer.getOutput().findSpaceInItemOutput(itemCapOut, wantedTradeCount);
                if (availableSpace < wantedTradeCount) {
                    wantedTradeCount = availableSpace;
                    problem = EnumProblemState.NOT_ENOUGH_ITEM_SPACE;
                }
            } else if (!itemCapIn.isPresent()) {
                wantedTradeCount = 0;
                problem = EnumProblemState.NO_ITEM_PROVIDER;
            }
        } else if (offer.getOutput().getType() == AmadronTradeResource.Type.FLUID) {
            if (fluidCapOut.isPresent()) {
                availableTrades = offer.getOutput().findSpaceInFluidOutput(fluidCapOut, wantedTradeCount);
                if (availableTrades < wantedTradeCount) {
                    wantedTradeCount = availableTrades;
                    problem = EnumProblemState.NOT_ENOUGH_FLUID_SPACE;
                }
            } else if (!fluidCapIn.isPresent()) {
                wantedTradeCount = 0;
                problem = EnumProblemState.NO_FLUID_PROVIDER;
            }
        }
        if (problem != null) {
            this.problemState = problem;
        }
        return wantedTradeCount;
    }

    private int getCartSlot(int offerId) {
        int freeSlot = -1;
        for (int i = 0; i < this.shoppingItems.length; ++i) {
            if (this.shoppingItems[i] == offerId) {
                return i;
            }
            if (freeSlot != -1 || this.shoppingItems[i] != -1) continue;
            freeSlot = i;
        }
        return freeSlot;
    }

    public int getShoppingCartAmount(AmadronOffer offer) {
        int offerId = this.activeOffers.indexOf(offer);
        for (int i = 0; i < this.shoppingItems.length; ++i) {
            if (this.shoppingItems[i] != offerId) continue;
            return this.shoppingAmounts[i];
        }
        return 0;
    }

    public void func_75134_a(PlayerEntity player) {
        super.func_75134_a(player);
        if (!player.field_70170_p.field_72995_K && player.func_184586_b(this.hand).func_77973_b() == ModItems.AMADRON_TABLET.get()) {
            HashMap<ResourceLocation, Integer> shoppingCart = new HashMap<ResourceLocation, Integer>();
            for (int i = 0; i < this.shoppingItems.length; ++i) {
                if (this.shoppingItems[i] < 0) continue;
                shoppingCart.put(this.activeOffers.get(this.shoppingItems[i]).func_199560_c(), this.shoppingAmounts[i]);
            }
            ItemAmadronTablet.saveShoppingCart(player.func_184586_b(this.hand), shoppingCart);
        }
    }

    public static enum EnumProblemState {
        NO_PROBLEMS("noProblems"),
        NO_ITEM_PROVIDER("noItemProvider"),
        NO_FLUID_PROVIDER("noFluidProvider"),
        NOT_ENOUGH_ITEM_SPACE("notEnoughItemSpace"),
        NOT_ENOUGH_FLUID_SPACE("notEnoughFluidSpace"),
        NOT_ENOUGH_ITEMS("notEnoughItems"),
        NOT_ENOUGH_FLUID("notEnoughFluid"),
        OUT_OF_STOCK("outOfStock");

        private final String locKey;

        private EnumProblemState(String locKey) {
            this.locKey = locKey;
        }

        public String getTranslationKey() {
            return "pneumaticcraft.gui.tab.problems.amadron." + this.locKey;
        }
    }
}

