/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerItem;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.item.ItemPressurizable;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlaySound;
import me.desht.pneumaticcraft.common.tileentity.ICamouflageableTE;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class ItemCamoApplicator
extends ItemPressurizable {
    public ItemCamoApplicator() {
        super(ModItems.toolProps(), 30000, 3000);
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        BlockState camoState = ItemCamoApplicator.getCamoState(stack);
        ITextComponent disp = super.func_200295_i(stack);
        if (camoState != null) {
            return disp.func_150258_a(": ").func_150257_a(ItemCamoApplicator.getCamoStateDisplayName(camoState)).func_211708_a(TextFormatting.YELLOW);
        }
        return disp;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        if (playerIn.func_225608_bj_()) {
            if (!worldIn.field_72995_K) {
                ItemCamoApplicator.setCamoState(playerIn.func_184586_b(handIn), null);
            } else if (ItemCamoApplicator.getCamoState(playerIn.func_184586_b(handIn)) != null) {
                playerIn.func_184185_a((SoundEvent)ModSounds.CHIRP.get(), 1.0f, 1.0f);
            }
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)playerIn.func_184586_b(handIn));
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext ctx) {
        World world = ctx.func_195991_k();
        BlockPos pos = ctx.func_195995_a();
        PlayerEntity player = ctx.func_195999_j();
        if (!world.field_72995_K) {
            if (player.func_225608_bj_()) {
                ItemCamoApplicator.setCamoState(stack, null);
            } else {
                TileEntity te = world.func_175625_s(pos);
                BlockState state = world.func_180495_p(pos);
                if (!(te instanceof ICamouflageableTE)) {
                    ItemCamoApplicator.setCamoState(stack, state);
                    NetworkHandler.sendToAllAround(new PacketPlaySound((SoundEvent)ModSounds.CHIRP.get(), SoundCategory.PLAYERS, pos, 1.0f, 2.0f, false), world);
                } else {
                    BlockState particleState;
                    ItemStack camoStack;
                    IAirHandlerItem airHandler = (IAirHandlerItem)stack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).orElseThrow(RuntimeException::new);
                    if (!player.func_184812_l_() && airHandler.getPressure() < 0.1f) {
                        return ActionResultType.FAIL;
                    }
                    BlockState newCamo = ItemCamoApplicator.getCamoState(stack);
                    BlockState existingCamo = ((ICamouflageableTE)te).getCamouflage();
                    if (existingCamo == newCamo) {
                        NetworkHandler.sendToAllAround(new PacketPlaySound(SoundEvents.field_187556_aj, SoundCategory.PLAYERS, pos, 1.0f, 2.0f, false), world);
                        return ActionResultType.SUCCESS;
                    }
                    if (newCamo != null && !player.func_184812_l_() && !PneumaticCraftUtils.consumeInventoryItem(player.field_71071_by, camoStack = ICamouflageableTE.getStackForState(newCamo))) {
                        player.func_146105_b(new TranslationTextComponent("pneumaticcraft.message.camo.notEnoughBlocks", new Object[0]).func_150257_a(camoStack.func_200301_q()).func_211709_a(new TextFormatting[]{TextFormatting.RED}), true);
                        NetworkHandler.sendToAllAround(new PacketPlaySound((SoundEvent)ModSounds.MINIGUN_STOP.get(), SoundCategory.PLAYERS, pos, 1.0f, 2.0f, false), world);
                        return ActionResultType.FAIL;
                    }
                    if (existingCamo != null && !player.func_184812_l_()) {
                        camoStack = ICamouflageableTE.getStackForState(existingCamo);
                        ItemEntity entity = new ItemEntity(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, camoStack);
                        world.func_217376_c((Entity)entity);
                        entity.func_70100_b_(player);
                    }
                    airHandler.addAir(-50);
                    ((ICamouflageableTE)te).setCamouflage(newCamo);
                    BlockState blockState = particleState = newCamo == null ? existingCamo : newCamo;
                    if (particleState != null) {
                        player.func_130014_f_().func_217379_c(2001, pos, Block.func_196246_j((BlockState)particleState));
                    }
                    NetworkHandler.sendToAllAround(new PacketPlaySound((SoundEvent)ModSounds.SHORT_HISS.get(), SoundCategory.PLAYERS, pos, 1.0f, 1.0f, false), world);
                }
            }
        }
        return ActionResultType.SUCCESS;
    }

    private static void setCamoState(ItemStack stack, BlockState state) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null) {
            tag = new CompoundNBT();
        }
        if (state == null) {
            tag.func_82580_o("CamoState");
        } else {
            tag.func_218657_a("CamoState", (INBT)NBTUtil.func_190009_a((BlockState)state));
        }
        stack.func_77982_d(tag);
    }

    private static BlockState getCamoState(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag != null && tag.func_74764_b("CamoState")) {
            return NBTUtil.func_190008_d((CompoundNBT)tag.func_74775_l("CamoState"));
        }
        return null;
    }

    public static ITextComponent getCamoStateDisplayName(BlockState state) {
        if (state != null) {
            return new ItemStack((IItemProvider)state.func_177230_c().func_199767_j()).func_200301_q();
        }
        return new StringTextComponent("<?>");
    }
}

