/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.item.IPositionProvider;
import me.desht.pneumaticcraft.client.gui.GuiGPSTool;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.util.NBTUtil;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.variables.GlobalVariableManager;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class ItemGPSTool
extends Item
implements IPositionProvider {
    public ItemGPSTool() {
        super(ModItems.defaultProps());
    }

    public ActionResultType func_195939_a(ItemUseContext ctx) {
        BlockPos pos = ctx.func_195995_a();
        ItemGPSTool.setGPSLocation(ctx.func_195999_j().func_184586_b(ctx.func_221531_n()), pos);
        if (!ctx.func_195991_k().field_72995_K) {
            ctx.func_195999_j().func_146105_b(new TranslationTextComponent("pneumaticcraft.message.gps_tool.targetSet", new Object[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()}).func_211708_a(TextFormatting.GREEN), false);
        }
        ctx.func_195999_j().func_184185_a((SoundEvent)ModSounds.CHIRP.get(), 1.0f, 1.5f);
        return ActionResultType.SUCCESS;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (worldIn.field_72995_K) {
            GuiGPSTool.showGUI(stack, handIn, ItemGPSTool.getGPSLocation(worldIn, stack));
        }
        return ActionResult.func_226248_a_((Object)stack);
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> infoList, ITooltipFlag par4) {
        super.func_77624_a(stack, worldIn, infoList, par4);
        CompoundNBT compound = stack.func_77978_p();
        if (compound != null) {
            String varName;
            int x = compound.func_74762_e("x");
            int y = compound.func_74762_e("y");
            int z = compound.func_74762_e("z");
            if (x != 0 || y != 0 || z != 0) {
                infoList.add(new StringTextComponent("Set to " + x + ", " + y + ", " + z).func_211708_a(TextFormatting.GREEN));
            }
            if (!(varName = ItemGPSTool.getVariable(stack)).equals("")) {
                infoList.add(PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.gpsTool.variable", varName));
            }
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean heldItem) {
        String var = ItemGPSTool.getVariable(stack);
        if (!var.equals("") && !world.field_72995_K) {
            BlockPos pos = GlobalVariableManager.getInstance().getPos(var);
            ItemGPSTool.setGPSLocation(stack, pos);
        }
    }

    public static BlockPos getGPSLocation(ItemStack stack) {
        return ItemGPSTool.getGPSLocation(null, stack);
    }

    public static BlockPos getGPSLocation(World world, ItemStack gpsTool) {
        CompoundNBT compound = gpsTool.func_77978_p();
        if (compound != null) {
            String var = ItemGPSTool.getVariable(gpsTool);
            if (!var.equals("") && world != null && !world.field_72995_K) {
                BlockPos pos = GlobalVariableManager.getInstance().getPos(var);
                ItemGPSTool.setGPSLocation(gpsTool, pos);
            }
            int x = compound.func_74762_e("x");
            int y = compound.func_74762_e("y");
            int z = compound.func_74762_e("z");
            if (x != 0 || y != 0 || z != 0) {
                return new BlockPos(x, y, z);
            }
            return null;
        }
        return null;
    }

    public static void setGPSLocation(ItemStack gpsTool, BlockPos pos) {
        NBTUtil.setPos(gpsTool, (Vec3i)pos);
        String var = ItemGPSTool.getVariable(gpsTool);
        if (!var.equals("")) {
            GlobalVariableManager.getInstance().set(var, pos);
        }
    }

    public static void setVariable(ItemStack gpsTool, String variable) {
        NBTUtil.setString(gpsTool, "variable", variable);
    }

    public static String getVariable(ItemStack gpsTool) {
        return gpsTool.func_77942_o() ? gpsTool.func_77978_p().func_74779_i("variable") : "";
    }

    @Override
    public List<BlockPos> getStoredPositions(World world, @Nonnull ItemStack stack) {
        return Collections.singletonList(ItemGPSTool.getGPSLocation(world, stack));
    }

    @Override
    public int getRenderColor(int index) {
        return -1862271232;
    }
}

