/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.List;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.api.item.IUpgradeItem;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.util.NBTUtil;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Rarity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemMachineUpgrade
extends Item
implements IUpgradeItem {
    public static final String NBT_DIRECTION = "Facing";
    private final EnumUpgrade upgrade;
    private final int tier;

    public ItemMachineUpgrade(EnumUpgrade upgrade, int tier) {
        super(ModItems.defaultProps());
        this.upgrade = upgrade;
        this.tier = tier;
    }

    @Override
    public EnumUpgrade getUpgradeType() {
        return this.upgrade;
    }

    public int getTier() {
        return this.tier;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> infoList, ITooltipFlag par4) {
        if (ClientUtils.hasShiftDown()) {
            infoList.add(PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.item.upgrade.usedIn", new Object[0]));
            PneumaticRegistry.getInstance().getItemRegistry().addTooltip(this.upgrade, infoList);
        } else {
            infoList.add(PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.item.upgrade.shiftMessage", new Object[0]).func_211708_a(TextFormatting.AQUA));
        }
        if (this.getUpgradeType() == EnumUpgrade.DISPENSER) {
            Direction dir = stack.func_77942_o() ? Direction.func_176739_a((String)NBTUtil.getString(stack, NBT_DIRECTION)) : null;
            infoList.add(PneumaticCraftUtils.xlate("pneumaticcraft.message.dispenser.direction", dir == null ? "*" : dir.func_176610_l()));
            infoList.add(PneumaticCraftUtils.xlate("pneumaticcraft.message.dispenser.clickToSet", new Object[0]));
        }
        super.func_77624_a(stack, world, infoList, par4);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        if (this.getUpgradeType() == EnumUpgrade.DISPENSER) {
            if (!context.func_195991_k().field_72995_K) {
                this.setDirection(context.func_195999_j(), context.func_221531_n(), context.func_196000_l());
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_195939_a(context);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        if (this.getUpgradeType() == EnumUpgrade.DISPENSER) {
            if (!worldIn.field_72995_K) {
                this.setDirection(playerIn, handIn, null);
            }
            return ActionResult.func_226248_a_((Object)playerIn.func_184586_b(handIn));
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    private void setDirection(PlayerEntity player, Hand hand, Direction facing) {
        ItemStack stack = player.func_184586_b(hand);
        if (facing == null) {
            stack.func_77982_d(null);
            player.func_146105_b((ITextComponent)new TranslationTextComponent("pneumaticcraft.message.dispenser.direction", new Object[]{"*"}), true);
        } else {
            NBTUtil.setString(stack, NBT_DIRECTION, facing.func_176610_l());
            player.func_146105_b((ITextComponent)new TranslationTextComponent("pneumaticcraft.message.dispenser.direction", new Object[]{facing.func_176610_l()}), true);
        }
    }

    public Rarity func_77613_e(ItemStack stack) {
        return this.getUpgradeType() == EnumUpgrade.CREATIVE ? Rarity.EPIC : Rarity.COMMON;
    }

    public static ItemMachineUpgrade of(ItemStack stack) {
        return (ItemMachineUpgrade)stack.func_77973_b();
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group) && this.upgrade.isDepLoaded()) {
            items.add((Object)new ItemStack((IItemProvider)this));
        }
    }
}

