/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.ArrayList;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.tileentity.IManoMeasurable;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.heat.HeatUtil;
import me.desht.pneumaticcraft.common.item.ItemPressurizable;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ItemManometer
extends ItemPressurizable {
    public ItemManometer() {
        super(ModItems.toolProps(), 30000, 3000);
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        World world = context.func_195991_k();
        PlayerEntity player = context.func_195999_j();
        Direction side = context.func_196000_l();
        if (world.field_72995_K) {
            return ActionResultType.PASS;
        }
        return (ActionResultType)stack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).map(h -> {
            if (h.getPressure() > 0.1f) {
                TileEntity te = world.func_175625_s(context.func_195995_a());
                ArrayList<ITextComponent> curInfo = new ArrayList<ITextComponent>();
                te.getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY, side).ifPresent(teAirHandler -> teAirHandler.printManometerMessage(player, curInfo));
                if (te instanceof IManoMeasurable) {
                    ((IManoMeasurable)te).printManometerMessage(player, curInfo);
                }
                te.getCapability(PNCCapabilities.HEAT_EXCHANGER_CAPABILITY).ifPresent(exchanger -> curInfo.add(HeatUtil.formatHeatString(exchanger.getTemperatureAsInt())));
                for (Direction d : Direction.field_199792_n) {
                    te.getCapability(PNCCapabilities.HEAT_EXCHANGER_CAPABILITY, d).ifPresent(exchanger -> curInfo.add(HeatUtil.formatHeatString(exchanger.getTemperatureAsInt())));
                }
                if (curInfo.size() > 0) {
                    h.addAir(-30);
                    curInfo.forEach(s -> player.func_146105_b(s, false));
                }
                return ActionResultType.SUCCESS;
            }
            player.func_146105_b(PneumaticCraftUtils.xlate("pneumaticcraft.message.misc.outOfAir", stack.func_200301_q().func_150254_d()).func_211709_a(new TextFormatting[]{TextFormatting.RED}), true);
            return ActionResultType.FAIL;
        }).orElse((Object)ActionResultType.PASS);
    }

    public boolean func_111207_a(ItemStack iStack, PlayerEntity player, LivingEntity entity, Hand hand) {
        if (!player.field_70170_p.field_72995_K && entity instanceof IManoMeasurable) {
            return (Boolean)iStack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).map(h -> {
                if (h.getPressure() > 0.1f) {
                    ArrayList<ITextComponent> curInfo = new ArrayList<ITextComponent>();
                    ((IManoMeasurable)entity).printManometerMessage(player, curInfo);
                    if (curInfo.size() > 0) {
                        h.addAir(-30);
                        curInfo.forEach(s -> player.func_146105_b(s, false));
                    }
                } else {
                    player.func_146105_b(PneumaticCraftUtils.xlate("pneumaticcraft.message.misc.outOfAir", iStack.func_200301_q().func_150254_d()).func_211709_a(new TextFormatting[]{TextFormatting.RED}), true);
                }
                return true;
            }).orElse((Object)false);
        }
        return false;
    }
}

