/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.client.IFOVModifierItem;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.api.item.IInventoryItem;
import me.desht.pneumaticcraft.api.item.IUpgradeAcceptor;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.client.render.RenderItemMinigun;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.core.ModContainers;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.inventory.ContainerChargingStationItemInventory;
import me.desht.pneumaticcraft.common.inventory.ContainerMinigunMagazine;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.item.IChargeableContainerProvider;
import me.desht.pneumaticcraft.common.item.ItemGunAmmo;
import me.desht.pneumaticcraft.common.item.ItemPressurizable;
import me.desht.pneumaticcraft.common.minigun.Minigun;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlaySound;
import me.desht.pneumaticcraft.common.tileentity.TileEntityChargingStation;
import me.desht.pneumaticcraft.common.util.NBTUtil;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.UpgradableItemUtils;
import me.desht.pneumaticcraft.common.util.upgrade.ApplicableUpgradesDB;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;

public class ItemMinigun
extends ItemPressurizable
implements IChargeableContainerProvider,
IUpgradeAcceptor,
IFOVModifierItem,
IInventoryItem {
    public static final int MAGAZINE_SIZE = 4;
    private static final String NBT_MAGAZINE = "Magazine";
    public static final String NBT_LOCKED_SLOT = "LockedSlot";

    public ItemMinigun() {
        super(ModItems.toolProps().setISTER(() -> RenderItemMinigun::new), 30000, 3000);
    }

    public static MagazineHandler getMagazine(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemMinigun) {
            return new MagazineHandler(stack);
        }
        return null;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BLOCK;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean currentItem) {
        super.func_77663_a(stack, world, entity, slot, currentItem);
        PlayerEntity player = (PlayerEntity)entity;
        Minigun minigun = this.getMinigun(stack, player);
        if (!currentItem) {
            minigun.setMinigunSoundCounter(-1);
            minigun.setMinigunSpeed(0.0f);
            minigun.setMinigunActivated(false);
            minigun.setMinigunTriggerTimeOut(0);
        } else {
            minigun.update(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
        }
        if (world.field_72995_K && currentItem && minigun.getMinigunSpeed() > 0.0f) {
            player.field_82175_bq = false;
            ClientUtils.suppressItemEquipAnimation();
        }
        if (!world.field_72995_K && slot >= 0 && slot <= 8) {
            this.handleAmmoRepair(stack, world, minigun);
        }
    }

    private void handleAmmoRepair(ItemStack stack, World world, Minigun minigun) {
        if (minigun.getPlayer().field_71070_bA instanceof ContainerMinigunMagazine) {
            return;
        }
        int itemLife = minigun.getUpgrades(EnumUpgrade.ITEM_LIFE);
        if (itemLife > 0) {
            MagazineHandler handler = ItemMinigun.getMagazine(stack);
            boolean repaired = false;
            float pressure = ((Float)minigun.getAirCapability().map(IAirHandler::getPressure).orElse((Object)Float.valueOf(0.0f))).floatValue();
            for (int i = 0; i < handler.getSlots() && pressure > 0.25f; ++i) {
                ItemStack ammo = handler.getStackInSlot(i);
                if (!(ammo.func_77973_b() instanceof ItemGunAmmo) || ammo.func_77952_i() <= 0 || world.func_82737_E() % (long)(475 - itemLife * 75) != 0L) continue;
                ammo.func_196085_b(ammo.func_77952_i() - 1);
                minigun.getAirCapability().ifPresent(h -> h.addAir(-(50 * itemLife)));
                pressure = ((Float)minigun.getAirCapability().map(IAirHandler::getPressure).orElse((Object)Float.valueOf(0.0f))).floatValue();
                repaired = true;
            }
            if (repaired) {
                handler.save();
            }
        }
    }

    private Minigun getMinigun(ItemStack stack, PlayerEntity player, ItemStack ammo) {
        return new MinigunItem().setItemStack(stack).setAmmoStack(ammo).setPlayer(player).setAirHandler((LazyOptional<? extends IAirHandler>)stack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY), 20).setWorld(player.field_70170_p);
    }

    public Minigun getMinigun(ItemStack stack, PlayerEntity player) {
        return this.getMinigun(stack, player, ItemMinigun.getMagazine(stack).getAmmo());
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand handIn) {
        final ItemStack stack = player.func_184586_b(handIn);
        if (!world.field_72995_K) {
            if (player.func_225608_bj_() && stack.func_190916_E() == 1) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new INamedContainerProvider(){

                    public ITextComponent func_145748_c_() {
                        return stack.func_200301_q();
                    }

                    @Nullable
                    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
                        return new ContainerMinigunMagazine(i, playerInventory);
                    }
                });
            } else {
                MagazineHandler magazineHandler = ItemMinigun.getMagazine(stack);
                ItemStack ammo = magazineHandler.getAmmo();
                if (!ammo.func_190926_b()) {
                    boolean usedUpAmmo;
                    int prevDamage = ammo.func_77952_i();
                    Minigun minigun = this.getMinigun(stack, player, ammo);
                    boolean bl = usedUpAmmo = minigun.tryFireMinigun(null) && minigun.getUpgrades(EnumUpgrade.ITEM_LIFE) == 0;
                    if (usedUpAmmo) {
                        ammo.func_190920_e(0);
                    }
                    if (usedUpAmmo || ammo.func_77952_i() != prevDamage) {
                        magazineHandler.save();
                    }
                } else {
                    NetworkHandler.sendToPlayer(new PacketPlaySound(SoundEvents.field_187556_aj, SoundCategory.PLAYERS, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 1.0f, 1.0f, false), (ServerPlayerEntity)player);
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("pneumaticcraft.message.minigun.outOfAmmo", new Object[0]), true);
                }
            }
        }
        return ActionResult.func_226248_a_((Object)stack);
    }

    @Override
    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    @Override
    public Map<EnumUpgrade, Integer> getApplicableUpgrades() {
        return ApplicableUpgradesDB.getInstance().getApplicableUpgrades(this);
    }

    @Override
    public String getUpgradeAcceptorTranslationKey() {
        return this.func_77658_a();
    }

    @Override
    public float getFOVModifier(ItemStack stack, PlayerEntity player, EquipmentSlotType slot) {
        Minigun minigun = this.getMinigun(stack, player);
        int trackers = minigun.getUpgrades(EnumUpgrade.ENTITY_TRACKER);
        if (!minigun.isMinigunActivated() || trackers == 0) {
            return 1.0f;
        }
        return 1.0f - (float)trackers * minigun.getMinigunSpeed() / 2.0f;
    }

    @Override
    public void getStacksInItem(ItemStack stack, List<ItemStack> curStacks) {
        MagazineHandler handler = ItemMinigun.getMagazine(stack);
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (handler.getStackInSlot(i).func_190926_b()) continue;
            curStacks.add(handler.getStackInSlot(i));
        }
    }

    @Override
    public ITextComponent getInventoryHeader() {
        return PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.gunAmmo.loaded", new Object[0]).func_211708_a(TextFormatting.GREEN);
    }

    @Override
    public INamedContainerProvider getContainerProvider(TileEntityChargingStation te) {
        return new IChargeableContainerProvider.Provider(te, (ContainerType<? extends ContainerChargingStationItemInventory>)((ContainerType)ModContainers.CHARGING_MINIGUN.get()));
    }

    public static int getLockedSlot(ItemStack stack) {
        if (NBTUtil.hasTag(stack, NBT_LOCKED_SLOT)) {
            int slot = NBTUtil.getInteger(stack, NBT_LOCKED_SLOT);
            if (slot >= 0 && slot < 4) {
                return slot;
            }
            Log.warning("removed out of range saved ammo slot: " + slot, new Object[0]);
            NBTUtil.removeTag(stack, NBT_LOCKED_SLOT);
        }
        return -1;
    }

    public static ItemStack getHeldMinigun(PlayerEntity player) {
        if (player.func_184614_ca().func_77973_b() == ModItems.MINIGUN.get()) {
            return player.func_184614_ca();
        }
        if (player.func_184592_cb().func_77973_b() == ModItems.MINIGUN.get()) {
            return player.func_184592_cb();
        }
        return ItemStack.field_190927_a;
    }

    private static class MinigunItem
    extends Minigun {
        MinigunItem() {
            super(false);
        }

        @Override
        public boolean isMinigunActivated() {
            return NBTUtil.getBoolean(this.minigunStack, "activated");
        }

        @Override
        public void setMinigunActivated(boolean activated) {
            NBTUtil.setBoolean(this.minigunStack, "activated", activated);
        }

        @Override
        public void setAmmoColorStack(@Nonnull ItemStack ammo) {
            if (!ammo.func_190926_b()) {
                NBTUtil.setCompoundTag(this.minigunStack, "ammoColorStack", (INBT)ammo.func_77955_b(new CompoundNBT()));
            } else {
                NBTUtil.removeTag(this.minigunStack, "ammoColorStack");
            }
        }

        @Override
        public int getAmmoColor() {
            ItemStack ammo = ItemStack.field_190927_a;
            if (NBTUtil.hasTag(this.minigunStack, "ammoColorStack")) {
                CompoundNBT tag = NBTUtil.getCompoundTag(this.minigunStack, "ammoColorStack");
                ammo = ItemStack.func_199557_a((CompoundNBT)tag);
            }
            return this.getAmmoColor(ammo);
        }

        @Override
        public void playSound(SoundEvent soundName, float volume, float pitch) {
            NetworkHandler.sendToAllAround(new PacketPlaySound(soundName, SoundCategory.PLAYERS, this.player.func_180425_c(), volume, pitch, false), this.world);
        }

        @Override
        public float getMinigunSpeed() {
            return NBTUtil.getFloat(this.minigunStack, "speed");
        }

        @Override
        public void setMinigunSpeed(float minigunSpeed) {
            NBTUtil.setFloat(this.minigunStack, "speed", minigunSpeed);
        }

        @Override
        public int getMinigunTriggerTimeOut() {
            return NBTUtil.getInteger(this.minigunStack, "triggerTimeout");
        }

        @Override
        public void setMinigunTriggerTimeOut(int minigunTriggerTimeOut) {
            NBTUtil.setInteger(this.minigunStack, "triggerTimeout", minigunTriggerTimeOut);
        }

        @Override
        public int getMinigunSoundCounter() {
            return NBTUtil.getInteger(this.minigunStack, "soundCounter");
        }

        @Override
        public void setMinigunSoundCounter(int minigunSoundCounter) {
            NBTUtil.setInteger(this.minigunStack, "soundCounter", minigunSoundCounter);
        }

        @Override
        public float getMinigunRotation() {
            return NBTUtil.getFloat(this.minigunStack, "rotation");
        }

        @Override
        public void setMinigunRotation(float minigunRotation) {
            NBTUtil.setFloat(this.minigunStack, "rotation", minigunRotation);
        }

        @Override
        public float getOldMinigunRotation() {
            return NBTUtil.getFloat(this.minigunStack, "oldRotation");
        }

        @Override
        public void setOldMinigunRotation(float oldMinigunRotation) {
            NBTUtil.setFloat(this.minigunStack, "oldRotation", oldMinigunRotation);
        }

        @Override
        public int getUpgrades(EnumUpgrade upgrade) {
            return Math.min(ApplicableUpgradesDB.getInstance().getMaxUpgrades(this.minigunStack.func_77973_b(), upgrade), UpgradableItemUtils.getUpgrades(this.minigunStack, upgrade));
        }
    }

    public static class MagazineHandler
    extends BaseItemStackHandler {
        private final ItemStack gunStack;

        MagazineHandler(ItemStack gunStack) {
            super(4);
            this.gunStack = gunStack;
            if (gunStack.func_77942_o() && gunStack.func_77978_p().func_74764_b(ItemMinigun.NBT_MAGAZINE)) {
                this.deserializeNBT(gunStack.func_77978_p().func_74775_l(ItemMinigun.NBT_MAGAZINE));
            }
        }

        public boolean isItemValid(int slot, ItemStack itemStack) {
            return itemStack.func_190926_b() || itemStack.func_77973_b() instanceof ItemGunAmmo;
        }

        public ItemStack getAmmo() {
            int slot = ItemMinigun.getLockedSlot(this.gunStack);
            if (slot >= 0) {
                return this.getStackInSlot(slot);
            }
            for (int i = 0; i < 4; ++i) {
                if (!(this.getStackInSlot(i).func_77973_b() instanceof ItemGunAmmo)) continue;
                return this.getStackInSlot(i);
            }
            return ItemStack.field_190927_a;
        }

        public void save() {
            if (!this.gunStack.func_190926_b()) {
                NBTUtil.setCompoundTag(this.gunStack, ItemMinigun.NBT_MAGAZINE, (INBT)this.serializeNBT());
            }
        }
    }
}

