/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.minigun;

import java.util.Random;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.client.sound.MovingSounds;
import me.desht.pneumaticcraft.common.config.PNCConfig;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.entity.living.EntityDrone;
import me.desht.pneumaticcraft.common.item.ItemGunAmmo;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlayMovingSound;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;

public abstract class Minigun {
    public static final float MAX_GUN_SPEED = 0.4f;
    private static final float MAX_GUN_YAW_CHANGE = 10.0f;
    private static final float MAX_GUN_PITCH_CHANGE = 10.0f;
    private final boolean requiresTarget;
    private float minigunSpeed;
    private int minigunTriggerTimeOut;
    private int minigunSoundCounter = -1;
    private final Random rand = new Random();
    private float minigunRotation;
    private float oldMinigunRotation;
    public float minigunYaw;
    public float oldMinigunYaw;
    public float minigunPitch;
    public float oldMinigunPitch;
    private boolean sweeping;
    private boolean returning;
    private double sweepingProgress;
    private boolean gunAimedAtTarget;
    private LazyOptional<? extends IAirHandler> airCapability = LazyOptional.empty();
    private int airUsage;
    protected ItemStack minigunStack = ItemStack.field_190927_a;
    private ItemStack ammoStack = ItemStack.field_190927_a;
    protected PlayerEntity player;
    protected World world;
    private LivingEntity attackTarget;
    private float idleYaw;

    public Minigun(boolean requiresTarget) {
        this.requiresTarget = requiresTarget;
    }

    public Minigun setAirHandler(LazyOptional<? extends IAirHandler> airHandler, int airUsage) {
        this.airCapability = airHandler;
        this.airUsage = airUsage;
        return this;
    }

    public Minigun setItemStack(@Nonnull ItemStack stack) {
        this.minigunStack = stack;
        return this;
    }

    public Minigun setAmmoStack(@Nonnull ItemStack ammoStack) {
        this.ammoStack = ammoStack;
        return this;
    }

    @Nonnull
    public ItemStack getAmmoStack() {
        return this.ammoStack;
    }

    public Minigun setPlayer(PlayerEntity player) {
        this.player = player;
        return this;
    }

    public PlayerEntity getPlayer() {
        return this.player;
    }

    public Minigun setWorld(World world) {
        this.world = world;
        return this;
    }

    public World getWorld() {
        return this.world;
    }

    public Minigun setAttackTarget(LivingEntity entity) {
        this.attackTarget = entity;
        return this;
    }

    public boolean isValid() {
        return true;
    }

    public abstract boolean isMinigunActivated();

    public abstract void setMinigunActivated(boolean var1);

    public abstract void setAmmoColorStack(@Nonnull ItemStack var1);

    public abstract int getAmmoColor();

    public abstract void playSound(SoundEvent var1, float var2, float var3);

    protected int getAmmoColor(@Nonnull ItemStack stack) {
        return stack.func_190926_b() ? -13553359 : Minecraft.func_71410_x().getItemColors().func_186728_a(stack, 1);
    }

    public LazyOptional<? extends IAirHandler> getAirCapability() {
        return this.airCapability;
    }

    public Object getSoundSource() {
        return this.player;
    }

    public float getMinigunSpeed() {
        return this.minigunSpeed;
    }

    public void setMinigunSpeed(float minigunSpeed) {
        this.minigunSpeed = minigunSpeed;
    }

    public int getMinigunTriggerTimeOut() {
        return this.minigunTriggerTimeOut;
    }

    public void setMinigunTriggerTimeOut(int minigunTriggerTimeOut) {
        this.minigunTriggerTimeOut = minigunTriggerTimeOut;
    }

    public int getMinigunSoundCounter() {
        return this.minigunSoundCounter;
    }

    public void setMinigunSoundCounter(int minigunSoundCounter) {
        this.minigunSoundCounter = minigunSoundCounter;
    }

    public float getMinigunRotation() {
        return this.minigunRotation;
    }

    public void setMinigunRotation(float minigunRotation) {
        this.minigunRotation = minigunRotation;
    }

    public float getOldMinigunRotation() {
        return this.oldMinigunRotation;
    }

    public void setOldMinigunRotation(float oldMinigunRotation) {
        this.oldMinigunRotation = oldMinigunRotation;
    }

    public LivingEntity getAttackTarget() {
        return this.attackTarget;
    }

    public void setSweeping(boolean sweeping) {
        this.sweeping = sweeping;
    }

    public boolean isSweeping() {
        return this.sweeping;
    }

    public boolean isReturning() {
        return this.returning;
    }

    public void setReturning(boolean returning) {
        this.returning = returning;
    }

    public float getIdleYaw() {
        return this.idleYaw;
    }

    public void setIdleYaw(float idleYaw) {
        this.idleYaw = idleYaw;
    }

    public boolean isGunAimedAtTarget() {
        return this.gunAimedAtTarget;
    }

    public boolean tryFireMinigun(Entity target) {
        boolean lastShotOfAmmo = false;
        if (!this.ammoStack.func_190926_b() && this.ammoStack.func_77952_i() < this.ammoStack.func_77958_k() && ((Boolean)this.airCapability.map(h -> h.getPressure() > 0.0f).orElse((Object)true)).booleanValue()) {
            this.setMinigunTriggerTimeOut(Math.max(10, this.getMinigunSoundCounter()));
            if (this.getMinigunSpeed() == 0.4f && (!this.requiresTarget || this.gunAimedAtTarget)) {
                RayTraceResult rtr = null;
                ItemGunAmmo ammoItem = (ItemGunAmmo)this.ammoStack.func_77973_b();
                if (!this.requiresTarget) {
                    rtr = PneumaticCraftUtils.getMouseOverServer((LivingEntity)this.player, this.getRange());
                    target = rtr instanceof EntityRayTraceResult ? ((EntityRayTraceResult)rtr).func_216348_a() : null;
                }
                this.airCapability.ifPresent(airHandler -> {
                    int usage = (int)Math.ceil((float)this.airUsage * ammoItem.getAirUsageMultiplier(this, this.ammoStack));
                    usage += this.getUpgrades(EnumUpgrade.RANGE);
                    if (this.getUpgrades(EnumUpgrade.SPEED) > 0) {
                        usage *= this.getUpgrades(EnumUpgrade.SPEED) + 1;
                    }
                    airHandler.addAir(-usage);
                });
                int roundsUsed = 1;
                if (target != null) {
                    if (this.getUpgrades(EnumUpgrade.SECURITY) == 0 || !this.securityProtectedTarget(target)) {
                        roundsUsed = ammoItem.onTargetHit(this, this.ammoStack, target);
                    }
                } else if (rtr != null && rtr.func_216346_c() == RayTraceResult.Type.BLOCK) {
                    BlockRayTraceResult brtr = (BlockRayTraceResult)rtr;
                    roundsUsed = ammoItem.onBlockHit(this, this.ammoStack, brtr);
                }
                int ammoCost = roundsUsed * ammoItem.getAmmoCost(this.ammoStack);
                lastShotOfAmmo = this.ammoStack.func_96631_a(ammoCost, this.rand, this.player instanceof ServerPlayerEntity ? (ServerPlayerEntity)this.player : null);
            }
        }
        return lastShotOfAmmo;
    }

    private boolean securityProtectedTarget(Entity target) {
        if (target instanceof TameableEntity) {
            return ((TameableEntity)target).func_70902_q() != null;
        }
        if (target instanceof EntityDrone) {
            return ((EntityDrone)target).getOwner().func_110124_au().equals(this.getPlayer().func_110124_au());
        }
        return target instanceof PlayerEntity;
    }

    public void update(double posX, double posY, double posZ) {
        this.setOldMinigunRotation(this.getMinigunRotation());
        this.oldMinigunYaw = this.minigunYaw;
        this.oldMinigunPitch = this.minigunPitch;
        if (this.attackTarget != null && !this.attackTarget.func_70089_S()) {
            this.attackTarget = null;
        }
        if (!this.world.field_72995_K) {
            this.setMinigunActivated(this.getMinigunTriggerTimeOut() > 0);
            this.setAmmoColorStack(this.ammoStack);
            if (this.getMinigunTriggerTimeOut() > 0) {
                this.setMinigunTriggerTimeOut(this.getMinigunTriggerTimeOut() - 1);
                if (this.getMinigunSpeed() == 0.0f) {
                    this.playSound((SoundEvent)ModSounds.HUD_INIT.get(), 3.0f, 0.9f);
                }
            }
            if (this.getMinigunSoundCounter() == 0 && this.getMinigunTriggerTimeOut() == 0) {
                this.playSound((SoundEvent)ModSounds.MINIGUN_STOP.get(), 3.0f, 0.5f);
                this.setMinigunSoundCounter(-1);
            }
        }
        if (this.isMinigunActivated()) {
            float speedBonus = (float)this.getUpgrades(EnumUpgrade.SPEED) * 0.0033f;
            float lastSpeed = this.getMinigunSpeed();
            this.setMinigunSpeed(Math.min(this.getMinigunSpeed() + 0.01f + speedBonus, 0.4f));
            if (this.getMinigunSpeed() > lastSpeed && this.getMinigunSpeed() >= 0.4f && !this.world.field_72995_K) {
                NetworkHandler.sendToDimension(new PacketPlayMovingSound(MovingSounds.Sound.MINIGUN, this.getSoundSource()), this.world.func_201675_m().func_186058_p());
            }
        } else {
            this.setMinigunSpeed(Math.max(0.0f, this.getMinigunSpeed() - 0.003f));
        }
        this.setMinigunRotation(this.getMinigunRotation() + this.getMinigunSpeed());
        double targetPitch = 0.0;
        if (this.attackTarget != null) {
            double deltaX = posX - this.attackTarget.func_226277_ct_();
            double deltaZ = posZ - this.attackTarget.func_226281_cx_();
            double targetYaw = deltaX >= 0.0 && deltaZ < 0.0 ? Math.atan(Math.abs(deltaX / deltaZ)) / Math.PI * 180.0 : (deltaX >= 0.0 && deltaZ >= 0.0 ? Math.atan(Math.abs(deltaZ / deltaX)) / Math.PI * 180.0 + 90.0 : (deltaX < 0.0 && deltaZ >= 0.0 ? Math.atan(Math.abs(deltaX / deltaZ)) / Math.PI * 180.0 + 180.0 : Math.atan(Math.abs(deltaZ / deltaX)) / Math.PI * 180.0 + 270.0));
            if (targetYaw - (double)this.minigunYaw > 180.0) {
                targetYaw -= 360.0;
            } else if ((double)this.minigunYaw - targetYaw > 180.0) {
                targetYaw += 360.0;
            }
            targetPitch = Math.toDegrees(Math.atan((posY - this.attackTarget.func_226278_cu_() - (double)(this.attackTarget.func_213302_cg() / 2.0f)) / PneumaticCraftUtils.distBetween(posX, posZ, this.attackTarget.func_226277_ct_(), this.attackTarget.func_226281_cx_())));
            this.minigunPitch = this.moveToward(this.minigunPitch, (float)targetPitch, 10.0f);
            this.minigunYaw = this.minigunPitch < -80.0f || this.minigunPitch > 80.0f ? (float)targetYaw : this.moveToward(this.minigunYaw, (float)targetYaw, 10.0f);
            this.gunAimedAtTarget = MathHelper.func_219806_b((double)this.minigunYaw, (double)targetYaw) && MathHelper.func_219806_b((double)this.minigunPitch, (double)targetPitch);
        } else if (this.isReturning()) {
            this.minigunYaw = this.moveToward(this.minigunYaw, this.idleYaw, 10.0f);
            if (PneumaticCraftUtils.areFloatsEqual(this.minigunYaw, this.idleYaw)) {
                this.setReturning(false);
            }
            this.minigunPitch = this.moveToward(this.minigunPitch, (float)targetPitch, 10.0f);
        } else if (this.isSweeping()) {
            this.minigunYaw = (float)((double)this.minigunYaw - Math.cos(this.sweepingProgress) * 22.0);
            this.sweepingProgress += 0.05;
            this.minigunYaw = (float)((double)this.minigunYaw + Math.cos(this.sweepingProgress) * 22.0);
            this.minigunPitch = this.moveToward(this.minigunPitch, (float)targetPitch, 10.0f);
        }
        if (!this.world.field_72995_K && this.isMinigunActivated() && this.getMinigunSpeed() == 0.4f && (!this.requiresTarget || this.gunAimedAtTarget && this.attackTarget != null) && this.getMinigunSoundCounter() <= 0) {
            this.setMinigunSoundCounter(20);
        }
        if (this.getMinigunSoundCounter() > 0) {
            this.setMinigunSoundCounter(this.getMinigunSoundCounter() - 1);
        }
    }

    private float moveToward(float val, float target, float amount) {
        val = val > target ? Math.max(val - amount, target) : Math.min(val + amount, target);
        return val;
    }

    public int getUpgrades(EnumUpgrade upgrade) {
        return 0;
    }

    public double getRange() {
        double mul = this.getAmmoStack().func_77973_b() instanceof ItemGunAmmo ? (double)((ItemGunAmmo)this.ammoStack.func_77973_b()).getRangeMultiplier(this.ammoStack) : 1.0;
        return (double)(PNCConfig.Common.Minigun.baseRange + 5 * this.getUpgrades(EnumUpgrade.RANGE)) * mul;
    }

    public boolean dispenserWeightedPercentage(int basePct) {
        return this.dispenserWeightedPercentage(basePct, 0.1f);
    }

    public boolean dispenserWeightedPercentage(int basePct, float dispenserWeight) {
        return (float)this.getWorld().field_73012_v.nextInt(100) < (float)basePct * (1.0f + (float)this.getUpgrades(EnumUpgrade.DISPENSER) * dispenserWeight);
    }
}

