/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.function.Supplier;
import me.desht.pneumaticcraft.common.item.ItemPneumaticArmor;
import me.desht.pneumaticcraft.common.network.LocationIntPacket;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketCoordTrackUpdate
extends LocationIntPacket {
    private ResourceLocation dimensionID;

    public PacketCoordTrackUpdate() {
    }

    public PacketCoordTrackUpdate(World world, BlockPos pos) {
        super(pos);
        this.dimensionID = DimensionType.func_212678_a((DimensionType)world.func_201675_m().func_186058_p());
    }

    @Override
    public void toBytes(PacketBuffer buffer) {
        super.toBytes(buffer);
        buffer.func_192572_a(this.dimensionID);
    }

    public PacketCoordTrackUpdate(PacketBuffer buffer) {
        super(buffer);
        this.dimensionID = buffer.func_192575_l();
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ItemStack stack = ((NetworkEvent.Context)ctx.get()).getSender().func_184582_a(EquipmentSlotType.HEAD);
            if (stack.func_77973_b() instanceof ItemPneumaticArmor) {
                ItemPneumaticArmor.setCoordTrackerPos(stack, GlobalPos.func_218179_a((DimensionType)DimensionType.func_193417_a((ResourceLocation)this.dimensionID), (BlockPos)this.pos));
                ((NetworkEvent.Context)ctx.get()).getSender().func_146105_b(new StringTextComponent(PneumaticCraftUtils.posToString(this.pos)).func_211708_a(TextFormatting.YELLOW), true);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

