/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.item.ItemPneumaticArmor;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlaySound;
import me.desht.pneumaticcraft.common.network.PacketSetEntityMotion;
import me.desht.pneumaticcraft.common.network.PacketSpawnParticle;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketPneumaticKick {
    public PacketPneumaticKick() {
    }

    PacketPneumaticKick(PacketBuffer buffer) {
    }

    public void toBytes(PacketBuffer buf) {
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            int upgrades;
            CommonArmorHandler handler;
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (ItemPneumaticArmor.isPneumaticArmorPiece((PlayerEntity)player, EquipmentSlotType.FEET) && (handler = CommonArmorHandler.getHandlerForPlayer((PlayerEntity)player)).isArmorEnabled() && handler.isArmorReady(EquipmentSlotType.FEET) && handler.getArmorPressure(EquipmentSlotType.FEET) > 0.1f && (upgrades = handler.getUpgradeCount(EquipmentSlotType.FEET, EnumUpgrade.DISPENSER)) > 0) {
                this.handleKick((PlayerEntity)player, Math.min(4, upgrades));
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private void handleKick(PlayerEntity player, int upgrades) {
        Vec3d lookVec = player.func_70040_Z().func_72432_b();
        double playerFootY = player.func_226278_cu_() - (double)(player.func_213302_cg() / 4.0f);
        AxisAlignedBB box = new AxisAlignedBB(player.func_226277_ct_(), playerFootY, player.func_226281_cx_(), player.func_226277_ct_(), playerFootY, player.func_226281_cx_()).func_72314_b(1.0, 1.0, 1.0).func_191194_a(lookVec);
        List entities = player.field_70170_p.func_72839_b((Entity)player, box);
        if (entities.isEmpty()) {
            return;
        }
        entities.sort(Comparator.comparingDouble(o -> o.func_70068_e((Entity)player)));
        Entity target = (Entity)entities.get(0);
        if (target instanceof MobEntity) {
            target.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player), 3.0f + (float)upgrades * 0.5f);
        }
        target.func_213317_d(target.func_213322_ci().func_178787_e(lookVec.func_186678_a(1.0 + (double)((float)upgrades * 0.5f))));
        NetworkHandler.sendToAllAround(new PacketPlaySound((SoundEvent)ModSounds.PUNCH.get(), SoundCategory.PLAYERS, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), 1.0f, 1.0f, false), player.field_70170_p);
        NetworkHandler.sendToAllAround(new PacketSetEntityMotion(target, target.func_213322_ci()), player.field_70170_p);
        NetworkHandler.sendToAllAround(new PacketSpawnParticle((IParticleData)ParticleTypes.field_197627_t, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), 1.0, 0.0, 0.0), player.field_70170_p);
        CommonArmorHandler.getHandlerForPlayer(player).addAir(EquipmentSlotType.FEET, -100 * (2 << upgrades));
    }
}

