/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.pneumatic_armor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IHackableBlock;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IHackableEntity;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IUpgradeRenderHandler;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerItem;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.UpgradeRenderHandlerList;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.ChargingUpgradeHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.EntityTrackUpgradeHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.JetBootsUpgradeHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.JumpBoostUpgradeHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.MagnetUpgradeHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.MainHelmetHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.NightVisionUpgradeHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.RunSpeedUpgradeHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.ScubaUpgradeHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.StepAssistUpgradeHandler;
import me.desht.pneumaticcraft.client.sound.MovingSounds;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.advancements.AdvancementTriggers;
import me.desht.pneumaticcraft.common.config.PNCConfig;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.event.HackTickHandler;
import me.desht.pneumaticcraft.common.hacking.HackableHandler;
import me.desht.pneumaticcraft.common.hacking.WorldAndCoord;
import me.desht.pneumaticcraft.common.item.ItemMachineUpgrade;
import me.desht.pneumaticcraft.common.item.ItemPneumaticArmor;
import me.desht.pneumaticcraft.common.item.ItemRegistry;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketHackingBlockFinish;
import me.desht.pneumaticcraft.common.network.PacketHackingEntityFinish;
import me.desht.pneumaticcraft.common.network.PacketPlayMovingSound;
import me.desht.pneumaticcraft.common.network.PacketPlaySound;
import me.desht.pneumaticcraft.common.network.PacketSpawnParticle;
import me.desht.pneumaticcraft.common.pneumatic_armor.JetBootsStateTracker;
import me.desht.pneumaticcraft.common.util.UpgradableItemUtils;
import me.desht.pneumaticcraft.common.util.upgrade.ApplicableUpgradesDB;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;

public class CommonArmorHandler {
    private static final CommonArmorHandler clientHandler = new CommonArmorHandler(null);
    private static final CommonArmorHandler serverHandler = new CommonArmorHandler(null);
    private static final Vec3d FORWARD = new Vec3d(0.0, 0.0, 1.0);
    private final HashMap<UUID, CommonArmorHandler> playerHandlers = new HashMap();
    private PlayerEntity player;
    private int magnetRadius;
    private int magnetRadiusSq;
    private final boolean[][] upgradeRenderersInserted = new boolean[4][];
    private final boolean[][] upgradeRenderersEnabled = new boolean[4][];
    private final int[] ticksSinceEquip = new int[4];
    private final List<LazyOptional<IAirHandlerItem>> airHandlers = new ArrayList<LazyOptional<IAirHandlerItem>>();
    private final int[][] upgradeMatrix = new int[4][];
    private final int[] startupTimes = new int[4];
    private boolean isValid;
    private int hackTime;
    private WorldAndCoord hackedBlockPos;
    private Entity hackedEntity;
    private boolean armorEnabled;
    private boolean magnetEnabled;
    private boolean chargingEnabled;
    private boolean stepAssistEnabled;
    private boolean runSpeedEnabled;
    private boolean jumpBoostEnabled;
    private boolean entityTrackerEnabled;
    private boolean nightVisionEnabled;
    private boolean scubaEnabled;
    private boolean jetBootsEnabled;
    private boolean jetBootsActive;
    private float flightAccel = 1.0f;
    private int prevJetBootsAirUsage;
    private int jetBootsActiveTicks;
    private boolean wasNightVisionEnabled;
    private float speedBoostMult;
    private boolean jetBootsBuilderMode;
    private float jetBootsPower;
    private static final Map<UUID, Vec3d> moveMap = new HashMap<UUID, Vec3d>();

    private CommonArmorHandler(PlayerEntity player) {
        this.player = player;
        for (EquipmentSlotType slot : UpgradeRenderHandlerList.ARMOR_SLOTS) {
            List<IUpgradeRenderHandler> renderHandlers = UpgradeRenderHandlerList.instance().getHandlersForSlot(slot);
            this.upgradeRenderersInserted[slot.func_188454_b()] = new boolean[renderHandlers.size()];
            this.upgradeRenderersEnabled[slot.func_188454_b()] = new boolean[renderHandlers.size()];
            this.upgradeMatrix[slot.func_188454_b()] = new int[EnumUpgrade.values().length];
        }
        Arrays.fill(this.startupTimes, 200);
        for (int i = 0; i < 4; ++i) {
            this.airHandlers.add((LazyOptional<IAirHandlerItem>)LazyOptional.empty());
        }
        this.isValid = true;
    }

    private static CommonArmorHandler getManagerInstance(PlayerEntity player) {
        return player.field_70170_p.field_72995_K ? clientHandler : serverHandler;
    }

    public static CommonArmorHandler getHandlerForPlayer(PlayerEntity player) {
        return CommonArmorHandler.getManagerInstance((PlayerEntity)player).playerHandlers.computeIfAbsent(player.func_110124_au(), v -> new CommonArmorHandler(player));
    }

    public static CommonArmorHandler getHandlerForPlayer() {
        return CommonArmorHandler.getHandlerForPlayer(ClientUtils.getClientPlayer());
    }

    private static void clearHandlerForPlayer(PlayerEntity player) {
        CommonArmorHandler h = CommonArmorHandler.getManagerInstance(player);
        h.playerHandlers.computeIfPresent(player.func_110124_au(), (name, val) -> {
            val.invalidate();
            return null;
        });
    }

    private void tick() {
        for (EquipmentSlotType slot : UpgradeRenderHandlerList.ARMOR_SLOTS) {
            this.tickArmorPiece(slot);
        }
        if (!this.player.field_70170_p.field_72995_K) {
            this.handleHacking();
        }
    }

    private void tickArmorPiece(EquipmentSlotType slot) {
        ItemStack armorStack = this.player.func_184582_a(slot);
        boolean armorActive = false;
        if (armorStack.func_77973_b() instanceof ItemPneumaticArmor) {
            this.airHandlers.set(slot.func_188454_b(), (LazyOptional<IAirHandlerItem>)armorStack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY));
            if (this.ticksSinceEquip[slot.func_188454_b()] == 0) {
                this.initArmorInventory(slot);
            }
            int n = slot.func_188454_b();
            this.ticksSinceEquip[n] = this.ticksSinceEquip[n] + 1;
            if (this.armorEnabled && this.getArmorPressure(slot) > 0.0f) {
                float oldPressure;
                float airUsage;
                armorActive = true;
                if (!this.player.field_70170_p.field_72995_K && this.isArmorReady(slot) && !this.player.func_184812_l_() && (airUsage = UpgradeRenderHandlerList.instance().getAirUsage(this.player, slot, false)) != 0.0f && (oldPressure = this.addAir(slot, (int)(-airUsage))) > 0.0f && this.getArmorPressure(slot) == 0.0f) {
                    NetworkHandler.sendToPlayer(new PacketPlaySound((SoundEvent)ModSounds.MINIGUN_STOP.get(), SoundCategory.PLAYERS, this.player.func_226277_ct_(), this.player.func_226278_cu_(), this.player.func_226281_cx_(), 1.0f, 2.0f, false), (ServerPlayerEntity)this.player);
                }
                this.doArmorActions(slot);
            }
        }
        if (!armorActive) {
            if (this.ticksSinceEquip[slot.func_188454_b()] > 0) {
                this.onArmorRemoved(slot);
            }
            this.ticksSinceEquip[slot.func_188454_b()] = 0;
        }
    }

    private void onArmorRemoved(EquipmentSlotType slot) {
        switch (slot) {
            case HEAD: {
                if (!this.nightVisionEnabled) break;
                this.player.func_184596_c(Effects.field_76439_r);
                break;
            }
            case FEET: {
                this.player.field_70138_W = 0.6f;
            }
        }
    }

    public float addAir(EquipmentSlotType slot, int airAmount) {
        float oldPressure = this.getArmorPressure(slot);
        if (!this.player.func_184812_l_() || airAmount > 0) {
            this.airHandlers.get(slot.func_188454_b()).ifPresent(h -> h.addAir(airAmount));
        }
        return oldPressure;
    }

    private void doArmorActions(EquipmentSlotType slot) {
        if (!this.isArmorReady(slot)) {
            return;
        }
        switch (slot) {
            case HEAD: {
                this.handleNightVision();
                this.handleScuba();
                break;
            }
            case CHEST: {
                this.handleChestplateMagnet();
                this.handleChestplateCharging();
                break;
            }
            case LEGS: {
                this.handleLeggingsSpeedBoost();
                break;
            }
            case FEET: {
                this.player.field_70138_W = this.getArmorPressure(EquipmentSlotType.FEET) > 0.0f && this.isStepAssistEnabled() ? (this.player.func_225608_bj_() ? 0.6001f : 1.25f) : 0.6f;
                this.handleJetBoots();
                this.handleFlippersSpeedBoost();
            }
        }
        if (!this.player.field_70170_p.field_72995_K && this.getUpgradeCount(slot, EnumUpgrade.ITEM_LIFE) > 0) {
            this.handleItemRepair(slot);
        }
    }

    private void handleNightVision() {
        if (!this.player.field_70170_p.field_72995_K && (this.getTicksSinceEquipped(EquipmentSlotType.HEAD) & 7) == 0) {
            boolean shouldEnable;
            boolean bl = shouldEnable = this.getArmorPressure(EquipmentSlotType.HEAD) > 0.0f && this.getUpgradeCount(EquipmentSlotType.HEAD, EnumUpgrade.NIGHT_VISION) > 0 && this.nightVisionEnabled;
            if (shouldEnable) {
                this.player.func_195064_c(new EffectInstance(Effects.field_76439_r, 500, 0, false, false));
                this.addAir(EquipmentSlotType.HEAD, -8);
            } else if (!shouldEnable && this.wasNightVisionEnabled) {
                this.player.func_195063_d(Effects.field_76439_r);
            }
            this.wasNightVisionEnabled = shouldEnable;
        }
    }

    private void handleScuba() {
        if (!this.player.field_70170_p.field_72995_K && this.scubaEnabled && this.getUpgradeCount(EquipmentSlotType.HEAD, EnumUpgrade.SCUBA) > 0 && this.getArmorPressure(EquipmentSlotType.HEAD) > 0.1f && this.player.func_70086_ai() < 200) {
            ItemStack helmetStack = this.player.func_184582_a(EquipmentSlotType.HEAD);
            int vol = ApplicableUpgradesDB.getInstance().getUpgradedVolume(((ItemPneumaticArmor)helmetStack.func_77973_b()).getBaseVolume(), this.getUpgradeCount(EquipmentSlotType.HEAD, EnumUpgrade.VOLUME));
            float airInHelmet = this.getArmorPressure(EquipmentSlotType.HEAD) * (float)vol;
            int playerAir = (int)Math.min((float)(300 - this.player.func_70086_ai()), airInHelmet / (float)PNCConfig.Common.Armor.scubaMultiplier);
            this.player.func_70050_g(this.player.func_70086_ai() + playerAir);
            int airUsed = playerAir * PNCConfig.Common.Armor.scubaMultiplier;
            this.addAir(EquipmentSlotType.HEAD, -airUsed);
            NetworkHandler.sendToPlayer(new PacketPlaySound((SoundEvent)ModSounds.SCUBA.get(), SoundCategory.PLAYERS, this.player.func_180425_c(), 1.5f, 1.0f, false), (ServerPlayerEntity)this.player);
            Vec3d eyes = this.player.func_174824_e(1.0f).func_178787_e(this.player.func_70040_Z().func_186678_a(0.5));
            NetworkHandler.sendToAllAround(new PacketSpawnParticle((IParticleData)ParticleTypes.field_197612_e, eyes.field_72450_a - 0.5, eyes.field_72448_b, eyes.field_72449_c - 0.5, 0.0, 0.2, 0.0, 10, 1.0, 1.0, 1.0), this.player.field_70170_p);
        }
    }

    private void handleLeggingsSpeedBoost() {
        double speedBoost = this.getSpeedBoostFromLegs();
        if (this.player.field_70170_p.field_72995_K && this.player.field_191988_bg > 0.0f) {
            if (!this.player.field_70122_E && this.isJetBootsEnabled() && this.jetBootsBuilderMode) {
                this.player.func_213309_a((float)this.getUpgradeCount(EquipmentSlotType.FEET, EnumUpgrade.JET_BOOTS) / 250.0f, FORWARD);
            }
            if (this.player.field_70122_E && !this.player.func_70090_H()) {
                this.player.func_213309_a((float)speedBoost, FORWARD);
            }
        }
        if (!this.player.field_70170_p.field_72995_K && speedBoost > 0.0) {
            boolean moved;
            Vec3d prev = moveMap.get(this.player.func_110124_au());
            boolean bl = moved = prev != null && (Math.abs(this.player.func_226277_ct_() - prev.field_72450_a) > 1.0E-4 || Math.abs(this.player.func_226281_cx_() - prev.field_72449_c) > 1.0E-4);
            if (moved && this.player.field_70122_E && !this.player.func_70090_H()) {
                int airUsage = (int)Math.ceil(1.0 * speedBoost * 8.0);
                this.addAir(EquipmentSlotType.LEGS, -airUsage);
            }
            moveMap.put(this.player.func_110124_au(), this.player.func_174791_d());
        }
    }

    public double getSpeedBoostFromLegs() {
        int speedUpgrades = this.getUpgradeCount(EquipmentSlotType.LEGS, EnumUpgrade.SPEED, 4);
        if (this.isArmorReady(EquipmentSlotType.LEGS) && speedUpgrades > 0 && this.isRunSpeedEnabled() && this.getArmorPressure(EquipmentSlotType.LEGS) > 0.0f) {
            return 0.035f * (float)speedUpgrades * this.speedBoostMult;
        }
        return 0.0;
    }

    private void handleFlippersSpeedBoost() {
        if (this.player.field_70170_p.field_72995_K && this.player.func_70090_H() && this.player.field_191988_bg > 0.0f && this.isArmorReady(EquipmentSlotType.FEET) && this.getUpgradeCount(EquipmentSlotType.FEET, EnumUpgrade.FLIPPERS) > 0) {
            this.player.func_213309_a((float)(this.player.field_70122_E ? PNCConfig.Common.Armor.flippersSpeedBoostGround : PNCConfig.Common.Armor.flippersSpeedBoostFloating), FORWARD);
        }
    }

    private void setYMotion(Entity entity, double y) {
        Vec3d v = entity.func_213322_ci();
        v = v.func_72441_c(0.0, y - v.field_72448_b, 0.0);
        entity.func_213317_d(v);
    }

    private void handleJetBoots() {
        int jetbootsCount = this.getUpgradeCount(EquipmentSlotType.FEET, EnumUpgrade.JET_BOOTS, 5);
        if (jetbootsCount == 0) {
            return;
        }
        int jetbootsAirUsage = 0;
        if (this.getArmorPressure(EquipmentSlotType.FEET) > 0.0f) {
            if (this.isJetBootsActive()) {
                if (this.jetBootsBuilderMode && jetbootsCount >= 3) {
                    this.setYMotion((Entity)this.player, this.player.func_225608_bj_() ? 0.0 : 0.15 + 0.15 * (double)(jetbootsCount - 3));
                    jetbootsAirUsage = (int)((float)(PNCConfig.Common.Armor.jetBootsAirUsage * jetbootsCount) / 2.5f);
                } else {
                    Vec3d lookVec = this.player.func_70040_Z().func_186678_a(0.3 * (double)jetbootsCount);
                    float div = lookVec.field_72448_b > 0.0 ? -64.0f : -16.0f;
                    this.flightAccel = MathHelper.func_76131_a((float)(this.flightAccel + (float)lookVec.field_72448_b / div), (float)0.8f, (float)4.2f);
                    lookVec = lookVec.func_186678_a((double)(this.flightAccel * this.jetBootsPower));
                    if (this.jetBootsActiveTicks < 10) {
                        lookVec = lookVec.func_186678_a((double)this.jetBootsActiveTicks * 0.1);
                    }
                    this.player.func_213293_j(lookVec.field_72450_a, this.player.field_70122_E ? 0.0 : lookVec.field_72448_b, lookVec.field_72449_c);
                    jetbootsAirUsage = (int)((float)(PNCConfig.Common.Armor.jetBootsAirUsage * jetbootsCount) * this.jetBootsPower);
                }
                if (this.player.func_70090_H()) {
                    jetbootsAirUsage *= 4;
                }
                ++this.jetBootsActiveTicks;
            } else if (this.isJetBootsEnabled() && !this.player.field_70122_E) {
                this.setYMotion((Entity)this.player, this.player.func_225608_bj_() ? -0.45 : -0.1 + 0.02 * (double)jetbootsCount);
                this.player.field_70143_R = 0.0f;
                jetbootsAirUsage = (int)((float)PNCConfig.Common.Armor.jetBootsAirUsage * (this.player.func_225608_bj_() ? 0.25f : 0.5f));
                this.flightAccel = 1.0f;
            } else {
                this.flightAccel = 1.0f;
            }
        }
        if (jetbootsAirUsage != 0 && !this.player.field_70170_p.field_72995_K) {
            if (this.prevJetBootsAirUsage == 0) {
                NetworkHandler.sendToDimension(new PacketPlayMovingSound(MovingSounds.Sound.JET_BOOTS, this.player), this.player.field_70170_p.func_201675_m().func_186058_p());
                AdvancementTriggers.FLIGHT.trigger((ServerPlayerEntity)this.player);
            }
            if (this.player.field_70123_F) {
                double vel = this.player.func_213322_ci().func_72433_c();
                if (this.player.field_70170_p.func_175659_aa() == Difficulty.HARD) {
                    vel *= 2.0;
                } else if (this.player.field_70170_p.func_175659_aa() == Difficulty.NORMAL) {
                    vel *= 1.5;
                }
                if (vel > 2.0) {
                    this.player.func_184185_a(vel > 2.5 ? SoundEvents.field_187655_bw : SoundEvents.field_187545_bE, 1.0f, 1.0f);
                    this.player.func_70097_a(DamageSource.field_188406_j, (float)vel);
                    AdvancementTriggers.FLY_INTO_WALL.trigger((ServerPlayerEntity)this.player);
                }
            }
            this.addAir(EquipmentSlotType.FEET, -jetbootsAirUsage);
        }
        this.prevJetBootsAirUsage = jetbootsAirUsage;
    }

    private void handleChestplateCharging() {
        if (this.player.field_70170_p.field_72995_K || !this.chargingEnabled || this.getUpgradeCount(EquipmentSlotType.CHEST, EnumUpgrade.CHARGING) == 0 || this.getTicksSinceEquipped(EquipmentSlotType.CHEST) % 20 != 5) {
            return;
        }
        int upgrades = this.getUpgradeCount(EquipmentSlotType.CHEST, EnumUpgrade.CHARGING, 6);
        int airAmount = upgrades * 100 + 100;
        for (EquipmentSlotType slot : EquipmentSlotType.values()) {
            if (slot == EquipmentSlotType.CHEST) continue;
            if (this.getArmorPressure(EquipmentSlotType.CHEST) < 0.1f) {
                return;
            }
            ItemStack stack = this.player.func_184582_a(slot);
            this.tryPressurize(airAmount, stack);
        }
        for (ItemStack stack : this.player.field_71071_by.field_70462_a) {
            if (this.getArmorPressure(EquipmentSlotType.CHEST) < 0.1f) {
                return;
            }
            this.tryPressurize(airAmount, stack);
        }
    }

    private void tryPressurize(int airAmount, ItemStack destStack) {
        destStack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).ifPresent(destHandler -> {
            float pressure = destHandler.getPressure();
            if (pressure < destHandler.maxPressure() && pressure < this.getArmorPressure(EquipmentSlotType.CHEST)) {
                float currentAir = pressure * (float)destHandler.getVolume();
                float targetAir = this.getArmorPressure(EquipmentSlotType.CHEST) * (float)destHandler.getVolume();
                int amountToMove = Math.min((int)(targetAir - currentAir), airAmount);
                destHandler.addAir(amountToMove);
                this.addAir(EquipmentSlotType.CHEST, -amountToMove);
            }
        });
    }

    private void handleItemRepair(EquipmentSlotType slot) {
        int upgrades = this.getUpgradeCount(slot, EnumUpgrade.ITEM_LIFE, 5);
        int interval = 120 - 20 * upgrades;
        int airUsage = PNCConfig.Common.Armor.repairAirUsage * upgrades;
        ItemStack armorStack = this.player.func_184582_a(slot);
        if (armorStack.func_77952_i() > 0 && this.getArmorPressure(slot) > 0.1f && this.ticksSinceEquip[slot.func_188454_b()] % interval == 0) {
            this.addAir(slot, -airUsage);
            armorStack.func_196085_b(armorStack.func_77952_i() - 1);
        }
    }

    private void handleChestplateMagnet() {
        if (this.player.field_70170_p.field_72995_K || !this.magnetEnabled || (this.getTicksSinceEquipped(EquipmentSlotType.CHEST) & 3) != 0 || this.getUpgradeCount(EquipmentSlotType.CHEST, EnumUpgrade.MAGNET) == 0) {
            return;
        }
        AxisAlignedBB box = new AxisAlignedBB(this.player.func_180425_c()).func_186662_g((double)this.magnetRadius);
        List itemList = this.player.func_130014_f_().func_175647_a(Entity.class, box, e -> (e instanceof ExperienceOrbEntity || e instanceof ItemEntity) && e.func_70089_S());
        Vec3d playerVec = this.player.func_174791_d();
        for (Entity item : itemList) {
            if (item instanceof ItemEntity && ((ItemEntity)item).func_174874_s() || !(item.func_174791_d().func_72436_e(playerVec) <= (double)this.magnetRadiusSq) || ItemRegistry.getInstance().shouldSuppressMagnet(item) || item.getPersistentData().func_74767_n("PreventRemoteMovement")) continue;
            if (this.getArmorPressure(EquipmentSlotType.CHEST) < 0.1f) break;
            item.func_70107_b(this.player.func_226277_ct_(), this.player.func_226278_cu_(), this.player.func_226281_cx_());
            if (item instanceof ItemEntity) {
                ((ItemEntity)item).func_174867_a(0);
            }
            this.addAir(EquipmentSlotType.CHEST, -PNCConfig.Common.Armor.magnetAirUsage);
        }
    }

    private void handleHacking() {
        if (this.hackedBlockPos != null) {
            IHackableBlock hackableBlock = HackableHandler.getHackableForBlock(this.hackedBlockPos.world, this.hackedBlockPos.pos, this.player);
            if (hackableBlock != null) {
                IBlockReader world = this.hackedBlockPos.world;
                if (world != null && ++this.hackTime >= hackableBlock.getHackTime(world, this.hackedBlockPos.pos, this.player)) {
                    hackableBlock.onHackComplete(this.player.field_70170_p, this.hackedBlockPos.pos, this.player);
                    HackTickHandler.instance().trackBlock(this.player.field_70170_p, this.hackedBlockPos.pos, hackableBlock);
                    NetworkHandler.sendToAllAround(new PacketHackingBlockFinish(this.hackedBlockPos), this.player.field_70170_p);
                    this.setHackedBlockPos(null);
                    AdvancementTriggers.BLOCK_HACK.trigger((ServerPlayerEntity)this.player);
                }
            } else {
                this.setHackedBlockPos(null);
            }
        } else if (this.hackedEntity != null) {
            IHackableEntity hackableEntity = HackableHandler.getHackableForEntity(this.hackedEntity, this.player);
            if (hackableEntity != null) {
                if (++this.hackTime >= hackableEntity.getHackTime(this.hackedEntity, this.player)) {
                    if (this.hackedEntity.func_70089_S()) {
                        hackableEntity.onHackFinished(this.hackedEntity, this.player);
                        HackTickHandler.instance().trackEntity(this.hackedEntity, hackableEntity);
                        NetworkHandler.sendToAllAround(new PacketHackingEntityFinish(this.hackedEntity), new PacketDistributor.TargetPoint(this.hackedEntity.func_226277_ct_(), this.hackedEntity.func_226278_cu_(), this.hackedEntity.func_226281_cx_(), 64.0, this.hackedEntity.field_70170_p.func_201675_m().func_186058_p()));
                        AdvancementTriggers.ENTITY_HACK.trigger((ServerPlayerEntity)this.player);
                    }
                    this.setHackedEntity(null);
                }
            } else {
                this.setHackedEntity(null);
            }
        }
    }

    public void initArmorInventory(EquipmentSlotType slot) {
        ItemStack armorStack = this.player.func_184582_a(slot);
        ItemStack[] upgradeStacks = UpgradableItemUtils.getUpgradeStacks(armorStack);
        Arrays.fill(this.upgradeRenderersInserted[slot.func_188454_b()], false);
        for (int i = 0; i < this.upgradeRenderersInserted[slot.func_188454_b()].length; ++i) {
            this.upgradeRenderersInserted[slot.func_188454_b()][i] = this.isModuleEnabled(upgradeStacks, UpgradeRenderHandlerList.instance().getHandlersForSlot(slot).get(i));
        }
        Arrays.fill(this.upgradeMatrix[slot.func_188454_b()], 0);
        for (ItemStack stack : upgradeStacks) {
            if (!(stack.func_77973_b() instanceof ItemMachineUpgrade)) continue;
            ItemMachineUpgrade item = (ItemMachineUpgrade)stack.func_77973_b();
            int[] nArray = this.upgradeMatrix[slot.func_188454_b()];
            int n = item.getUpgradeType().ordinal();
            nArray[n] = nArray[n] + stack.func_190916_E() * item.getTier();
        }
        this.startupTimes[slot.func_188454_b()] = (int)((double)PNCConfig.Common.Armor.armorStartupTime * Math.pow(0.8, this.getSpeedFromUpgrades(slot) - 1));
        switch (slot) {
            case CHEST: {
                this.magnetRadius = 4 + Math.min(this.getUpgradeCount(EquipmentSlotType.CHEST, EnumUpgrade.MAGNET), 6);
                this.magnetRadiusSq = this.magnetRadius * this.magnetRadius;
                break;
            }
            case LEGS: {
                this.speedBoostMult = (float)ItemPneumaticArmor.getIntData(armorStack, "speedBoost", 100, 0, 100) / 100.0f;
                break;
            }
            case FEET: {
                this.jetBootsBuilderMode = ItemPneumaticArmor.getBooleanData(armorStack, "JetBootsBuilderMode", false);
                this.jetBootsPower = (float)ItemPneumaticArmor.getIntData(armorStack, "JetBootsPower", 100, 0, 100) / 100.0f;
                JetBootsStateTracker.getTracker(this.player).setJetBootsState(this.player, this.isJetBootsEnabled(), this.isJetBootsActive(), this.jetBootsBuilderMode);
            }
        }
    }

    public int getUpgradeCount(EquipmentSlotType slot, EnumUpgrade upgrade) {
        return this.upgradeMatrix[slot.func_188454_b()][upgrade.ordinal()];
    }

    public int getUpgradeCount(EquipmentSlotType slot, EnumUpgrade upgrade, int max) {
        return Math.min(max, this.upgradeMatrix[slot.func_188454_b()][upgrade.ordinal()]);
    }

    public boolean isUpgradeRendererInserted(EquipmentSlotType slot, int i) {
        return this.upgradeRenderersInserted[slot.func_188454_b()][i];
    }

    public boolean isUpgradeRendererEnabled(EquipmentSlotType slot, int i) {
        return this.upgradeRenderersEnabled[slot.func_188454_b()][i];
    }

    public void setUpgradeRenderEnabled(EquipmentSlotType slot, byte featureIndex, boolean state) {
        this.upgradeRenderersEnabled[slot.func_188454_b()][featureIndex] = state;
        IUpgradeRenderHandler handler = UpgradeRenderHandlerList.instance().getHandlersForSlot(slot).get(featureIndex);
        if (handler instanceof MagnetUpgradeHandler) {
            this.magnetEnabled = state;
        } else if (handler instanceof ChargingUpgradeHandler) {
            this.chargingEnabled = state;
        } else if (handler instanceof StepAssistUpgradeHandler) {
            this.stepAssistEnabled = state;
        } else if (handler instanceof RunSpeedUpgradeHandler) {
            this.runSpeedEnabled = state;
        } else if (handler instanceof JumpBoostUpgradeHandler) {
            this.jumpBoostEnabled = state;
        } else if (handler instanceof JetBootsUpgradeHandler) {
            this.jetBootsEnabled = state;
            JetBootsStateTracker.getTracker(this.player).setJetBootsState(this.player, this.jetBootsEnabled, this.isJetBootsActive(), this.isJetBootsBuilderMode());
        } else if (handler instanceof MainHelmetHandler) {
            this.armorEnabled = state;
        } else if (handler instanceof EntityTrackUpgradeHandler) {
            this.entityTrackerEnabled = state;
        } else if (handler instanceof NightVisionUpgradeHandler) {
            this.nightVisionEnabled = state;
        } else if (handler instanceof ScubaUpgradeHandler) {
            this.scubaEnabled = state;
        }
    }

    public int getTicksSinceEquipped(EquipmentSlotType slot) {
        return this.ticksSinceEquip[slot.func_188454_b()];
    }

    private boolean isModuleEnabled(ItemStack[] helmetStacks, IUpgradeRenderHandler handler) {
        for (EnumUpgrade requiredUpgrade : handler.getRequiredUpgrades()) {
            boolean found = false;
            for (ItemStack stack : helmetStacks) {
                if (EnumUpgrade.from(stack) != requiredUpgrade) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public int getSpeedFromUpgrades(EquipmentSlotType slot) {
        return 1 + this.getUpgradeCount(slot, EnumUpgrade.SPEED);
    }

    public int getStartupTime(EquipmentSlotType slot) {
        return this.startupTimes[slot.func_188454_b()];
    }

    public void setHackedBlockPos(WorldAndCoord blockPos) {
        this.hackedBlockPos = blockPos;
        this.hackedEntity = null;
        this.hackTime = 0;
    }

    public void setHackedEntity(Entity entity) {
        this.hackedEntity = entity;
        this.hackedBlockPos = null;
        this.hackTime = 0;
    }

    public boolean isArmorReady(EquipmentSlotType slot) {
        return this.getTicksSinceEquipped(slot) > this.getStartupTime(slot);
    }

    public boolean isStepAssistEnabled() {
        return this.stepAssistEnabled;
    }

    public boolean isRunSpeedEnabled() {
        return this.runSpeedEnabled;
    }

    public boolean isJumpBoostEnabled() {
        return this.jumpBoostEnabled;
    }

    public float getArmorPressure(EquipmentSlotType slot) {
        return ((Float)this.airHandlers.get(slot.func_188454_b()).map(IAirHandler::getPressure).orElse((Object)Float.valueOf(0.0f))).floatValue();
    }

    public void setJetBootsActive(boolean jetBootsActive) {
        if (!jetBootsActive) {
            this.jetBootsActiveTicks = 0;
        }
        this.jetBootsActive = jetBootsActive;
        JetBootsStateTracker.getTracker(this.player).setJetBootsState(this.player, this.isJetBootsEnabled(), jetBootsActive, this.isJetBootsBuilderMode());
    }

    public boolean isJetBootsActive() {
        return this.jetBootsActive;
    }

    public boolean isJetBootsEnabled() {
        return this.jetBootsEnabled;
    }

    public boolean isArmorEnabled() {
        return this.armorEnabled;
    }

    public boolean isEntityTrackerEnabled() {
        return this.entityTrackerEnabled;
    }

    public boolean isScubaEnabled() {
        return this.scubaEnabled;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void invalidate() {
        this.isValid = false;
    }

    public boolean isJetBootsBuilderMode() {
        return this.jetBootsBuilderMode;
    }

    public void onDataFieldUpdated(String key, INBT dataTag) {
        switch (key) {
            case "speedBoost": {
                this.speedBoostMult = MathHelper.func_76131_a((float)((float)((IntNBT)dataTag).func_150287_d() / 100.0f), (float)0.0f, (float)1.0f);
                break;
            }
            case "JetBootsBuilderMode": {
                this.jetBootsBuilderMode = ((ByteNBT)dataTag).func_150290_f() == 1;
                JetBootsStateTracker.getTracker(this.player).getJetBootsState(this.player).setBuilderMode(this.jetBootsBuilderMode);
                break;
            }
            case "JetBootsPower": {
                this.jetBootsPower = MathHelper.func_76131_a((float)((float)((IntNBT)dataTag).func_150287_d() / 100.0f), (float)0.0f, (float)1.0f);
            }
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
    public static class ClientListeners {
        @SubscribeEvent
        public static void onClientDisconnect(ClientPlayerNetworkEvent.LoggedOutEvent event) {
            PlayerEntity player = ClientUtils.getClientPlayer();
            if (player != null) {
                CommonArmorHandler.clearHandlerForPlayer(player);
            }
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class Listeners {
        @SubscribeEvent
        public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
            if (event.phase == TickEvent.Phase.END) {
                CommonArmorHandler.getHandlerForPlayer(event.player).tick();
            }
        }

        @SubscribeEvent
        public static void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
            CommonArmorHandler.clearHandlerForPlayer(event.getPlayer());
        }

        @SubscribeEvent
        public static void onPlayerJoinWorld(EntityJoinWorldEvent event) {
            PlayerEntity player;
            CommonArmorHandler handler;
            if (event.getEntity() instanceof PlayerEntity && (handler = (CommonArmorHandler)CommonArmorHandler.getManagerInstance(player = (PlayerEntity)event.getEntity()).playerHandlers.get(player.func_110124_au())) != null) {
                handler.player = player;
            }
        }
    }
}

