/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.progwidgets;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.ai.DroneAIManager;
import me.desht.pneumaticcraft.common.config.PNCConfig;
import me.desht.pneumaticcraft.common.core.ModProgWidgets;
import me.desht.pneumaticcraft.common.progwidgets.EntityFilterPair;
import me.desht.pneumaticcraft.common.progwidgets.IAreaProvider;
import me.desht.pneumaticcraft.common.progwidgets.IEntityProvider;
import me.desht.pneumaticcraft.common.progwidgets.IItemFiltering;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.IVariableWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetArea;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetItemFilter;
import me.desht.pneumaticcraft.common.util.ChunkCache;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.ICollisionReader;
import net.minecraft.world.World;

public abstract class ProgWidgetAreaItemBase
extends ProgWidget
implements IAreaProvider,
IEntityProvider,
IItemFiltering,
IVariableWidget {
    private List<BlockPos> areaListCache;
    private Set<BlockPos> areaSetCache;
    private Map<String, BlockPos> areaVariableStates;
    protected DroneAIManager aiManager;
    private boolean canCache = true;
    private EntityFilterPair<ProgWidgetAreaItemBase> entityFilters;

    public ProgWidgetAreaItemBase(ProgWidgetType<?> type) {
        super(type);
    }

    @Override
    public boolean hasStepInput() {
        return true;
    }

    @Override
    public ProgWidgetType<?> returnType() {
        return null;
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return ImmutableList.of(ModProgWidgets.AREA, ModProgWidgets.ITEM_FILTER);
    }

    @Override
    public void addErrors(List<ITextComponent> curInfo, List<IProgWidget> widgets) {
        Set<BlockPos> areaSet;
        super.addErrors(curInfo, widgets);
        if (this.getConnectedParameters()[0] == null) {
            curInfo.add(PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.area.error.noArea", new Object[0]));
        }
        if ((areaSet = this.getCachedAreaSet()).size() > PNCConfig.Common.General.maxProgrammingArea) {
            curInfo.add(PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.area.error.areaTooBig", PNCConfig.Common.General.maxProgrammingArea));
        }
        EntityFilterPair.addErrors(this, curInfo);
    }

    public static ICollisionReader getCache(Collection<BlockPos> area, World world) {
        if (area.isEmpty()) {
            return world;
        }
        AxisAlignedBB aabb = ProgWidgetAreaItemBase.getExtents(area);
        return new ChunkCache(world, new BlockPos(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c), new BlockPos(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f));
    }

    public static AxisAlignedBB getExtents(Collection<BlockPos> areaSet) {
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxY = Integer.MIN_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (BlockPos pos : areaSet) {
            minX = Math.min(minX, pos.func_177958_n());
            maxX = Math.max(maxX, pos.func_177958_n());
            minY = Math.min(minY, pos.func_177956_o());
            maxY = Math.max(maxY, pos.func_177956_o());
            minZ = Math.min(minZ, pos.func_177952_p());
            maxZ = Math.max(maxZ, pos.func_177952_p());
        }
        return new AxisAlignedBB(new BlockPos(minX, minY, minZ), new BlockPos(maxX, maxY, maxZ));
    }

    public List<BlockPos> getCachedAreaList() {
        if (this.areaListCache != null) {
            if (!this.canCache || this.updateVariables()) {
                this.areaSetCache = new HashSet<BlockPos>(this.areaListCache.size());
                this.getArea(this.areaSetCache);
                this.areaListCache = new ArrayList<BlockPos>(this.areaSetCache.size());
                this.areaListCache.addAll(this.areaSetCache);
            }
        } else {
            this.areaSetCache = new HashSet<BlockPos>();
            this.getArea(this.areaSetCache);
            this.areaListCache = new ArrayList<BlockPos>(this.areaSetCache.size());
            this.areaListCache.addAll(this.areaSetCache);
            this.initializeVariableCache();
        }
        return this.areaListCache;
    }

    public Set<BlockPos> getCachedAreaSet() {
        this.getCachedAreaList();
        return this.areaSetCache;
    }

    protected synchronized void invalidateAreaCache() {
        this.areaListCache = null;
        this.areaSetCache = null;
    }

    private void initializeVariableCache() {
        this.areaVariableStates = new HashMap<String, BlockPos>();
        ProgWidgetArea whitelistWidget = (ProgWidgetArea)this.getConnectedParameters()[0];
        ProgWidgetArea blacklistWidget = (ProgWidgetArea)this.getConnectedParameters()[this.getParameters().size()];
        if (whitelistWidget == null) {
            return;
        }
        ProgWidgetArea widget = whitelistWidget;
        while (widget != null) {
            if (!widget.type.isDeterministic()) {
                this.canCache = false;
            }
            if (this.aiManager != null) {
                if (!widget.getCoord1Variable().equals("")) {
                    this.areaVariableStates.put(widget.getCoord1Variable(), this.aiManager.getCoordinate(widget.getCoord1Variable()));
                }
                if (!widget.getCoord2Variable().equals("")) {
                    this.areaVariableStates.put(widget.getCoord2Variable(), this.aiManager.getCoordinate(widget.getCoord2Variable()));
                }
            }
            widget = (ProgWidgetArea)widget.getConnectedParameters()[0];
        }
        widget = blacklistWidget;
        while (widget != null) {
            if (!widget.type.isDeterministic()) {
                this.canCache = false;
            }
            if (this.aiManager != null) {
                if (!widget.getCoord1Variable().equals("")) {
                    this.areaVariableStates.put(widget.getCoord1Variable(), this.aiManager.getCoordinate(widget.getCoord1Variable()));
                }
                if (!widget.getCoord2Variable().equals("")) {
                    this.areaVariableStates.put(widget.getCoord2Variable(), this.aiManager.getCoordinate(widget.getCoord2Variable()));
                }
            }
            widget = (ProgWidgetArea)widget.getConnectedParameters()[0];
        }
    }

    private boolean updateVariables() {
        boolean varChanged = false;
        for (Map.Entry<String, BlockPos> entry : this.areaVariableStates.entrySet()) {
            BlockPos newValue = this.aiManager.getCoordinate(entry.getKey());
            if (newValue.equals((Object)entry.getValue())) continue;
            varChanged = true;
            entry.setValue(newValue);
        }
        return varChanged;
    }

    @Override
    public void getArea(Set<BlockPos> area) {
        ProgWidgetAreaItemBase.getArea(area, (ProgWidgetArea)this.getConnectedParameters()[0], (ProgWidgetArea)this.getConnectedParameters()[this.getParameters().size()]);
    }

    public static void getArea(Set<BlockPos> area, ProgWidgetArea whitelistWidget, ProgWidgetArea blacklistWidget) {
        if (whitelistWidget == null) {
            return;
        }
        ProgWidgetArea widget = whitelistWidget;
        while (widget != null) {
            widget.getArea(area);
            widget = (ProgWidgetArea)widget.getConnectedParameters()[0];
        }
        widget = blacklistWidget;
        HashSet<BlockPos> blacklistedArea = new HashSet<BlockPos>();
        while (widget != null) {
            widget.getArea(blacklistedArea);
            widget = (ProgWidgetArea)widget.getConnectedParameters()[0];
        }
        area.removeAll(blacklistedArea);
    }

    @Override
    public boolean isItemValidForFilters(ItemStack item) {
        return this.isItemValidForFilters(item, null);
    }

    public boolean isItemValidForFilters(ItemStack item, BlockState blockState) {
        return ProgWidgetItemFilter.isItemValidForFilters(item, ProgWidget.getConnectedWidgetList(this, 1, ModProgWidgets.ITEM_FILTER), ProgWidget.getConnectedWidgetList(this, this.getParameters().size() + 1, ModProgWidgets.ITEM_FILTER), blockState);
    }

    public boolean isItemFilterEmpty() {
        return this.getConnectedParameters()[1] == null && this.getConnectedParameters()[3] == null;
    }

    public List<Entity> getEntitiesInArea(World world, Predicate<? super Entity> filter) {
        return ProgWidgetAreaItemBase.getEntitiesInArea((ProgWidgetArea)this.getConnectedParameters()[0], (ProgWidgetArea)this.getConnectedParameters()[this.getParameters().size()], world, filter, null);
    }

    @Override
    public List<Entity> getValidEntities(World world) {
        if (this.entityFilters == null) {
            this.entityFilters = new EntityFilterPair<ProgWidgetAreaItemBase>(this);
        }
        return this.entityFilters.getValidEntities(world);
    }

    @Override
    public boolean isEntityValid(Entity entity) {
        if (this.entityFilters == null) {
            this.entityFilters = new EntityFilterPair<ProgWidgetAreaItemBase>(this);
        }
        return this.entityFilters.isEntityValid(entity);
    }

    public static List<Entity> getEntitiesInArea(ProgWidgetArea whitelistWidget, ProgWidgetArea blacklistWidget, World world, Predicate<? super Entity> whitelistPredicate, Predicate<? super Entity> blacklistPredicate) {
        if (whitelistWidget == null) {
            return new ArrayList<Entity>();
        }
        HashSet<Object> entities = new HashSet<Object>();
        ProgWidgetArea widget = whitelistWidget;
        if (whitelistPredicate == null) {
            whitelistPredicate = e -> true;
        }
        while (widget != null) {
            entities.addAll(widget.getEntitiesWithinArea(world, whitelistPredicate));
            widget = (ProgWidgetArea)widget.getConnectedParameters()[0];
        }
        widget = blacklistWidget;
        while (widget != null) {
            entities.removeAll(widget.getEntitiesWithinArea(world, whitelistPredicate));
            widget = (ProgWidgetArea)widget.getConnectedParameters()[0];
        }
        if (blacklistPredicate != null) {
            entities.removeIf(blacklistPredicate);
        }
        return new ArrayList<Entity>(entities);
    }

    @Override
    public IProgWidget.WidgetDifficulty getDifficulty() {
        return IProgWidget.WidgetDifficulty.EASY;
    }

    @Override
    public void setAIManager(DroneAIManager aiManager) {
        this.aiManager = aiManager;
    }

    @Override
    public void addVariables(Set<String> variables) {
    }
}

