/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.progwidgets;

import java.util.List;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.ai.DroneAIRightClickBlock;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.core.ModProgWidgets;
import me.desht.pneumaticcraft.common.progwidgets.IBlockRightClicker;
import me.desht.pneumaticcraft.common.progwidgets.IMaxActions;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ISidedWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetPlace;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class ProgWidgetBlockRightClick
extends ProgWidgetPlace
implements IBlockRightClicker,
ISidedWidget {
    private Direction clickSide = Direction.UP;
    private boolean sneaking;
    private IBlockRightClicker.RightClickType clickType = IBlockRightClicker.RightClickType.CLICK_ITEM;

    public ProgWidgetBlockRightClick() {
        super(ModProgWidgets.BLOCK_RIGHT_CLICK);
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_BLOCK_RIGHT_CLICK;
    }

    @Override
    public Goal getWidgetAI(IDroneBase drone, IProgWidget widget) {
        return this.setupMaxActions(new DroneAIRightClickBlock(drone, (ProgWidgetBlockRightClick)widget), (IMaxActions)((Object)widget));
    }

    @Override
    public boolean supportsMaxActions() {
        return false;
    }

    @Override
    public boolean isSneaking() {
        return this.sneaking;
    }

    public void setSneaking(boolean sneaking) {
        this.sneaking = sneaking;
    }

    @Override
    public IBlockRightClicker.RightClickType getClickType() {
        return this.clickType;
    }

    public void setClickType(IBlockRightClicker.RightClickType clickType) {
        this.clickType = clickType;
    }

    public Direction getClickSide() {
        return this.clickSide;
    }

    public void setClickSide(Direction clickSide) {
        this.clickSide = clickSide;
    }

    @Override
    public void getTooltip(List<ITextComponent> curTooltip) {
        super.getTooltip(curTooltip);
        curTooltip.add(new TranslationTextComponent("pneumaticcraft.gui.progWidget.blockRightClick.clickSide", new Object[0]).func_150258_a(": " + ClientUtils.translateDirection(this.clickSide)));
        if (this.sneaking) {
            curTooltip.add((ITextComponent)new TranslationTextComponent("pneumaticcraft.gui.progWidget.blockRightClick.sneaking", new Object[0]));
        }
        curTooltip.add(new TranslationTextComponent("pneumaticcraft.gui.progWidget.blockRightClick.operation", new Object[0]).func_150258_a(": ").func_150257_a((ITextComponent)new TranslationTextComponent(this.clickType.getTranslationKey(), new Object[0])));
    }

    @Override
    public void writeToNBT(CompoundNBT tag) {
        super.writeToNBT(tag);
        tag.func_74757_a("sneaking", this.sneaking);
        tag.func_74768_a("dir", this.clickSide.ordinal());
        tag.func_74778_a("clickType", this.clickType.toString());
    }

    @Override
    public void readFromNBT(CompoundNBT tag) {
        super.readFromNBT(tag);
        this.sneaking = tag.func_74767_n("sneaking");
        this.clickSide = Direction.func_82600_a((int)tag.func_74762_e("dir"));
        this.clickType = tag.func_74764_b("clickType") ? IBlockRightClicker.RightClickType.valueOf(tag.func_74779_i("clickType")) : IBlockRightClicker.RightClickType.CLICK_ITEM;
    }

    @Override
    public void writeToPacket(PacketBuffer buf) {
        super.writeToPacket(buf);
        buf.writeBoolean(this.sneaking);
        buf.writeByte(this.clickSide.ordinal());
        buf.writeByte(this.clickType.ordinal());
    }

    @Override
    public void readFromPacket(PacketBuffer buf) {
        super.readFromPacket(buf);
        this.sneaking = buf.readBoolean();
        this.clickSide = Direction.func_82600_a((int)buf.readByte());
        this.clickType = IBlockRightClicker.RightClickType.values()[buf.readByte()];
    }

    @Override
    public void setSides(boolean[] sides) {
        this.clickSide = ISidedWidget.getDirForSides(sides);
    }

    @Override
    public boolean[] getSides() {
        return ISidedWidget.getSidesFromDir(this.clickSide);
    }
}

