/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.progwidgets;

import com.google.common.collect.ImmutableList;
import java.util.List;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.core.ModProgWidgets;
import me.desht.pneumaticcraft.common.progwidgets.ICondition;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetConditionBase;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetCoordinateOperator;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class ProgWidgetCoordinateCondition
extends ProgWidgetConditionBase {
    public final boolean[] checkingAxis = new boolean[3];
    private ICondition.Operator operator = ICondition.Operator.GE;

    public ProgWidgetCoordinateCondition() {
        super(ModProgWidgets.CONDITION_COORDINATE);
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return ImmutableList.of(ModProgWidgets.COORDINATE, ModProgWidgets.COORDINATE, ModProgWidgets.TEXT);
    }

    @Override
    public IProgWidget.WidgetDifficulty getDifficulty() {
        return IProgWidget.WidgetDifficulty.ADVANCED;
    }

    @Override
    public void addErrors(List<ITextComponent> curInfo, List<IProgWidget> widgets) {
        super.addErrors(curInfo, widgets);
        if (!(this.checkingAxis[0] || this.checkingAxis[1] || this.checkingAxis[2])) {
            curInfo.add(PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.conditionCoordinate.error.noAxisSelected", new Object[0]));
        }
    }

    @Override
    public boolean evaluate(IDroneBase drone, IProgWidget widget) {
        BlockPos pos1 = ProgWidgetCoordinateOperator.calculateCoordinate(widget, 0, ProgWidgetCoordinateOperator.EnumOperator.PLUS_MINUS);
        BlockPos pos2 = ProgWidgetCoordinateOperator.calculateCoordinate(widget, 1, ProgWidgetCoordinateOperator.EnumOperator.PLUS_MINUS);
        if (this.checkingAxis[0] && !this.evaluate(pos1.func_177958_n(), pos2.func_177958_n())) {
            return false;
        }
        if (this.checkingAxis[1] && !this.evaluate(pos1.func_177956_o(), pos2.func_177956_o())) {
            return false;
        }
        return !this.checkingAxis[2] || this.evaluate(pos1.func_177952_p(), pos2.func_177952_p());
    }

    private boolean evaluate(int arg1, int arg2) {
        return this.operator.evaluate(arg1, arg2);
    }

    public ICondition.Operator getOperator() {
        return this.operator;
    }

    public void setOperator(ICondition.Operator operator) {
        this.operator = operator;
    }

    @Override
    public void writeToNBT(CompoundNBT tag) {
        super.writeToNBT(tag);
        tag.func_74757_a("checkX", this.checkingAxis[0]);
        tag.func_74757_a("checkY", this.checkingAxis[1]);
        tag.func_74757_a("checkZ", this.checkingAxis[2]);
        tag.func_74774_a("operator", (byte)this.operator.ordinal());
    }

    @Override
    public void readFromNBT(CompoundNBT tag) {
        super.readFromNBT(tag);
        this.checkingAxis[0] = tag.func_74767_n("checkX");
        this.checkingAxis[1] = tag.func_74767_n("checkY");
        this.checkingAxis[2] = tag.func_74767_n("checkZ");
        this.operator = ICondition.Operator.values()[tag.func_74771_c("operator")];
    }

    @Override
    public void writeToPacket(PacketBuffer buf) {
        super.writeToPacket(buf);
        buf.writeBoolean(this.checkingAxis[0]);
        buf.writeBoolean(this.checkingAxis[1]);
        buf.writeBoolean(this.checkingAxis[2]);
        buf.writeByte(this.operator.ordinal());
    }

    @Override
    public void readFromPacket(PacketBuffer buf) {
        super.readFromPacket(buf);
        this.checkingAxis[0] = buf.readBoolean();
        this.checkingAxis[1] = buf.readBoolean();
        this.checkingAxis[2] = buf.readBoolean();
        this.operator = ICondition.Operator.values()[buf.readByte()];
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_CONDITION_COORDINATE;
    }

    @Override
    public void getTooltip(List<ITextComponent> curTooltip) {
        super.getTooltip(curTooltip);
        curTooltip.add((ITextComponent)new StringTextComponent("Condition: \"" + this.getCondition() + "\""));
    }

    @Override
    public String getExtraStringInfo() {
        String condition = this.getCondition();
        return condition.length() > 0 ? condition : null;
    }

    public String getCondition() {
        char[] axis = new char[]{'x', 'y', 'z'};
        StringBuilder condition = new StringBuilder();
        for (int i = 0; i < 3; ++i) {
            if (!this.checkingAxis[i]) continue;
            if (condition.length() > 0) {
                condition.append(" and ");
            }
            condition.append(("%s1 " + (Object)((Object)this.operator) + " %s2").replace("%s", "" + axis[i]));
        }
        return condition.toString();
    }
}

