/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.progwidgets;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Set;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.ai.DroneAIManager;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.core.ModProgWidgets;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.IVariableSetWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetCoordinate;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class ProgWidgetCoordinateOperator
extends ProgWidget
implements IVariableSetWidget {
    private EnumOperator operator = EnumOperator.PLUS_MINUS;
    private String variable = "";
    private DroneAIManager aiManager;

    public ProgWidgetCoordinateOperator() {
        super(ModProgWidgets.COORDINATE_OPERATOR);
    }

    @Override
    public boolean hasStepInput() {
        return true;
    }

    @Override
    public ProgWidgetType<?> returnType() {
        return null;
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return ImmutableList.of(ModProgWidgets.COORDINATE);
    }

    @Override
    public DyeColor getColor() {
        return DyeColor.GRAY;
    }

    @Override
    public IProgWidget.WidgetDifficulty getDifficulty() {
        return IProgWidget.WidgetDifficulty.ADVANCED;
    }

    @Override
    public void addErrors(List<ITextComponent> curInfo, List<IProgWidget> widgets) {
        super.addErrors(curInfo, widgets);
        if (this.variable.equals("")) {
            curInfo.add(PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.general.error.emptyVariable", new Object[0]));
        }
        if (this.operator == EnumOperator.MAX_MIN) {
            if (this.getConnectedParameters()[0] == null && this.getConnectedParameters()[this.getParameters().size()] == null) {
                curInfo.add(PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.coordinateOperator.noParameter", new Object[0]));
            }
        } else if (this.operator == EnumOperator.MULIPLY_DIVIDE) {
            IProgWidget w = this.getConnectedParameters()[1];
            while (w instanceof ProgWidgetCoordinate) {
                BlockPos pos = ((ProgWidgetCoordinate)w).getCoordinate();
                if (pos.func_177958_n() == 0 || pos.func_177956_o() == 0 || pos.func_177952_p() == 0) {
                    curInfo.add(PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.coordinateOperator.divideByZero", new Object[0]));
                    break;
                }
                w = w.getConnectedParameters()[0];
            }
        }
    }

    @Override
    public IProgWidget getOutputWidget(IDroneBase drone, List<IProgWidget> allWidgets) {
        if (!this.variable.equals("")) {
            BlockPos curPos = ProgWidgetCoordinateOperator.calculateCoordinate(this, 0, this.operator);
            this.aiManager.setCoordinate(this.variable, curPos);
        }
        return super.getOutputWidget(drone, allWidgets);
    }

    public static BlockPos calculateCoordinate(IProgWidget widget, int argIndex, EnumOperator operator) {
        BlockPos curPos = null;
        switch (operator) {
            case MULIPLY_DIVIDE: {
                BlockPos pos;
                curPos = new BlockPos(1, 1, 1);
                ProgWidgetCoordinate coordinateWidget = (ProgWidgetCoordinate)widget.getConnectedParameters()[argIndex];
                while (coordinateWidget != null) {
                    pos = coordinateWidget.getCoordinate();
                    curPos = new BlockPos(curPos.func_177958_n() * pos.func_177958_n(), curPos.func_177956_o() * pos.func_177956_o(), curPos.func_177952_p() * pos.func_177952_p());
                    coordinateWidget = (ProgWidgetCoordinate)coordinateWidget.getConnectedParameters()[0];
                }
                coordinateWidget = (ProgWidgetCoordinate)widget.getConnectedParameters()[widget.getParameters().size() + argIndex];
                while (coordinateWidget != null) {
                    pos = coordinateWidget.getCoordinate();
                    if (pos.func_177958_n() != 0 && pos.func_177956_o() != 0 && pos.func_177952_p() != 0) {
                        curPos = new BlockPos(curPos.func_177958_n() / pos.func_177958_n(), curPos.func_177956_o() / pos.func_177956_o(), curPos.func_177952_p() / pos.func_177952_p());
                    }
                    coordinateWidget = (ProgWidgetCoordinate)coordinateWidget.getConnectedParameters()[0];
                }
                break;
            }
            case PLUS_MINUS: {
                BlockPos pos;
                curPos = BlockPos.field_177992_a;
                ProgWidgetCoordinate coordinateWidget = (ProgWidgetCoordinate)widget.getConnectedParameters()[argIndex];
                while (coordinateWidget != null) {
                    pos = coordinateWidget.getCoordinate();
                    curPos = new BlockPos(curPos.func_177958_n() + pos.func_177958_n(), curPos.func_177956_o() + pos.func_177956_o(), curPos.func_177952_p() + pos.func_177952_p());
                    coordinateWidget = (ProgWidgetCoordinate)coordinateWidget.getConnectedParameters()[0];
                }
                coordinateWidget = (ProgWidgetCoordinate)widget.getConnectedParameters()[widget.getParameters().size() + argIndex];
                while (coordinateWidget != null) {
                    pos = coordinateWidget.getCoordinate();
                    curPos = new BlockPos(curPos.func_177958_n() - pos.func_177958_n(), curPos.func_177956_o() - pos.func_177956_o(), curPos.func_177952_p() - pos.func_177952_p());
                    coordinateWidget = (ProgWidgetCoordinate)coordinateWidget.getConnectedParameters()[0];
                }
                break;
            }
            case MAX_MIN: {
                BlockPos pos;
                curPos = new BlockPos(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
                ProgWidgetCoordinate coordinateWidget = (ProgWidgetCoordinate)widget.getConnectedParameters()[argIndex];
                while (coordinateWidget != null) {
                    pos = coordinateWidget.getCoordinate();
                    curPos = new BlockPos(Math.max(curPos.func_177958_n(), pos.func_177958_n()), Math.max(curPos.func_177956_o(), pos.func_177956_o()), Math.max(curPos.func_177952_p(), pos.func_177952_p()));
                    coordinateWidget = (ProgWidgetCoordinate)coordinateWidget.getConnectedParameters()[0];
                }
                if (curPos.equals((Object)new BlockPos(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE))) {
                    curPos = new BlockPos(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
                }
                coordinateWidget = (ProgWidgetCoordinate)widget.getConnectedParameters()[widget.getParameters().size() + argIndex];
                while (coordinateWidget != null) {
                    pos = coordinateWidget.getCoordinate();
                    curPos = new BlockPos(Math.min(curPos.func_177958_n(), pos.func_177958_n()), Math.min(curPos.func_177956_o(), pos.func_177956_o()), Math.min(curPos.func_177952_p(), pos.func_177952_p()));
                    coordinateWidget = (ProgWidgetCoordinate)coordinateWidget.getConnectedParameters()[0];
                }
                break;
            }
        }
        return curPos;
    }

    @Override
    public ResourceLocation getTexture() {
        return this.operator.texture;
    }

    @Override
    public void writeToNBT(CompoundNBT tag) {
        super.writeToNBT(tag);
        tag.func_74778_a("variable", this.variable);
        tag.func_74774_a("operator", (byte)this.operator.ordinal());
    }

    @Override
    public void readFromNBT(CompoundNBT tag) {
        super.readFromNBT(tag);
        this.variable = tag.func_74779_i("variable");
        byte operatorValue = tag.func_74764_b("multiplyDivide") ? tag.func_74771_c("multiplyDivide") : tag.func_74771_c("operator");
        this.operator = EnumOperator.values()[operatorValue];
    }

    @Override
    public void writeToPacket(PacketBuffer buf) {
        super.writeToPacket(buf);
        buf.func_180714_a(this.variable);
        buf.writeByte(this.operator.ordinal());
    }

    @Override
    public void readFromPacket(PacketBuffer buf) {
        super.readFromPacket(buf);
        this.variable = buf.func_150789_c(64);
        this.operator = EnumOperator.values()[buf.readByte()];
    }

    public EnumOperator getOperator() {
        return this.operator;
    }

    public void setOperator(EnumOperator operator) {
        this.operator = operator;
    }

    @Override
    public String getVariable() {
        return this.variable;
    }

    @Override
    public void setVariable(String variable) {
        this.variable = variable;
    }

    @Override
    public void setAIManager(DroneAIManager aiManager) {
        this.aiManager = aiManager;
    }

    @Override
    public void getTooltip(List<ITextComponent> curTooltip) {
        super.getTooltip(curTooltip);
        curTooltip.add((ITextComponent)new StringTextComponent("Setting variable: \"" + this.variable + "\""));
    }

    @Override
    public String getExtraStringInfo() {
        return "\"" + this.variable + "\"";
    }

    @Override
    public void addVariables(Set<String> variables) {
        variables.add(this.variable);
    }

    public static enum EnumOperator {
        PLUS_MINUS("plus_minus"),
        MULIPLY_DIVIDE("multiply_divide"),
        MAX_MIN("max_min");

        public final ResourceLocation texture;
        private final String name;

        private EnumOperator(String name) {
            this.name = name;
            this.texture = Textures.progWidgetTexture("coordinate_operation_" + name + ".png");
        }

        public String getTranslationKey() {
            return "pneumaticcraft.gui.progWidget.coordinateOperator." + this.name;
        }
    }
}

