/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.progwidgets;

import java.util.List;
import me.desht.pneumaticcraft.common.ai.DroneAIDropItem;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.core.ModProgWidgets;
import me.desht.pneumaticcraft.common.progwidgets.IItemDropper;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetInventoryBase;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class ProgWidgetDropItem
extends ProgWidgetInventoryBase
implements IItemDropper {
    private boolean dropStraight;
    private boolean pickupDelay = true;

    public ProgWidgetDropItem() {
        super(ModProgWidgets.DROP_ITEM);
    }

    @Override
    public DyeColor getColor() {
        return DyeColor.MAGENTA;
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_DROP_ITEM;
    }

    @Override
    public boolean dropStraight() {
        return this.dropStraight;
    }

    @Override
    public void setDropStraight(boolean dropStraight) {
        this.dropStraight = dropStraight;
    }

    @Override
    public boolean hasPickupDelay() {
        return this.pickupDelay;
    }

    @Override
    public void setPickupDelay(boolean pickupDelay) {
        this.pickupDelay = pickupDelay;
    }

    @Override
    public void writeToNBT(CompoundNBT tag) {
        super.writeToNBT(tag);
        tag.func_74757_a("dropStraight", this.dropStraight);
        tag.func_74757_a("pickupDelay", this.pickupDelay);
    }

    @Override
    public void readFromNBT(CompoundNBT tag) {
        super.readFromNBT(tag);
        this.dropStraight = tag.func_74767_n("dropStraight");
        this.pickupDelay = tag.func_74767_n("pickupDelay");
    }

    @Override
    public void writeToPacket(PacketBuffer buf) {
        super.writeToPacket(buf);
        buf.writeBoolean(this.dropStraight);
        buf.writeBoolean(this.pickupDelay);
    }

    @Override
    public void readFromPacket(PacketBuffer buf) {
        super.readFromPacket(buf);
        this.dropStraight = buf.readBoolean();
        this.pickupDelay = buf.readBoolean();
    }

    @Override
    public void getTooltip(List<ITextComponent> curTooltip) {
        super.getTooltip(curTooltip);
        if (this.pickupDelay) {
            curTooltip.add((ITextComponent)new TranslationTextComponent("pneumaticcraft.gui.progWidget.drop.hasPickupDelay", new Object[0]));
        } else {
            curTooltip.add((ITextComponent)new TranslationTextComponent("pneumaticcraft.gui.progWidget.drop.noPickupDelay", new Object[0]));
        }
    }

    @Override
    public Goal getWidgetAI(IDroneBase drone, IProgWidget widget) {
        return new DroneAIDropItem<ProgWidgetInventoryBase>(drone, (ProgWidgetInventoryBase)widget);
    }

    @Override
    protected boolean isUsingSides() {
        return false;
    }

    @Override
    public String getExtraStringInfo() {
        return I18n.func_135052_a((String)("pneumaticcraft.gui.progWidget.drop.dropMethod." + (this.dropStraight() ? "straight" : "random")), (Object[])new Object[0]);
    }
}

