/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.progwidgets;

import com.google.common.collect.ImmutableList;
import java.util.List;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.core.ModProgWidgets;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetConditionBase;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetItemFilter;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class ProgWidgetItemCondition
extends ProgWidgetConditionBase {
    public ProgWidgetItemCondition() {
        super(ModProgWidgets.CONDITION_ITEM);
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return ImmutableList.of(ModProgWidgets.ITEM_FILTER, ModProgWidgets.ITEM_FILTER, ModProgWidgets.TEXT);
    }

    @Override
    public void addErrors(List<ITextComponent> curInfo, List<IProgWidget> widgets) {
        super.addErrors(curInfo, widgets);
        if (this.getConnectedParameters()[0] == null && this.getConnectedParameters()[3] == null) {
            curInfo.add(PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.conditionItem.error.noCheckingItem", new Object[0]));
        }
        if (this.getConnectedParameters()[1] == null && this.getConnectedParameters()[4] == null) {
            curInfo.add(PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.conditionItem.error.noFilter", new Object[0]));
        }
    }

    @Override
    public boolean evaluate(IDroneBase drone, IProgWidget widget) {
        ProgWidgetItemFilter checkedFilter = (ProgWidgetItemFilter)widget.getConnectedParameters()[0];
        while (checkedFilter != null) {
            if (!ProgWidgetItemFilter.isItemValidForFilters(checkedFilter.getFilter(), ProgWidget.getConnectedWidgetList(this, 1, ModProgWidgets.ITEM_FILTER), ProgWidget.getConnectedWidgetList(this, this.getParameters().size() + 1, ModProgWidgets.ITEM_FILTER), null)) {
                return false;
            }
            checkedFilter = (ProgWidgetItemFilter)checkedFilter.getConnectedParameters()[0];
        }
        checkedFilter = (ProgWidgetItemFilter)widget.getConnectedParameters()[3];
        while (checkedFilter != null) {
            if (ProgWidgetItemFilter.isItemValidForFilters(checkedFilter.getFilter(), ProgWidget.getConnectedWidgetList(this, 1, ModProgWidgets.ITEM_FILTER), ProgWidget.getConnectedWidgetList(this, this.getParameters().size() + 1, ModProgWidgets.ITEM_FILTER), null)) {
                return false;
            }
            checkedFilter = (ProgWidgetItemFilter)checkedFilter.getConnectedParameters()[0];
        }
        return true;
    }

    @Override
    public IProgWidget.WidgetDifficulty getDifficulty() {
        return IProgWidget.WidgetDifficulty.ADVANCED;
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_CONDITION_ITEM;
    }
}

