/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.sensor.pollSensors;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.api.universal_sensor.IPollSensorSetting;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TwitchStreamerSensor
implements IPollSensorSetting {
    @Override
    public String getSensorPath() {
        return "World/Twitch";
    }

    @Override
    public Set<EnumUpgrade> getRequiredUpgrades() {
        return ImmutableSet.of((Object)((Object)EnumUpgrade.DISPENSER));
    }

    @Override
    public boolean needsTextBox() {
        return true;
    }

    @Override
    public void drawAdditionalInfo(FontRenderer fontRenderer) {
        fontRenderer.func_211126_b("Player Name", 70.0f, 48.0f, 0x404040);
    }

    @Override
    public int getPollFrequency(TileEntity te) {
        return 20;
    }

    @Override
    public int getRedstoneValue(World world, BlockPos pos, int sensorRange, String textBoxText) {
        return TwitchStream.isOnline(textBoxText) ? 15 : 0;
    }

    static class TwitchStream
    extends Thread {
        private static final Map<String, TwitchStream> trackedTwitchers = new HashMap<String, TwitchStream>();
        private final String channel;
        private boolean keptAlive = true;
        private URL url;
        private boolean online = false;

        private TwitchStream(String name) {
            this.channel = name;
            this.start();
        }

        @Override
        public void run() {
            try {
                while (this.keptAlive) {
                    this.keptAlive = false;
                    this.refresh();
                    Thread.sleep(5000L);
                }
                trackedTwitchers.remove(this);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        private void refresh() {
            try {
                this.url = new URL("https://api.twitch.tv/kraken/streams/" + this.channel);
                BufferedReader reader = new BufferedReader(new InputStreamReader(this.url.openStream()));
                JsonElement json = new JsonParser().parse((Reader)reader);
                JsonObject obj = json.getAsJsonObject();
                JsonElement streaming = obj.get("stream");
                this.online = !streaming.isJsonNull();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public URL getUrl() {
            return this.url;
        }

        static boolean isOnline(String name) {
            TwitchStream stream = trackedTwitchers.get(name);
            if (stream == null) {
                stream = new TwitchStream(name);
                trackedTwitchers.put(name, stream);
            }
            stream.keptAlive = true;
            return stream.online;
        }
    }
}

