/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.thirdparty.IThirdParty;
import me.desht.pneumaticcraft.common.thirdparty.ModNameCache;
import me.desht.pneumaticcraft.common.thirdparty.ModdedWrenchUtils;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

public class GenericIntegrationHandler
implements IThirdParty {
    @Override
    public void postInit() {
        this.registerXPFluids();
        ModdedWrenchUtils.getInstance().registerThirdPartyWrenches();
        ModNameCache.init();
    }

    private void registerXPFluids() {
        this.maybeRegisterXPFluid(new ResourceLocation("industrialforegoing", "essence"), 20);
    }

    private void maybeRegisterXPFluid(ResourceLocation fluidName, int xpRatio) {
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(fluidName);
        if (fluid != null && fluid != Fluids.field_204541_a) {
            PneumaticRegistry.getInstance().registerXPFluid(fluid, xpRatio);
            Log.info("Registered experience fluid '" + fluidName + "' with mB->XP ratio " + xpRatio, new Object[0]);
        } else if (ModList.get().isLoaded(fluidName.func_110624_b())) {
            Log.error("Attempted to register unknown experience fluid " + fluidName, new Object[0]);
        }
    }
}

