/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.immersiveengineering;

import blusunrize.immersiveengineering.api.Lib;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.entity.living.EntityDrone;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlaySound;
import me.desht.pneumaticcraft.common.network.PacketSpawnParticle;
import me.desht.pneumaticcraft.common.particle.AirParticleData;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ElectricAttackHandler {
    private static final Map<UUID, Long> sounds = new HashMap<UUID, Long>();

    @SubscribeEvent
    public static void onElectricalAttack(LivingHurtEvent event) {
        PlayerEntity player;
        CommonArmorHandler handler;
        if (!event.getSource().func_76355_l().equals(Lib.DMG_WireShock)) {
            return;
        }
        if (event.getEntityLiving() instanceof EntityDrone) {
            EntityDrone drone = (EntityDrone)event.getEntityLiving();
            float dmg = event.getAmount();
            int sec = drone.getUpgrades(EnumUpgrade.SECURITY);
            if (sec > 0) {
                ((IAirHandler)drone.getCapability(PNCCapabilities.AIR_HANDLER_CAPABILITY).orElseThrow(RuntimeException::new)).addAir((int)(-50.0f * dmg));
                event.setAmount(0.0f);
                double dy = Math.min((double)(dmg / 4.0f), 0.5);
                NetworkHandler.sendToAllAround(new PacketSpawnParticle(AirParticleData.DENSE, drone.func_226277_ct_(), drone.func_226278_cu_(), drone.func_226281_cx_(), 0.0, -dy, 0.0, (int)dmg, 0.0, 0.0, 0.0), drone.field_70170_p);
                ElectricAttackHandler.playLeakSound((Entity)drone);
            }
        } else if (event.getEntityLiving() instanceof PlayerEntity && (handler = CommonArmorHandler.getHandlerForPlayer(player = (PlayerEntity)event.getEntityLiving())).getUpgradeCount(EquipmentSlotType.CHEST, EnumUpgrade.SECURITY) > 0 && (double)handler.getArmorPressure(EquipmentSlotType.CHEST) > 0.1 && handler.isArmorReady(EquipmentSlotType.CHEST)) {
            handler.addAir(EquipmentSlotType.CHEST, (int)(-150.0f * event.getAmount()));
            float sx = player.func_70681_au().nextFloat() * 1.5f - 0.75f;
            float sz = player.func_70681_au().nextFloat() * 1.5f - 0.75f;
            double dy = Math.min((double)(event.getAmount() / 4.0f), 0.5);
            NetworkHandler.sendToAllAround(new PacketSpawnParticle(AirParticleData.DENSE, player.func_226277_ct_() + (double)sx, player.func_226278_cu_() + 1.0, player.func_226281_cx_() + (double)sz, sx / 4.0f, -dy, sz / 4.0f), player.field_70170_p);
            event.setAmount(0.0f);
            ElectricAttackHandler.playLeakSound((Entity)player);
        }
    }

    private static void playLeakSound(Entity e) {
        if (e.field_70170_p.func_82737_E() - sounds.getOrDefault(e.func_110124_au(), 0L) > 16L) {
            NetworkHandler.sendToAllAround(new PacketPlaySound((SoundEvent)ModSounds.LEAKING_GAS.get(), SoundCategory.PLAYERS, e.func_226277_ct_(), e.func_226278_cu_(), e.func_226281_cx_(), 0.5f, 0.7f, true), e.field_70170_p);
            sounds.put(e.func_110124_au(), e.field_70170_p.func_82737_E());
        }
    }
}

