/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.jei;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.desht.pneumaticcraft.api.crafting.recipe.ExplosionCraftingRecipe;
import me.desht.pneumaticcraft.common.thirdparty.jei.JEIPlugin;
import me.desht.pneumaticcraft.common.thirdparty.jei.ModCategoryUid;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;

public class JEIExplosionCraftingCategory
implements IRecipeCategory<ExplosionCraftingRecipe> {
    private final String localizedName = I18n.func_135052_a((String)"pneumaticcraft.gui.nei.title.explosionCrafting", (Object[])new Object[0]);
    private final IDrawable background = JEIPlugin.jeiHelpers.getGuiHelper().createDrawable(Textures.GUI_JEI_MISC_RECIPES, 0, 0, 82, 18);
    private final IDrawable icon = JEIPlugin.jeiHelpers.getGuiHelper().drawableBuilder(Textures.JEI_EXPLOSION, 0, 0, 16, 16).setTextureSize(16, 16).build();

    JEIExplosionCraftingCategory() {
    }

    public ResourceLocation getUid() {
        return ModCategoryUid.EXPLOSION_CRAFTING;
    }

    public Class<? extends ExplosionCraftingRecipe> getRecipeClass() {
        return ExplosionCraftingRecipe.class;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(ExplosionCraftingRecipe recipe, IIngredients ingredients) {
        ingredients.setInputIngredients(Collections.singletonList(recipe.getInput()));
        ingredients.setOutputs(VanillaTypes.ITEM, recipe.getOutputs());
    }

    public void setRecipe(IRecipeLayout recipeLayout, ExplosionCraftingRecipe recipe, IIngredients ingredients) {
        recipeLayout.getItemStacks().init(0, true, 0, 0);
        recipeLayout.getItemStacks().set(0, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        recipeLayout.getItemStacks().init(1, false, 64, 0);
        recipeLayout.getItemStacks().set(1, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
    }

    public void draw(ExplosionCraftingRecipe recipe, double mouseX, double mouseY) {
        this.icon.draw(30, 0);
    }

    public List<String> getTooltipStrings(ExplosionCraftingRecipe recipe, double mouseX, double mouseY) {
        ArrayList<String> res = new ArrayList<String>();
        if (mouseX >= 23.0 && mouseX <= 60.0) {
            res.addAll(PneumaticCraftUtils.splitString(I18n.func_135052_a((String)"pneumaticcraft.gui.nei.recipe.explosionCrafting", (Object[])new Object[]{recipe.getLossRate()}), 32));
        }
        return res;
    }
}

