/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.jei;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.desht.pneumaticcraft.api.crafting.TemperatureRange;
import me.desht.pneumaticcraft.api.crafting.recipe.RefineryRecipe;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTemperature;
import me.desht.pneumaticcraft.common.block.BlockRefineryController;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.heat.HeatUtil;
import me.desht.pneumaticcraft.common.thirdparty.jei.Helpers;
import me.desht.pneumaticcraft.common.thirdparty.jei.JEIPlugin;
import me.desht.pneumaticcraft.common.thirdparty.jei.ModCategoryUid;
import me.desht.pneumaticcraft.lib.Textures;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class JEIRefineryCategory
implements IRecipeCategory<RefineryRecipe> {
    private final String localizedName;
    private final IDrawable background;
    private final IDrawable icon;
    private final ITickTimer tickTimer;
    private final Map<ResourceLocation, WidgetTemperature> tempWidgets = new HashMap<ResourceLocation, WidgetTemperature>();

    JEIRefineryCategory() {
        this.icon = JEIPlugin.jeiHelpers.getGuiHelper().createDrawableIngredient((Object)new ItemStack((IItemProvider)ModBlocks.REFINERY.get()));
        this.background = JEIPlugin.jeiHelpers.getGuiHelper().createDrawable(Textures.GUI_REFINERY, 6, 15, 166, 79);
        this.localizedName = I18n.func_135052_a((String)((BlockRefineryController)ModBlocks.REFINERY.get()).func_149739_a(), (Object[])new Object[0]);
        this.tickTimer = JEIPlugin.jeiHelpers.getGuiHelper().createTickTimer(60, 60, false);
    }

    public ResourceLocation getUid() {
        return ModCategoryUid.REFINERY;
    }

    public Class<? extends RefineryRecipe> getRecipeClass() {
        return RefineryRecipe.class;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(RefineryRecipe recipe, IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.FLUID, Collections.singletonList(recipe.getInput().getFluidStacks()));
        ingredients.setOutputs(VanillaTypes.FLUID, recipe.getOutputs());
    }

    public void setRecipe(IRecipeLayout recipeLayout, RefineryRecipe recipe, IIngredients ingredients) {
        FluidStack in = (FluidStack)((List)ingredients.getInputs(VanillaTypes.FLUID).get(0)).get(0);
        recipeLayout.getFluidStacks().init(0, true, 2, 10, 16, 64, in.getAmount(), true, Helpers.makeTankOverlay(64));
        recipeLayout.getFluidStacks().set(0, (List)ingredients.getInputs(VanillaTypes.FLUID).get(0));
        int n = 1;
        for (List out : ingredients.getOutputs(VanillaTypes.FLUID)) {
            int h = ((FluidStack)out.get(0)).getAmount() * 64 / in.getAmount();
            int yOff = 64 - h;
            recipeLayout.getFluidStacks().init(n, false, 69 + n * 20, 18 - n * 4 + yOff, 16, h, ((FluidStack)out.get(0)).getAmount(), true, Helpers.makeTankOverlay(h));
            recipeLayout.getFluidStacks().set(n, out);
            ++n;
        }
    }

    public void draw(RefineryRecipe recipe, double mouseX, double mouseY) {
        WidgetTemperature w = this.tempWidgets.computeIfAbsent(recipe.func_199560_c(), id -> WidgetTemperature.fromOperatingRange(26, 18, recipe.getOperatingTemp()));
        w.setTemperature(w.getTotalRange().getMin() + (w.getTotalRange().getMax() - w.getTotalRange().getMin()) * this.tickTimer.getValue() / this.tickTimer.getMaxValue());
        w.renderButton((int)mouseX, (int)mouseY, 0.0f);
    }

    public List<String> getTooltipStrings(RefineryRecipe recipe, double mouseX, double mouseY) {
        WidgetTemperature w = this.tempWidgets.get(recipe.func_199560_c());
        if (w != null && w.isMouseOver(mouseX, mouseY)) {
            return ImmutableList.of((Object)HeatUtil.formatHeatString(recipe.getOperatingTemp().asString(TemperatureRange.TemperatureScale.CELSIUS)).func_150254_d());
        }
        return Collections.emptyList();
    }
}

