/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.patchouli;

import me.desht.pneumaticcraft.api.crafting.recipe.AssemblyRecipe;
import me.desht.pneumaticcraft.common.item.ItemAssemblyProgram;
import me.desht.pneumaticcraft.common.recipes.PneumaticCraftRecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariableProvider;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.common.util.ItemStackUtil;

public class ProcessorAssemblySystem
implements IComponentProcessor {
    private AssemblyRecipe recipe = null;

    public void setup(IVariableProvider<String> iVariableProvider) {
        ItemStack result = PatchouliAPI.instance.deserializeItemStack((String)iVariableProvider.get("item"));
        this.recipe = this.findRecipe(result);
    }

    public String process(String key) {
        if (this.recipe == null) {
            return null;
        }
        ItemStack programStack = new ItemStack((IItemProvider)ItemAssemblyProgram.fromProgramType(this.recipe.getProgramType()));
        switch (key) {
            case "input": {
                return ItemStackUtil.serializeIngredient((Ingredient)this.recipe.getInput());
            }
            case "output": {
                return ItemStackUtil.serializeStack((ItemStack)this.recipe.getOutput());
            }
            case "program": {
                return ItemStackUtil.serializeStack((ItemStack)programStack);
            }
            case "name": {
                return this.recipe.getOutput().func_200301_q().func_150254_d();
            }
            case "desc": {
                return I18n.func_135052_a((String)"pneumaticcraft.patchouli.processor.assembly.desc", (Object[])new Object[]{this.recipe.getOutput().func_200301_q().func_150254_d(), programStack.func_200301_q().func_150254_d()});
            }
        }
        return null;
    }

    private AssemblyRecipe findRecipe(ItemStack result) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        for (AssemblyRecipe recipe : PneumaticCraftRecipeType.ASSEMBLY_DRILL.getRecipes((World)world).values()) {
            if (!ItemStack.func_179545_c((ItemStack)recipe.getOutput(), (ItemStack)result)) continue;
            return recipe;
        }
        for (AssemblyRecipe recipe : PneumaticCraftRecipeType.ASSEMBLY_LASER.getRecipes((World)world).values()) {
            if (!ItemStack.func_179545_c((ItemStack)recipe.getOutput(), (ItemStack)result)) continue;
            return recipe;
        }
        for (AssemblyRecipe recipe : PneumaticCraftRecipeType.ASSEMBLY_DRILL_LASER.getRecipes((World)world).values()) {
            if (!ItemStack.func_179545_c((ItemStack)recipe.getOutput(), (ItemStack)result)) continue;
            return recipe;
        }
        return null;
    }
}

