/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.theoneprobe;

import java.util.ArrayList;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.ILayoutStyle;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.semiblock.ISemiBlock;
import me.desht.pneumaticcraft.common.block.BlockPressureTube;
import me.desht.pneumaticcraft.common.block.tubes.TubeModule;
import me.desht.pneumaticcraft.common.capabilities.MachineAirHandler;
import me.desht.pneumaticcraft.common.config.PNCConfig;
import me.desht.pneumaticcraft.common.heat.HeatUtil;
import me.desht.pneumaticcraft.common.heat.TemperatureData;
import me.desht.pneumaticcraft.common.item.ItemCamoApplicator;
import me.desht.pneumaticcraft.common.thirdparty.theoneprobe.ElementPressure;
import me.desht.pneumaticcraft.common.thirdparty.waila.IInfoForwarder;
import me.desht.pneumaticcraft.common.tileentity.ICamouflageableTE;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControl;
import me.desht.pneumaticcraft.common.tileentity.TileEntityBase;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPressureTube;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TOPInfoProvider {
    private static final TextFormatting COLOR = TextFormatting.GRAY;

    public static void handle(ProbeMode mode, IProbeInfo probeInfo, PlayerEntity player, World world, BlockState blockState, IProbeHitData data) {
        TileEntity te = world.func_175625_s(data.getPos());
        if (te == null) {
            return;
        }
        if (te instanceof IInfoForwarder && (te = ((IInfoForwarder)te).getInfoTileEntity()) == null) {
            return;
        }
        if (te.getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY).isPresent()) {
            TOPInfoProvider.handlePneumatic(mode, probeInfo, te);
        }
        if (te.getCapability(PNCCapabilities.HEAT_EXCHANGER_CAPABILITY).isPresent()) {
            TOPInfoProvider.handleHeat(mode, probeInfo, te);
        }
        if (PNCConfig.Client.topShowsFluids) {
            te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, data.getSideHit()).ifPresent(handler -> TOPInfoProvider.handleFluidTanks(mode, probeInfo, handler));
        }
        if (te instanceof TileEntityBase) {
            TOPInfoProvider.handleRedstoneMode(mode, probeInfo, (TileEntityBase)te);
        }
        if (te instanceof TileEntityPressureTube) {
            TOPInfoProvider.handlePressureTube(mode, probeInfo, (TileEntityPressureTube)te, data.getSideHit(), player);
        }
        if (te instanceof ICamouflageableTE) {
            TOPInfoProvider.handleCamo(mode, probeInfo, ((ICamouflageableTE)te).getCamouflage());
        }
    }

    private static void handlePneumatic(ProbeMode mode, IProbeInfo probeInfo, TileEntity pneumaticMachine) {
        pneumaticMachine.getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY).ifPresent(airHandler -> {
            if (airHandler instanceof MachineAirHandler) {
                MachineAirHandler airHandler1 = (MachineAirHandler)airHandler;
                probeInfo.text(COLOR + "Max Pressure: " + TextFormatting.WHITE + PneumaticCraftUtils.roundNumberTo(airHandler1.getDangerPressure(), 1) + " bar");
                if (mode == ProbeMode.EXTENDED) {
                    probeInfo.text(COLOR + "Pressure:");
                    probeInfo.horizontal().element((IElement)new ElementPressure(pneumaticMachine, airHandler1)).vertical().text("").text("  \u2b05 " + PneumaticCraftUtils.roundNumberTo(airHandler.getPressure(), 2) + " bar");
                } else {
                    probeInfo.text(COLOR + "Pressure: " + TextFormatting.WHITE + PneumaticCraftUtils.roundNumberTo(airHandler.getPressure(), 2) + " bar");
                }
            }
        });
    }

    private static void handleHeat(ProbeMode mode, IProbeInfo probeInfo, TileEntity heatExchanger) {
        TemperatureData tempData = new TemperatureData((ICapabilityProvider)heatExchanger);
        if (tempData.isMultisided()) {
            for (Direction face : Direction.field_199792_n) {
                if (!tempData.hasData(face)) continue;
                probeInfo.text(HeatUtil.formatHeatString(face, (int)tempData.getTemperature(face)).func_150254_d());
            }
        } else if (tempData.hasData(null)) {
            probeInfo.text(HeatUtil.formatHeatString((int)tempData.getTemperature(null)).func_150254_d());
        }
    }

    static void handleSemiblock(PlayerEntity player, ProbeMode mode, IProbeInfo probeInfo, ISemiBlock semiBlock) {
        IProbeInfo vert = probeInfo.vertical((ILayoutStyle)new Layout(semiBlock.getColor()));
        IProbeInfo horiz = vert.horizontal();
        NonNullList<ItemStack> drops = semiBlock.getDrops();
        if (!drops.isEmpty()) {
            ItemStack stack = (ItemStack)drops.get(0);
            horiz.item(stack);
            horiz.text(stack.func_200301_q().func_150254_d());
            ArrayList<ITextComponent> currenttip = new ArrayList<ITextComponent>();
            semiBlock.addTooltip(currenttip, player, stack.func_77978_p(), player.func_225608_bj_());
            currenttip.forEach(t -> vert.text(t.func_150254_d()));
        }
    }

    private static void handleRedstoneMode(ProbeMode mode, IProbeInfo probeInfo, TileEntityBase te) {
        if (te instanceof IRedstoneControl) {
            int redstoneMode = ((IRedstoneControl)((Object)te)).getRedstoneMode();
            probeInfo.text(COLOR + TOPInfoProvider.L(te.getRedstoneTabTitle()) + ": " + TextFormatting.RED + TOPInfoProvider.L(te.getRedstoneButtonText(redstoneMode)));
        }
    }

    private static void handlePressureTube(ProbeMode mode, IProbeInfo probeInfo, TileEntityPressureTube te, Direction face, PlayerEntity player) {
        TubeModule module = BlockPressureTube.getFocusedModule(te.func_145831_w(), te.func_174877_v(), player);
        if (module != null) {
            ArrayList<ITextComponent> currenttip = new ArrayList<ITextComponent>();
            module.addInfo(currenttip);
            if (!currenttip.isEmpty()) {
                IProbeInfo vert = probeInfo.vertical((ILayoutStyle)new Layout(-12566273));
                currenttip.stream().map(ITextComponent::func_150254_d).forEach(arg_0 -> ((IProbeInfo)vert).text(arg_0));
            }
        }
    }

    static void handleFluidTanks(ProbeMode mode, IProbeInfo probeInfo, IFluidHandler handler) {
        if (mode == ProbeMode.EXTENDED) {
            for (int i = 0; i < handler.getTanks(); ++i) {
                FluidStack fluidStack = handler.getFluidInTank(i);
                String fluidDesc = fluidStack.isEmpty() ? TOPInfoProvider.L("pneumaticcraft.gui.liquid.empty") : fluidStack.getAmount() + "mB " + TOPInfoProvider.L(fluidStack.getTranslationKey());
                probeInfo.text(COLOR + "Tank #" + (i + 1) + ": " + TextFormatting.AQUA + fluidDesc);
            }
        }
    }

    private static void handleCamo(ProbeMode mode, IProbeInfo probeInfo, BlockState camo) {
        if (camo != null) {
            probeInfo.text(TextFormatting.YELLOW + "[Camo: " + ItemCamoApplicator.getCamoStateDisplayName(camo).func_150254_d() + "]");
        }
    }

    private static String L(String s) {
        return "{*" + s + "*}";
    }

    private static class Layout
    implements ILayoutStyle {
        private int borderColor;

        Layout(int borderColor) {
            this.borderColor = borderColor;
        }

        public ILayoutStyle borderColor(Integer borderColor) {
            this.borderColor = borderColor;
            return this;
        }

        public ILayoutStyle spacing(int i) {
            return this;
        }

        public ILayoutStyle alignment(ElementAlignment elementAlignment) {
            return this;
        }

        public Integer getBorderColor() {
            return this.borderColor;
        }

        public int getSpacing() {
            return 3;
        }

        public ElementAlignment getAlignment() {
            return ElementAlignment.ALIGN_TOPLEFT;
        }
    }
}

