/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import java.util.Collections;
import java.util.List;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.common.block.BlockOmnidirectionalHopper;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.tileentity.IComparatorSupport;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControlled;
import me.desht.pneumaticcraft.common.tileentity.TileEntityTickableBase;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;

public abstract class TileEntityAbstractHopper
extends TileEntityTickableBase
implements IRedstoneControlled,
IComparatorSupport,
INamedContainerProvider {
    private int lastComparatorValue = -1;
    @GuiSynced
    public int redstoneMode;
    private int cooldown;
    @GuiSynced
    int leaveMaterialCount;
    @DescSynced
    public boolean isCreative;
    private boolean wasCreative = false;
    Direction inputDir = Direction.UP;
    AxisAlignedBB inputAABB;

    TileEntityAbstractHopper(TileEntityType type) {
        super(type, 4);
    }

    public Direction getInputDirection() {
        return (Direction)this.func_195044_w().func_177229_b(BlockOmnidirectionalHopper.INPUT_FACING);
    }

    @Override
    protected void onFirstServerTick() {
        super.onFirstServerTick();
        this.isCreative = this.getUpgrades(EnumUpgrade.CREATIVE) > 0;
        this.setupInputAABB();
    }

    private void setupInputAABB() {
        this.inputDir = this.getInputDirection();
        this.inputAABB = new AxisAlignedBB(this.field_174879_c).func_72317_d((double)this.inputDir.func_82601_c() * 0.625, (double)this.inputDir.func_96559_d() * 0.625, (double)this.inputDir.func_82599_e() * 0.625).func_72321_a((double)this.inputDir.func_82601_c() * 1.375, (double)this.inputDir.func_96559_d() * 1.375, (double)this.inputDir.func_82599_e() * 1.375);
    }

    @Override
    public void onBlockRotated() {
        super.onBlockRotated();
        this.setupInputAABB();
    }

    @Override
    public void func_73660_a() {
        this.inputDir = this.getInputDirection();
        super.func_73660_a();
        if (!this.func_145831_w().field_72995_K && --this.cooldown <= 0 && this.redstoneAllows()) {
            int maxItems = this.getMaxItems();
            boolean success = this.doImport(maxItems);
            int n = this.cooldown = (success |= this.doExport(maxItems)) ? this.getItemTransferInterval() : 8;
            if (this.lastComparatorValue != this.getComparatorValueInternal()) {
                this.lastComparatorValue = this.getComparatorValueInternal();
            }
        }
    }

    @Override
    protected boolean shouldRerenderChunkOnDescUpdate() {
        boolean rerender = this.wasCreative != this.isCreative;
        this.wasCreative = this.isCreative;
        return rerender;
    }

    public int getMaxItems() {
        int upgrades = this.getUpgrades(EnumUpgrade.SPEED);
        if (upgrades > 3) {
            return Math.min(1 << upgrades - 3, 256);
        }
        return 1;
    }

    public int getItemTransferInterval() {
        return 8 / (1 << this.getUpgrades(EnumUpgrade.SPEED));
    }

    protected abstract boolean doExport(int var1);

    protected abstract boolean doImport(int var1);

    protected abstract int getComparatorValueInternal();

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("redstoneMode", this.redstoneMode);
        tag.func_74768_a("leaveMaterialCount", this.leaveMaterialCount);
        return tag;
    }

    @Override
    public void func_145839_a(CompoundNBT tag) {
        super.func_145839_a(tag);
        this.redstoneMode = tag.func_74762_e("redstoneMode");
        this.leaveMaterialCount = tag.func_74764_b("leaveMaterial") ? (int)((byte)(tag.func_74767_n("leaveMaterial") ? 1 : 0)) : tag.func_74762_e("leaveMaterialCount");
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, PlayerEntity player) {
        switch (tag) {
            case "redstone": {
                ++this.redstoneMode;
                if (this.redstoneMode <= 2) break;
                this.redstoneMode = 0;
                break;
            }
            case "empty": {
                this.leaveMaterialCount = 0;
                break;
            }
            case "leave": {
                this.leaveMaterialCount = 1;
            }
        }
    }

    @Override
    public int getRedstoneMode() {
        return this.redstoneMode;
    }

    public boolean doesLeaveMaterial() {
        return this.leaveMaterialCount > 0;
    }

    @Override
    public int getComparatorValue() {
        return this.getComparatorValueInternal();
    }

    @Override
    public void onUpgradesChanged() {
        super.onUpgradesChanged();
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.isCreative = this.getUpgrades(EnumUpgrade.CREATIVE) > 0;
        }
    }

    @Override
    public boolean shouldPreserveStateOnBreak() {
        return true;
    }

    public ITextComponent func_145748_c_() {
        return this.getDisplayNameInternal();
    }

    List<ItemEntity> getNeighborItems(AxisAlignedBB aabb) {
        return aabb == null ? Collections.emptyList() : this.field_145850_b.func_175647_a(ItemEntity.class, aabb, EntityPredicates.field_94557_a);
    }
}

