/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.common.block.BlockAirCompressor;
import me.desht.pneumaticcraft.common.core.ModTileEntities;
import me.desht.pneumaticcraft.common.inventory.ContainerAirCompressor;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControlled;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticBase;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.items.IItemHandler;

public class TileEntityAirCompressor
extends TileEntityPneumaticBase
implements IRedstoneControlled,
INamedContainerProvider {
    private static final int INVENTORY_SIZE = 1;
    private final AirCompressorFuelHandler itemHandler = new AirCompressorFuelHandler();
    private final LazyOptional<IItemHandler> inventory = LazyOptional.of(() -> this.itemHandler);
    private static final int FUEL_SLOT = 0;
    @GuiSynced
    public int burnTime;
    @GuiSynced
    private int maxBurnTime;
    @GuiSynced
    public int redstoneMode = 0;
    @DescSynced
    private boolean isActive;
    @GuiSynced
    public int curFuelUsage;
    @GuiSynced
    public float airPerTick;
    private float airBuffer;

    public TileEntityAirCompressor() {
        this((TileEntityType)ModTileEntities.AIR_COMPRESSOR.get(), 5.0f, 7.0f, 5000);
    }

    TileEntityAirCompressor(TileEntityType type, float dangerPressure, float criticalPressure, int volume) {
        super(type, dangerPressure, criticalPressure, volume, 4);
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerAirCompressor(i, playerInventory, this.func_174877_v());
    }

    public ITextComponent func_145748_c_() {
        return this.getDisplayNameInternal();
    }

    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.func_145831_w().field_72995_K) {
            ItemStack fuelStack;
            int itemBurnTime;
            this.airPerTick = (float)this.getBaseProduction() * this.getSpeedMultiplierFromUpgrades() * (float)this.getHeatEfficiency() / 100.0f;
            if (this.redstoneAllows() && this.burnTime < this.curFuelUsage && (itemBurnTime = PneumaticCraftUtils.getBurnTime(fuelStack = this.itemHandler.getStackInSlot(0))) > 0) {
                this.burnTime += itemBurnTime;
                this.maxBurnTime = this.burnTime;
                fuelStack.func_190918_g(1);
            }
            this.curFuelUsage = (int)((float)this.getBaseProduction() * this.getSpeedUsageMultiplierFromUpgrades() / 10.0f);
            if (this.burnTime >= this.curFuelUsage) {
                this.burnTime -= this.curFuelUsage;
                if (!this.func_145831_w().field_72995_K) {
                    this.airBuffer += this.airPerTick;
                    if (this.airBuffer >= 1.0f) {
                        int toAdd = (int)this.airBuffer;
                        this.addAir(toAdd);
                        this.airBuffer -= (float)toAdd;
                        this.addHeatForAir(toAdd);
                    }
                }
            }
            boolean wasActive = this.isActive;
            boolean bl = this.isActive = this.burnTime > this.curFuelUsage;
            if (wasActive != this.isActive) {
                this.func_145831_w().func_175656_a(this.func_174877_v(), (BlockState)this.func_145831_w().func_180495_p(this.func_174877_v()).func_206870_a((IProperty)BlockAirCompressor.ON, (Comparable)Boolean.valueOf(this.isActive)));
            }
            this.airHandler.setSideLeaking(this.hasNoConnectedAirHandlers() ? this.getRotation() : null);
        } else if (this.isActive) {
            this.spawnBurningParticle();
        }
    }

    protected void addHeatForAir(int air) {
    }

    public int getHeatEfficiency() {
        return 100;
    }

    public int getBaseProduction() {
        return 10;
    }

    private void spawnBurningParticle() {
        if (this.func_145831_w().field_73012_v.nextInt(3) != 0) {
            return;
        }
        float px = (float)this.func_174877_v().func_177958_n() + 0.5f;
        float py = (float)this.func_174877_v().func_177956_o() + this.func_145831_w().field_73012_v.nextFloat() * 6.0f / 16.0f;
        float pz = (float)this.func_174877_v().func_177952_p() + 0.5f;
        float f3 = 0.5f;
        float f4 = this.func_145831_w().field_73012_v.nextFloat() * 0.4f - 0.2f;
        switch (this.getRotation()) {
            case EAST: {
                this.func_145831_w().func_195594_a((IParticleData)ParticleTypes.field_197601_L, (double)(px - f3), (double)py, (double)(pz + f4), 0.0, 0.0, 0.0);
                this.func_145831_w().func_195594_a((IParticleData)ParticleTypes.field_197631_x, (double)(px - f3), (double)py, (double)(pz + f4), 0.0, 0.0, 0.0);
                break;
            }
            case WEST: {
                this.func_145831_w().func_195594_a((IParticleData)ParticleTypes.field_197601_L, (double)(px + f3), (double)py, (double)(pz + f4), 0.0, 0.0, 0.0);
                this.func_145831_w().func_195594_a((IParticleData)ParticleTypes.field_197631_x, (double)(px + f3), (double)py, (double)(pz + f4), 0.0, 0.0, 0.0);
                break;
            }
            case SOUTH: {
                this.func_145831_w().func_195594_a((IParticleData)ParticleTypes.field_197601_L, (double)(px + f4), (double)py, (double)(pz - f3), 0.0, 0.0, 0.0);
                this.func_145831_w().func_195594_a((IParticleData)ParticleTypes.field_197631_x, (double)(px + f4), (double)py, (double)(pz - f3), 0.0, 0.0, 0.0);
                break;
            }
            case NORTH: {
                this.func_145831_w().func_195594_a((IParticleData)ParticleTypes.field_197601_L, (double)(px + f4), (double)py, (double)(pz + f3), 0.0, 0.0, 0.0);
                this.func_145831_w().func_195594_a((IParticleData)ParticleTypes.field_197631_x, (double)(px + f4), (double)py, (double)(pz + f3), 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public boolean canConnectPneumatic(Direction side) {
        return this.getRotation() == side;
    }

    public int getBurnTimeRemainingScaled(int parts) {
        if (this.maxBurnTime == 0 || this.burnTime < this.curFuelUsage) {
            return 0;
        }
        return parts * this.burnTime / this.maxBurnTime;
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, PlayerEntity player) {
        if (tag.equals("redstone")) {
            ++this.redstoneMode;
            if (this.redstoneMode > 2) {
                this.redstoneMode = 0;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)(this.func_174877_v().func_177958_n() + 1), (double)(this.func_174877_v().func_177956_o() + 1), (double)(this.func_174877_v().func_177952_p() + 1));
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return this.itemHandler;
    }

    @Override
    @Nonnull
    protected LazyOptional<IItemHandler> getInventoryCap() {
        return this.inventory;
    }

    @Override
    public void func_145839_a(CompoundNBT nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.burnTime = nbtTagCompound.func_74762_e("burnTime");
        this.maxBurnTime = nbtTagCompound.func_74762_e("maxBurn");
        this.redstoneMode = nbtTagCompound.func_74762_e("redstoneMode");
        this.itemHandler.deserializeNBT(nbtTagCompound.func_74775_l("Items"));
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbtTagCompound) {
        super.func_189515_b(nbtTagCompound);
        nbtTagCompound.func_74768_a("burnTime", this.burnTime);
        nbtTagCompound.func_74768_a("maxBurn", this.maxBurnTime);
        nbtTagCompound.func_74768_a("redstoneMode", this.redstoneMode);
        nbtTagCompound.func_218657_a("Items", (INBT)this.itemHandler.serializeNBT());
        return nbtTagCompound;
    }

    @Override
    public int getRedstoneMode() {
        return this.redstoneMode;
    }

    private class AirCompressorFuelHandler
    extends BaseItemStackHandler {
        AirCompressorFuelHandler() {
            super(TileEntityAirCompressor.this, 1);
        }

        public boolean isItemValid(int slot, ItemStack itemStack) {
            return slot == 0 && (itemStack.func_190926_b() || PneumaticCraftUtils.getBurnTime(itemStack) > 0 && !FluidUtil.getFluidContained((ItemStack)itemStack).isPresent());
        }
    }
}

