/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import java.util.Collection;
import me.desht.pneumaticcraft.api.crafting.recipe.AssemblyRecipe;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModTileEntities;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.LazySynced;
import me.desht.pneumaticcraft.common.recipes.assembly.AssemblyProgram;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAssemblyPlatform;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAssemblyRobot;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileEntityAssemblyIOUnit
extends TileEntityAssemblyRobot {
    @DescSynced
    private boolean shouldClawClose;
    @DescSynced
    @LazySynced
    public float clawProgress;
    public float oldClawProgress;
    @DescSynced
    private final BaseItemStackHandler itemHandler = new BaseItemStackHandler(this, 1);
    private Collection<AssemblyRecipe> recipeList;
    private ItemStack searchedItemStack = ItemStack.field_190927_a;
    private byte state = 0;
    private byte tickCounter = 0;
    private static final byte SLEEP_TICKS = 50;
    private static final byte STATE_IDLE = 0;
    private static final byte STATE_SEARCH_SRC = 1;
    private static final byte STATE_CLOSECLAW_AFTER_PICKUP = 5;
    private static final byte STATE_RESET_CLOSECLAW_AFTER_PICKUP = 20;
    private static final byte STATE_RESET_GOTO_IDLE = 26;
    private static final byte STATE_MAX = 127;

    public TileEntityAssemblyIOUnit() {
        super((TileEntityType)ModTileEntities.ASSEMBLY_IO_UNIT.get());
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.func_145831_w().field_72995_K) {
            if (!this.isClawDone()) {
                this.moveClaw();
            }
        } else {
            this.slowMode = false;
            switch (this.state) {
                case 0: {
                    break;
                }
                case 1: {
                    if (!this.findPickupLocation()) break;
                    this.state = (byte)(this.state + 1);
                    break;
                }
                case 2: 
                case 7: 
                case 22: {
                    if (!this.hoverOverTarget()) break;
                    this.state = (byte)(this.state + 1);
                    break;
                }
                case 3: 
                case 8: 
                case 23: {
                    this.slowMode = true;
                    if (!this.gotoTarget()) break;
                    this.state = (byte)(this.state + 1);
                    break;
                }
                case 4: {
                    if (!this.getItemFromCurrentDirection()) break;
                    this.state = (byte)(this.state + 1);
                    break;
                }
                case 5: 
                case 20: {
                    if (!this.closeClaw()) break;
                    this.state = (byte)(this.state + 1);
                    break;
                }
                case 6: 
                case 21: {
                    if (!this.findDropOffLocation()) break;
                    this.state = (byte)(this.state + 1);
                    break;
                }
                case 9: 
                case 24: {
                    if (!this.openClaw()) break;
                    this.state = (byte)(this.state + 1);
                    break;
                }
                case 10: 
                case 25: {
                    if (!this.putItemToCurrentDirection()) break;
                    this.state = (byte)(this.state + 1);
                    break;
                }
                case 11: 
                case 26: {
                    if (this.gotoIdlePos()) {
                        this.state = 0;
                    }
                }
                case 127: {
                    break;
                }
                default: {
                    System.out.printf("unexpected state: %d%n", this.state);
                    this.state = (byte)127;
                }
            }
        }
    }

    @Override
    public boolean reset() {
        if (this.state >= 20) {
            return false;
        }
        if (!this.itemHandler.getStackInSlot(0).func_190926_b()) {
            this.state = (byte)20;
            return false;
        }
        if (this.state == 0) {
            return true;
        }
        this.state = (byte)26;
        return this.isIdle();
    }

    public boolean pickupItem(Collection<AssemblyRecipe> list) {
        this.recipeList = list;
        if (this.state == 0) {
            this.state = (byte)(this.state + 1);
        }
        return this.state > 0 && !this.isSleeping() && this.state < 127;
    }

    private boolean gotoIdlePos() {
        this.gotoHomePosition();
        return this.isDoneMoving();
    }

    private boolean findPickupLocation() {
        if (this.shouldSleep()) {
            return false;
        }
        Direction[] inventoryDir = null;
        if (this.isImportUnit()) {
            this.searchedItemStack = ItemStack.field_190927_a;
            if (this.recipeList != null) {
                for (AssemblyRecipe recipe : this.recipeList) {
                    ItemImport result = this.getInventoryDirectionForItem(recipe);
                    if (result == null) continue;
                    this.searchedItemStack = result.stack;
                    inventoryDir = result.dirs;
                    break;
                }
            }
        } else {
            inventoryDir = this.getPlatformDirection();
        }
        this.targetDirection = inventoryDir;
        if (this.targetDirection == null) {
            this.sleepBeforeNextSearch();
            return false;
        }
        return true;
    }

    private boolean isSleeping() {
        return this.tickCounter > 0;
    }

    private boolean shouldSleep() {
        if (this.tickCounter > 0) {
            byte by = this.tickCounter;
            this.tickCounter = (byte)(by + 1);
            if (by < 50) {
                return true;
            }
        }
        this.tickCounter = 0;
        return false;
    }

    private void sleepBeforeNextSearch() {
        this.tickCounter = 1;
    }

    private boolean findDropOffLocation() {
        if (this.shouldSleep()) {
            return false;
        }
        Direction[] directionArray = this.targetDirection = this.isImportUnit() ? this.getPlatformDirection() : this.getExportLocationForItem(this.itemHandler.getStackInSlot(0));
        if (this.targetDirection == null) {
            this.sleepBeforeNextSearch();
            return false;
        }
        return true;
    }

    private boolean getItemFromCurrentDirection() {
        TileEntityAssemblyPlatform plat;
        TileEntity tile = this.getTileEntityForCurrentDirection();
        boolean extracted = false;
        if (this.isImportUnit()) {
            if (this.searchedItemStack.func_190926_b()) {
                this.reset();
            } else {
                extracted = (Boolean)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.UP).map(otherInv -> {
                    ItemStack currentStack = this.itemHandler.getStackInSlot(0);
                    int oldStackSize = currentStack.func_190916_E();
                    boolean ret = false;
                    for (int i = 0; i < otherInv.getSlots(); ++i) {
                        ItemStack exStack;
                        if (otherInv.getStackInSlot(i).func_190926_b()) continue;
                        if (currentStack.func_190926_b()) {
                            if (otherInv.getStackInSlot(i).func_77969_a(this.searchedItemStack)) {
                                exStack = otherInv.extractItem(i, 1, false);
                                this.itemHandler.insertItem(0, exStack, false);
                            }
                        } else if (ItemHandlerHelper.canItemStacksStack((ItemStack)currentStack, (ItemStack)otherInv.getStackInSlot(i))) {
                            exStack = otherInv.extractItem(i, 1, false);
                            this.itemHandler.insertItem(0, exStack, false);
                        }
                        boolean bl = ret = this.itemHandler.getStackInSlot(0).func_190916_E() >= this.searchedItemStack.func_190916_E();
                        if (ret) break;
                    }
                    if (oldStackSize == this.itemHandler.getStackInSlot(0).func_190916_E()) {
                        this.state = 1;
                    }
                    return ret;
                }).orElseGet(() -> {
                    this.state = 1;
                    return false;
                });
            }
        } else if (tile instanceof TileEntityAssemblyPlatform && (plat = (TileEntityAssemblyPlatform)tile).openClaw()) {
            this.itemHandler.setStackInSlot(0, plat.getHeldStack());
            plat.setHeldStack(ItemStack.field_190927_a);
            boolean bl = extracted = !this.itemHandler.getStackInSlot(0).func_190926_b();
            if (!extracted) {
                this.state = 1;
            }
        }
        return extracted;
    }

    private boolean putItemToCurrentDirection() {
        if (this.isImportUnit()) {
            TileEntity tile = this.getTileEntityForCurrentDirection();
            if (tile instanceof TileEntityAssemblyPlatform) {
                TileEntityAssemblyPlatform plat = (TileEntityAssemblyPlatform)tile;
                if (this.itemHandler.getStackInSlot(0).func_190926_b()) {
                    return plat.closeClaw();
                }
                if (plat.isIdle()) {
                    plat.setHeldStack(this.itemHandler.getStackInSlot(0));
                    this.itemHandler.setStackInSlot(0, ItemStack.field_190927_a);
                    return plat.closeClaw();
                }
            } else {
                this.repeatDropOffSearch();
            }
        } else {
            TileEntity te = this.getTileEntityForCurrentDirection();
            if (te == null) {
                this.repeatDropOffSearch();
            } else {
                ItemStack currentStack = this.itemHandler.getStackInSlot(0);
                int startSize = currentStack.func_190916_E();
                ItemStack excess = IOHelper.insert((ICapabilityProvider)te, currentStack, Direction.UP, false);
                this.itemHandler.setStackInSlot(0, excess);
                currentStack = this.itemHandler.getStackInSlot(0);
                if (!currentStack.func_190926_b() && startSize == currentStack.func_190916_E()) {
                    this.repeatDropOffSearch();
                }
            }
            return this.itemHandler.getStackInSlot(0).func_190926_b();
        }
        return false;
    }

    private void repeatDropOffSearch() {
        this.state = (byte)(this.state >= 20 ? 20 : 5);
    }

    private boolean closeClaw() {
        this.shouldClawClose = true;
        return this.moveClaw();
    }

    private boolean openClaw() {
        this.shouldClawClose = false;
        return this.moveClaw();
    }

    private boolean moveClaw() {
        this.oldClawProgress = this.clawProgress;
        if (!this.shouldClawClose && this.clawProgress > 0.0f) {
            this.clawProgress = Math.max(this.clawProgress - 0.05f * this.speed, 0.0f);
        } else if (this.shouldClawClose && this.clawProgress < 1.0f) {
            this.clawProgress = Math.min(this.clawProgress + 0.05f * this.speed, 1.0f);
        }
        this.func_70296_d();
        return this.isClawDone();
    }

    private boolean isClawDone() {
        return this.clawProgress == this.oldClawProgress && this.clawProgress == (this.shouldClawClose ? 1.0f : 0.0f);
    }

    public boolean isImportUnit() {
        return this.func_195044_w().func_177230_c() == ModBlocks.ASSEMBLY_IO_UNIT_IMPORT.get();
    }

    @Override
    public void gotoHomePosition() {
        super.gotoHomePosition();
        if (this.isClawDone()) {
            this.openClaw();
        }
    }

    @Override
    public boolean isIdle() {
        return this.state == 0;
    }

    @Override
    public AssemblyProgram.EnumMachine getAssemblyType() {
        return this.isImportUnit() ? AssemblyProgram.EnumMachine.IO_UNIT_IMPORT : AssemblyProgram.EnumMachine.IO_UNIT_EXPORT;
    }

    private ItemImport getInventoryDirectionForItem(AssemblyRecipe recipe) {
        ItemStack heldStack = this.itemHandler.getStackInSlot(0);
        if (heldStack.func_190926_b() || recipe.getInput().test(heldStack)) {
            for (Direction dir : PneumaticCraftUtils.HORIZONTALS) {
                ItemStack found = (ItemStack)IOHelper.getInventoryForTE(this.getCachedNeighbor(dir), Direction.UP).map(h -> this.findIngredientInInventory((IItemHandler)h, recipe)).orElse((Object)ItemStack.field_190927_a);
                if (found.func_190926_b()) continue;
                return new ItemImport(new Direction[]{dir, null}, found);
            }
            if (this.canMoveToDiagonalNeighbours()) {
                for (Direction secDir : new Direction[]{Direction.WEST, Direction.EAST}) {
                    for (Direction primDir : new Direction[]{Direction.NORTH, Direction.SOUTH}) {
                        TileEntity te = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(primDir).func_177972_a(secDir));
                        ItemStack found = (ItemStack)IOHelper.getInventoryForTE(te, Direction.UP).map(h -> this.findIngredientInInventory((IItemHandler)h, recipe)).orElse((Object)ItemStack.field_190927_a);
                        if (found.func_190926_b()) continue;
                        return new ItemImport(new Direction[]{primDir, secDir}, found);
                    }
                }
            }
        }
        return null;
    }

    private ItemStack findIngredientInInventory(IItemHandler handler, AssemblyRecipe recipe) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (stack.func_190916_E() < recipe.getInputAmount() || !recipe.getInput().test(stack)) continue;
            return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)recipe.getInputAmount());
        }
        return ItemStack.field_190927_a;
    }

    private Direction[] getExportLocationForItem(ItemStack exportedItem) {
        if (!exportedItem.func_190926_b()) {
            for (Direction dir : PneumaticCraftUtils.HORIZONTALS) {
                TileEntity te = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(dir));
                int slot = TileEntityAssemblyIOUnit.getPlacementSlot(exportedItem, te);
                if (slot < 0) continue;
                return new Direction[]{dir, null};
            }
            if (this.canMoveToDiagonalNeighbours()) {
                for (Direction secDir : new Direction[]{Direction.WEST, Direction.EAST}) {
                    for (Direction primDir : new Direction[]{Direction.NORTH, Direction.SOUTH}) {
                        TileEntity te = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(primDir).func_177972_a(secDir));
                        int slot = TileEntityAssemblyIOUnit.getPlacementSlot(exportedItem, te);
                        if (slot < 0) continue;
                        return new Direction[]{primDir, secDir};
                    }
                }
            }
        }
        return null;
    }

    private static int getPlacementSlot(ItemStack exportedItem, TileEntity te) {
        if (te == null || te instanceof TileEntityAssemblyRobot) {
            return -1;
        }
        return (Integer)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.UP).map(handler -> {
            for (int slot = 0; slot < handler.getSlots(); ++slot) {
                ItemStack excess = handler.insertItem(slot, exportedItem, true);
                if (excess.func_190916_E() >= exportedItem.func_190916_E()) continue;
                return slot;
            }
            return -1;
        }).orElse((Object)-1);
    }

    @Override
    public void func_145839_a(CompoundNBT tag) {
        super.func_145839_a(tag);
        this.clawProgress = tag.func_74760_g("clawProgress");
        this.shouldClawClose = tag.func_74767_n("clawClosing");
        this.state = tag.func_74771_c("state");
        this.itemHandler.deserializeNBT(tag.func_74775_l("Items"));
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return this.itemHandler;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_74776_a("clawProgress", this.clawProgress);
        tag.func_74757_a("clawClosing", this.shouldClawClose);
        tag.func_74774_a("state", this.state);
        tag.func_218657_a("Items", (INBT)this.itemHandler.serializeNBT());
        return tag;
    }

    @Override
    public boolean canMoveToDiagonalNeighbours() {
        return true;
    }

    private static class ItemImport {
        final Direction[] dirs;
        final ItemStack stack;

        ItemImport(Direction[] dirs, ItemStack stack) {
            this.dirs = dirs;
            this.stack = stack;
        }
    }
}

