/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.api.item.IUpgradeAcceptor;
import me.desht.pneumaticcraft.common.block.BlockPneumaticCraft;
import me.desht.pneumaticcraft.common.block.BlockPneumaticCraftCamo;
import me.desht.pneumaticcraft.common.config.PNCConfig;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.network.IDescSynced;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.NetworkUtils;
import me.desht.pneumaticcraft.common.network.PacketDescription;
import me.desht.pneumaticcraft.common.network.SyncedField;
import me.desht.pneumaticcraft.common.thirdparty.computer_common.LuaMethod;
import me.desht.pneumaticcraft.common.thirdparty.computer_common.LuaMethodRegistry;
import me.desht.pneumaticcraft.common.tileentity.IAutoFluidEjecting;
import me.desht.pneumaticcraft.common.tileentity.ICamouflageableTE;
import me.desht.pneumaticcraft.common.tileentity.IGUIButtonSensitive;
import me.desht.pneumaticcraft.common.tileentity.ILuaMethodProvider;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControl;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControlled;
import me.desht.pneumaticcraft.common.tileentity.ISerializableTanks;
import me.desht.pneumaticcraft.common.tileentity.ISideConfigurable;
import me.desht.pneumaticcraft.common.tileentity.SideConfigurator;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.TileEntityCache;
import me.desht.pneumaticcraft.common.util.upgrade.ApplicableUpgradesDB;
import me.desht.pneumaticcraft.common.util.upgrade.IUpgradeHolder;
import me.desht.pneumaticcraft.common.util.upgrade.UpgradeCache;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public abstract class TileEntityBase
extends TileEntity
implements IGUIButtonSensitive,
IDescSynced,
IUpgradeAcceptor,
IUpgradeHolder,
ILuaMethodProvider {
    private static final List<String> REDSTONE_LABELS = ImmutableList.of((Object)"pneumaticcraft.gui.tab.redstoneBehaviour.button.anySignal", (Object)"pneumaticcraft.gui.tab.redstoneBehaviour.button.highSignal", (Object)"pneumaticcraft.gui.tab.redstoneBehaviour.button.lowSignal");
    private final UpgradeCache upgradeCache = new UpgradeCache(this);
    @GuiSynced
    private final UpgradeHandler upgradeHandler;
    @GuiSynced
    int poweredRedstone;
    boolean firstRun = true;
    private boolean forceFullSync;
    private List<SyncedField<?>> descriptionFields;
    private TileEntityCache[] tileCache;
    private boolean preserveStateOnBreak = false;
    private float actualSpeedMult = 1.5f;
    private float actualUsageMult = 1.65f;
    private final LuaMethodRegistry luaMethodRegistry = new LuaMethodRegistry(this);
    private BitSet fieldsToSync;

    public TileEntityBase(TileEntityType type) {
        this(type, 0);
    }

    public TileEntityBase(TileEntityType type, int upgradeSize) {
        super(type);
        this.upgradeHandler = new UpgradeHandler(upgradeSize);
    }

    @Override
    public String getUpgradeAcceptorTranslationKey() {
        return this.getBlockTranslationKey();
    }

    public String getBlockTranslationKey() {
        return "block.pneumaticcraft." + this.func_200662_C().getRegistryName().func_110623_a();
    }

    ITextComponent getDisplayNameInternal() {
        return new TranslationTextComponent(this.getBlockTranslationKey(), new Object[0]);
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT compound = super.func_189517_E_();
        return new PacketDescription(this, true).writeNBT(compound);
    }

    public void handleUpdateTag(CompoundNBT tag) {
        new PacketDescription(tag).process();
    }

    @Override
    public BlockPos getPosition() {
        return this.func_174877_v();
    }

    @Override
    public boolean shouldSyncField(int idx) {
        return this.fieldsToSync.get(idx);
    }

    @Override
    public List<SyncedField<?>> getDescriptionFields() {
        if (this.descriptionFields == null) {
            this.descriptionFields = NetworkUtils.getSyncedFields(this, DescSynced.class);
            this.fieldsToSync = new BitSet(this.descriptionFields.size());
            for (SyncedField<?> field : this.descriptionFields) {
                field.update();
            }
        }
        return this.descriptionFields;
    }

    public void sendDescriptionPacket() {
        this.sendDescriptionPacket(256.0);
    }

    void sendDescriptionPacket(double maxPacketDistance) {
        PacketDescription descPacket = new PacketDescription(this, this.forceFullSync);
        if (descPacket.hasData()) {
            NetworkHandler.sendToAllAround(descPacket, this.field_145850_b, maxPacketDistance);
        }
        this.fieldsToSync.clear();
        this.forceFullSync = false;
    }

    void scheduleDescriptionPacket() {
        this.forceFullSync = true;
    }

    void tickImpl() {
        if (this.firstRun && !this.field_145850_b.field_72995_K) {
            this.onFirstServerTick();
            this.onNeighborTileUpdate();
            this.onNeighborBlockUpdate();
        }
        this.firstRun = false;
        this.upgradeCache.validate();
        if (!this.field_145850_b.field_72995_K) {
            this.getCapability(PNCCapabilities.HEAT_EXCHANGER_CAPABILITY).ifPresent(IHeatExchangerLogic::tick);
            if (this instanceof IAutoFluidEjecting && this.getUpgrades(EnumUpgrade.DISPENSER) > 0) {
                ((IAutoFluidEjecting)((Object)this)).autoExportFluid(this);
            }
            for (int i = 0; i < this.getDescriptionFields().size(); ++i) {
                if (!this.getDescriptionFields().get(i).update()) continue;
                this.fieldsToSync.set(i);
            }
            if (this.forceFullSync || !this.fieldsToSync.isEmpty()) {
                this.sendDescriptionPacket();
            }
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.getInventoryCap().isPresent()) {
            this.getInventoryCap().invalidate();
        }
        if (this.getHeatCap(null).isPresent()) {
            this.getHeatCap(null).invalidate();
        }
    }

    protected void onFirstServerTick() {
        this.initializeHullHeatExchangers();
    }

    protected void updateNeighbours() {
        this.field_145850_b.func_195593_d(this.func_174877_v(), this.func_195044_w().func_177230_c());
    }

    public void onBlockRotated() {
        if (this instanceof ISideConfigurable) {
            for (SideConfigurator<?> sc : ((ISideConfigurable)((Object)this)).getSideConfigurators()) {
                sc.setupFacingMatrix();
            }
        }
    }

    void rerenderTileEntity() {
        this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 0);
    }

    protected boolean shouldRerenderChunkOnDescUpdate() {
        return this instanceof ICamouflageableTE;
    }

    @Override
    public void writeToPacket(CompoundNBT tag) {
        if (this instanceof ISideConfigurable) {
            tag.func_218657_a("SideConfiguration", (INBT)SideConfigurator.writeToNBT((ISideConfigurable)((Object)this)));
        }
    }

    @Override
    public void readFromPacket(CompoundNBT tag) {
        if (this instanceof ISideConfigurable) {
            SideConfigurator.readFromNBT(tag.func_74775_l("SideConfiguration"), (ISideConfigurable)((Object)this));
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        if (this.getUpgradeHandler().getSlots() > 0) {
            tag.func_218657_a("UpgradeInventory", (INBT)this.getUpgradeHandler().serializeNBT());
        }
        this.getCapability(PNCCapabilities.HEAT_EXCHANGER_CAPABILITY).ifPresent(logic -> tag.func_218657_a("HeatExchanger", logic.serializeNBT()));
        if (this instanceof ISerializableTanks) {
            tag.func_218657_a("SavedTanks", (INBT)((ISerializableTanks)((Object)this)).serializeTanks());
        }
        this.writeToPacket(tag);
        return tag;
    }

    public void func_145839_a(CompoundNBT tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("UpgradeInventory") && this.getUpgradeHandler() != null) {
            this.getUpgradeHandler().deserializeNBT(tag.func_74775_l("UpgradeInventory"));
        }
        this.getCapability(PNCCapabilities.HEAT_EXCHANGER_CAPABILITY).ifPresent(logic -> logic.deserializeNBT((INBT)tag.func_74775_l("HeatExchanger")));
        if (this instanceof ISerializableTanks) {
            ((ISerializableTanks)((Object)this)).deserializeTanks(tag.func_74775_l("SavedTanks"));
        }
        this.readFromPacket(tag);
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.scheduleDescriptionPacket();
    }

    @Override
    public void onDescUpdate() {
        if (this.shouldRerenderChunkOnDescUpdate()) {
            this.rerenderTileEntity();
            if (this instanceof ICamouflageableTE) {
                this.requestModelDataUpdate();
            }
        }
    }

    @Nonnull
    public IModelData getModelData() {
        if (this instanceof ICamouflageableTE) {
            return new ModelDataMap.Builder().withInitial(BlockPneumaticCraftCamo.BLOCK_ACCESS, (Object)this.field_145850_b).withInitial(BlockPneumaticCraftCamo.BLOCK_POS, (Object)this.field_174879_c).withInitial(BlockPneumaticCraftCamo.CAMO_STATE, (Object)((ICamouflageableTE)((Object)this)).getCamouflage()).build();
        }
        return super.getModelData();
    }

    public void onGuiUpdate() {
    }

    public Direction getRotation() {
        BlockState state = this.func_195044_w();
        return state.func_177230_c() instanceof BlockPneumaticCraft ? ((BlockPneumaticCraft)state.func_177230_c()).getRotation(state) : Direction.NORTH;
    }

    public void func_145836_u() {
        super.func_145836_u();
    }

    public int getUpgrades(Item upgrade) {
        int upgrades = 0;
        for (int i = 0; i < this.getUpgradeHandler().getSlots(); ++i) {
            ItemStack stack = this.getUpgradeHandler().getStackInSlot(i);
            if (stack.func_77973_b() != upgrade) continue;
            upgrades += stack.func_190916_E();
        }
        return upgrades;
    }

    public int getUpgrades(EnumUpgrade upgrade) {
        return this.upgradeCache.getUpgrades(upgrade);
    }

    public float getSpeedMultiplierFromUpgrades() {
        return this.actualSpeedMult;
    }

    public float getSpeedUsageMultiplierFromUpgrades() {
        return this.actualUsageMult;
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, PlayerEntity player) {
    }

    public boolean isGuiUseableByPlayer(PlayerEntity player) {
        return this.func_145831_w().func_175625_s(this.func_174877_v()) == this && player.func_70092_e((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5) <= 64.0;
    }

    public void onNeighborTileUpdate() {
        for (TileEntityCache cache : this.getTileCache()) {
            cache.update();
        }
    }

    public TileEntityCache[] getTileCache() {
        if (this.tileCache == null) {
            this.tileCache = TileEntityCache.getDefaultCache(this.func_145831_w(), this.func_174877_v());
        }
        return this.tileCache;
    }

    public TileEntity getCachedNeighbor(Direction dir) {
        return this.getTileCache()[dir.func_176745_a()].getTileEntity();
    }

    public void onNeighborBlockUpdate() {
        this.poweredRedstone = PneumaticCraftUtils.getRedstoneLevel(this.func_145831_w(), this.func_174877_v());
        if (this.getCapability(PNCCapabilities.HEAT_EXCHANGER_CAPABILITY).isPresent()) {
            this.initializeHullHeatExchangers();
        }
        for (TileEntityCache cache : this.getTileCache()) {
            cache.update();
        }
    }

    public boolean redstoneAllows() {
        switch (((IRedstoneControl)((Object)this)).getRedstoneMode()) {
            case 0: {
                return true;
            }
            case 1: {
                return this.poweredRedstone > 0;
            }
            case 2: {
                return this.poweredRedstone == 0;
            }
        }
        return false;
    }

    private void initializeHullHeatExchangers() {
        IdentityHashMap<IHeatExchangerLogic, List> map = new IdentityHashMap<IHeatExchangerLogic, List>();
        for (Direction side : Direction.field_199792_n) {
            this.getCapability(PNCCapabilities.HEAT_EXCHANGER_CAPABILITY, side).ifPresent(logic -> map.computeIfAbsent((IHeatExchangerLogic)logic, k -> new ArrayList()).add(side));
        }
        map.forEach((logic, sides) -> logic.initializeAsHull(this.func_145831_w(), this.func_174877_v(), this.heatExchangerBlockFilter(), sides.toArray(new Direction[0])));
    }

    protected BiPredicate<IWorld, BlockPos> heatExchangerBlockFilter() {
        return IHeatExchangerLogic.ALL_BLOCKS;
    }

    void processFluidItem(int inputSlot, int outputSlot) {
        this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(itemHandler -> {
            ItemStack inputStack = itemHandler.getStackInSlot(inputSlot);
            if (inputStack.func_190916_E() > 1) {
                return;
            }
            FluidUtil.getFluidHandler((ItemStack)inputStack).ifPresent(fluidHandlerItem -> {
                FluidStack itemContents = fluidHandlerItem.drain(1000, IFluidHandler.FluidAction.SIMULATE);
                this.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).ifPresent(fluidHandler -> {
                    FluidStack transferred;
                    if (!itemContents.isEmpty()) {
                        ItemStack emptyContainerStack;
                        ItemStack excess;
                        FluidStack transferred2 = FluidUtil.tryFluidTransfer((IFluidHandler)fluidHandler, (IFluidHandler)fluidHandlerItem, (int)itemContents.getAmount(), (boolean)true);
                        if (transferred2.getAmount() == itemContents.getAmount() && (excess = itemHandler.insertItem(outputSlot, emptyContainerStack = fluidHandlerItem.getContainer(), true)).func_190926_b()) {
                            itemHandler.extractItem(inputSlot, 1, false);
                            itemHandler.insertItem(outputSlot, emptyContainerStack, false);
                        }
                    } else if (itemHandler.getStackInSlot(outputSlot).func_190926_b() && !(transferred = FluidUtil.tryFluidTransfer((IFluidHandler)fluidHandlerItem, (IFluidHandler)fluidHandler, (int)Integer.MAX_VALUE, (boolean)true)).isEmpty()) {
                        itemHandler.extractItem(inputSlot, 1, false);
                        ItemStack filledContainerStack = fluidHandlerItem.getContainer();
                        itemHandler.insertItem(outputSlot, filledContainerStack, false);
                    }
                });
            });
        });
    }

    @Override
    public Map<EnumUpgrade, Integer> getApplicableUpgrades() {
        return ApplicableUpgradesDB.getInstance().getApplicableUpgrades(this);
    }

    @Override
    public void addLuaMethods(LuaMethodRegistry registry) {
        for (Direction d : Direction.field_199792_n) {
            if (!this.getHeatCap(d).isPresent()) continue;
            registry.registerLuaMethod(new LuaMethod("getTemperature"){

                @Override
                public Object[] call(Object[] args) {
                    this.requireArgs(args, 0, 1, "face? (down/up/north/south/west/east)");
                    Direction dir = args.length == 0 ? null : this.getDirForString((String)args[0]);
                    return new Object[]{TileEntityBase.this.getHeatCap(dir).map(IHeatExchangerLogic::getTemperature).orElseThrow(RuntimeException::new)};
                }
            });
            break;
        }
    }

    @Override
    public LuaMethodRegistry getLuaMethodRegistry() {
        return this.luaMethodRegistry;
    }

    @Override
    public String getPeripheralType() {
        return this.func_200662_C().getRegistryName().toString();
    }

    public abstract IItemHandler getPrimaryInventory();

    public UpgradeHandler getUpgradeHandler() {
        return this.upgradeHandler;
    }

    @Nonnull
    protected LazyOptional<IItemHandler> getInventoryCap() {
        return LazyOptional.empty();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.orEmpty(cap, this.getInventoryCap());
        }
        if (cap == PNCCapabilities.HEAT_EXCHANGER_CAPABILITY) {
            return PNCCapabilities.HEAT_EXCHANGER_CAPABILITY.orEmpty(cap, this.getHeatCap(side));
        }
        return super.getCapability(cap, side);
    }

    public LazyOptional<IHeatExchangerLogic> getHeatCap(Direction side) {
        return LazyOptional.empty();
    }

    public void getContentsToDrop(NonNullList<ItemStack> drops) {
        BlockState camoState;
        PneumaticCraftUtils.collectNonEmptyItems(this.getPrimaryInventory(), drops);
        if (!this.shouldPreserveStateOnBreak()) {
            UpgradeHandler uh = this.getUpgradeHandler();
            for (int i = 0; i < uh.getSlots(); ++i) {
                if (uh.getStackInSlot(i).func_190926_b()) continue;
                drops.add((Object)uh.getStackInSlot(i));
            }
        }
        if (this instanceof ICamouflageableTE && (camoState = ((ICamouflageableTE)((Object)this)).getCamouflage()) != null) {
            drops.add((Object)ICamouflageableTE.getStackForState(camoState));
        }
    }

    public final String getRedstoneButtonText(int mode) {
        try {
            return this.getRedstoneButtonLabels().get(mode);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return "<ERROR>";
        }
    }

    protected List<String> getRedstoneButtonLabels() {
        return REDSTONE_LABELS;
    }

    public int getRedstoneModeCount() {
        return this.getRedstoneButtonLabels().size();
    }

    public String getRedstoneTabTitle() {
        return this instanceof IRedstoneControlled ? "pneumaticcraft.gui.tab.redstoneBehaviour.enableOn" : "pneumaticcraft.gui.tab.redstoneBehaviour.emitRedstoneWhen";
    }

    public boolean shouldPreserveStateOnBreak() {
        return this.preserveStateOnBreak;
    }

    public void setPreserveStateOnBreak(boolean preserveStateOnBreak) {
        this.preserveStateOnBreak = preserveStateOnBreak;
    }

    @Override
    public void onUpgradesChanged() {
        this.actualSpeedMult = (float)Math.pow(PNCConfig.Common.Machines.speedUpgradeSpeedMultiplier, Math.min(10, this.getUpgrades(EnumUpgrade.SPEED)));
        this.actualUsageMult = (float)Math.pow(PNCConfig.Common.Machines.speedUpgradeUsageMultiplier, Math.min(10, this.getUpgrades(EnumUpgrade.SPEED)));
    }

    public UpgradeCache getUpgradeCache() {
        return this.upgradeCache;
    }

    public void serializeExtraItemData(CompoundNBT blockEntityTag, boolean preserveState) {
    }

    public class UpgradeHandler
    extends BaseItemStackHandler {
        UpgradeHandler(int upgradeSize) {
            super(TileEntityBase.this, upgradeSize);
        }

        public boolean isItemValid(int slot, ItemStack itemStack) {
            return itemStack.func_190926_b() || this.isApplicable(itemStack) && this.isUnique(slot, itemStack);
        }

        protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
            EnumUpgrade upgrade = EnumUpgrade.from(stack);
            if (upgrade == null) {
                return 0;
            }
            return ApplicableUpgradesDB.getInstance().getMaxUpgrades(this.te, upgrade);
        }

        private boolean isUnique(int slot, ItemStack stack) {
            for (int i = 0; i < this.getSlots(); ++i) {
                if (i == slot || EnumUpgrade.from(stack) != EnumUpgrade.from(this.getStackInSlot(i))) continue;
                return false;
            }
            return true;
        }

        private boolean isApplicable(ItemStack stack) {
            EnumUpgrade upgrade = EnumUpgrade.from(stack);
            return ApplicableUpgradesDB.getInstance().getMaxUpgrades(TileEntityBase.this, upgrade) > 0;
        }

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            TileEntityBase.this.upgradeCache.invalidate();
        }
    }
}

