/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.common.config.PNCConfig;
import me.desht.pneumaticcraft.common.core.ModTileEntities;
import me.desht.pneumaticcraft.common.inventory.ContainerLiquidHopper;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.tileentity.ISerializableTanks;
import me.desht.pneumaticcraft.common.tileentity.SmartSyncTank;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAbstractHopper;
import me.desht.pneumaticcraft.common.util.FluidUtils;
import me.desht.pneumaticcraft.common.util.IOHelper;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.BucketItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;

public class TileEntityLiquidHopper
extends TileEntityAbstractHopper
implements ISerializableTanks {
    private int comparatorValue = -1;
    private AxisAlignedBB outputAABB;
    @DescSynced
    @GuiSynced
    private final HopperTank tank = new HopperTank(16000);
    private final LazyOptional<IFluidHandler> tankCap = LazyOptional.of(() -> this.tank);
    private final WrappedFluidTank inputWrapper = new WrappedFluidTank(this.tank, true);
    private final LazyOptional<IFluidHandler> inputCap = LazyOptional.of(() -> this.inputWrapper);
    private final WrappedFluidTank outputWrapper = new WrappedFluidTank(this.tank, false);
    private final LazyOptional<IFluidHandler> outputCap = LazyOptional.of(() -> this.outputWrapper);

    public TileEntityLiquidHopper() {
        super((TileEntityType)ModTileEntities.LIQUID_HOPPER.get());
    }

    @Override
    protected int getComparatorValueInternal() {
        if (this.comparatorValue < 0) {
            if (this.tank.getFluidAmount() == 0) {
                return 0;
            }
            FluidStack fluidStack = this.tank.getFluid();
            this.comparatorValue = (int)(1.0f + (float)fluidStack.getAmount() / (float)this.tank.getCapacity() * 14.0f);
        }
        return this.comparatorValue;
    }

    @Override
    protected void onFirstServerTick() {
        super.onFirstServerTick();
        this.setupOutputAABB();
    }

    @Override
    public void onBlockRotated() {
        super.onBlockRotated();
        this.setupOutputAABB();
    }

    private void setupOutputAABB() {
        this.outputAABB = new AxisAlignedBB(this.func_174877_v().func_177972_a(this.getRotation()));
    }

    @Override
    public void func_73660_a() {
        FluidStack fluidStack;
        super.func_73660_a();
        this.tank.tick();
        if (!this.field_145850_b.field_72995_K && this.getUpgrades(EnumUpgrade.CREATIVE) > 0 && !(fluidStack = this.tank.getFluid()).isEmpty() && fluidStack.getAmount() < 16000) {
            this.tank.fill(new FluidStack(fluidStack.getFluid(), 16000), IFluidHandler.FluidAction.EXECUTE);
        }
    }

    @Override
    protected boolean doExport(int maxItems) {
        if (this.tank.getFluid().isEmpty()) {
            return false;
        }
        Direction dir = this.getRotation();
        TileEntity neighbor = this.getCachedNeighbor(dir);
        if (neighbor != null) {
            return (Boolean)IOHelper.getFluidHandlerForTE(neighbor, dir.func_176734_d()).map(fluidHandler -> {
                int amount = Math.min(maxItems * 100, this.tank.getFluid().getAmount() - this.leaveMaterialCount * 1000);
                FluidStack transferred = FluidUtil.tryFluidTransfer((IFluidHandler)fluidHandler, (IFluidHandler)this.tank, (int)amount, (boolean)true);
                return !transferred.isEmpty();
            }).orElse((Object)false);
        }
        if (this.func_145831_w().func_175623_d(this.func_174877_v().func_177972_a(dir))) {
            for (ItemEntity entity : this.getNeighborItems(this.outputAABB)) {
                FluidActionResult res = FluidUtil.tryFillContainer((ItemStack)entity.func_92059_d(), (IFluidHandler)this.tank, (int)(maxItems * 100), null, (boolean)true);
                if (!res.success) continue;
                entity.func_92058_a(res.result);
                break;
            }
        }
        if (PNCConfig.Common.Machines.liquidHopperDispenser && this.getUpgrades(EnumUpgrade.DISPENSER) > 0) {
            return FluidUtils.tryPourOutFluid(this.outputCap, this.field_145850_b, this.func_174877_v().func_177972_a(dir), false, false, IFluidHandler.FluidAction.EXECUTE);
        }
        return false;
    }

    @Override
    protected boolean doImport(int maxItems) {
        Object cap;
        TileEntity inputInv = this.getCachedNeighbor(this.inputDir);
        if (inputInv != null && (cap = inputInv.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.inputDir.func_176734_d())).isPresent()) {
            return (Boolean)cap.map(fluidHandler -> {
                int filledFluid;
                FluidStack fluid = fluidHandler.drain(maxItems * 100, IFluidHandler.FluidAction.SIMULATE);
                if (fluid != null && (filledFluid = this.tank.fill(fluid, IFluidHandler.FluidAction.EXECUTE)) > 0) {
                    fluidHandler.drain(filledFluid, IFluidHandler.FluidAction.EXECUTE);
                    return true;
                }
                return false;
            }).orElse((Object)false);
        }
        if (this.func_145831_w().func_175623_d(this.func_174877_v().func_177972_a(this.inputDir))) {
            for (ItemEntity entity : this.getNeighborItems(this.inputAABB)) {
                int max = entity.func_92059_d().func_77973_b() instanceof BucketItem ? 1000 : maxItems * 100;
                FluidActionResult res = FluidUtil.tryEmptyContainer((ItemStack)entity.func_92059_d(), (IFluidHandler)this.tank, (int)max, null, (boolean)true);
                if (!res.success) continue;
                entity.func_92058_a(res.result);
                return true;
            }
        }
        if (PNCConfig.Common.Machines.liquidHopperDispenser && this.getUpgrades(EnumUpgrade.DISPENSER) > 0) {
            BlockPos neighborPos = this.func_174877_v().func_177972_a(this.inputDir);
            return !FluidUtils.tryPickupFluid(this.inputCap, this.field_145850_b, neighborPos, false, IFluidHandler.FluidAction.EXECUTE).isEmpty();
        }
        return false;
    }

    public HopperTank getTank() {
        return this.tank;
    }

    @Override
    public void func_145839_a(CompoundNBT tag) {
        super.func_145839_a(tag);
        this.comparatorValue = -1;
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return null;
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (facing == this.inputDir) {
                return this.inputCap.cast();
            }
            if (facing == this.getRotation()) {
                return this.outputCap.cast();
            }
            return this.tankCap.cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    protected LazyOptional<IItemHandler> getInventoryCap() {
        return LazyOptional.empty();
    }

    @Override
    @Nonnull
    public Map<String, FluidTank> getSerializableTanks() {
        return ImmutableMap.of((Object)"Tank", (Object)((Object)this.tank));
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerLiquidHopper(i, playerInventory, this.func_174877_v());
    }

    class WrappedFluidTank
    implements IFluidTank,
    IFluidHandler {
        private final FluidTank wrappedTank;
        private final boolean inbound;

        WrappedFluidTank(FluidTank wrappedTank, boolean inbound) {
            this.wrappedTank = wrappedTank;
            this.inbound = inbound;
        }

        public FluidStack getFluid() {
            return this.wrappedTank.getFluid();
        }

        public int getFluidAmount() {
            return this.wrappedTank.getFluidAmount();
        }

        public int getCapacity() {
            return this.wrappedTank.getCapacity();
        }

        public boolean isFluidValid(FluidStack stack) {
            return this.wrappedTank.isFluidValid(stack);
        }

        public int getTanks() {
            return 1;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return this.wrappedTank.getFluid();
        }

        public int getTankCapacity(int tank) {
            return this.wrappedTank.getCapacity();
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return this.wrappedTank.isFluidValid(stack);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction doFill) {
            return this.inbound ? this.wrappedTank.fill(resource, doFill) : 0;
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction doDrain) {
            return this.inbound ? FluidStack.EMPTY : TileEntityLiquidHopper.this.tank.drain(resource, doDrain);
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction doDrain) {
            return this.inbound ? FluidStack.EMPTY : this.wrappedTank.drain(maxDrain, doDrain);
        }
    }

    public class HopperTank
    extends SmartSyncTank {
        HopperTank(int capacity) {
            super(TileEntityLiquidHopper.this, capacity);
        }

        @Override
        protected void onContentsChanged() {
            super.onContentsChanged();
            TileEntityLiquidHopper.this.comparatorValue = -1;
        }

        @Override
        public int fill(FluidStack resource, IFluidHandler.FluidAction doFill) {
            int filled = super.fill(resource, doFill);
            if (TileEntityLiquidHopper.this.isCreative && this.getFluidAmount() > 0 && this.getFluid().getFluid() == resource.getFluid()) {
                return resource.getAmount();
            }
            return filled;
        }

        @Override
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction doDrain) {
            return super.drain(resource, TileEntityLiquidHopper.this.isCreative ? IFluidHandler.FluidAction.SIMULATE : doDrain);
        }

        @Override
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction doDrain) {
            return super.drain(maxDrain, TileEntityLiquidHopper.this.isCreative ? IFluidHandler.FluidAction.SIMULATE : doDrain);
        }
    }
}

