/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import com.mojang.authlib.GameProfile;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.client.render.RenderMinigunTracers;
import me.desht.pneumaticcraft.common.ai.StringFilterEntitySelector;
import me.desht.pneumaticcraft.common.core.ModTileEntities;
import me.desht.pneumaticcraft.common.inventory.ContainerSentryTurret;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.item.ItemGunAmmo;
import me.desht.pneumaticcraft.common.minigun.Minigun;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlaySound;
import me.desht.pneumaticcraft.common.tileentity.IGUITextFieldSensitive;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControlled;
import me.desht.pneumaticcraft.common.tileentity.TileEntitySecurityStation;
import me.desht.pneumaticcraft.common.tileentity.TileEntityTickableBase;
import me.desht.pneumaticcraft.common.util.EntityDistanceComparator;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.fakeplayer.FakeNetHandlerPlayerServer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntitySentryTurret
extends TileEntityTickableBase
implements IRedstoneControlled,
IGUITextFieldSensitive,
INamedContainerProvider {
    private static final int INVENTORY_SIZE = 4;
    public static final String NBT_ENTITY_FILTER = "entityFilter";
    private final ItemStackHandler inventory = new TurretItemStackHandler(this);
    private final LazyOptional<IItemHandler> invCap = LazyOptional.of(() -> this.inventory);
    @GuiSynced
    private String entityFilter = "@mob";
    @GuiSynced
    private int redstoneMode;
    @DescSynced
    private double range;
    @DescSynced
    private boolean activated;
    @DescSynced
    private ItemStack minigunColorStack = ItemStack.field_190927_a;
    private Minigun minigun;
    @DescSynced
    private int targetEntityId = -1;
    @DescSynced
    private boolean sweeping;
    private final SentryTurretEntitySelector entitySelector = new SentryTurretEntitySelector();
    private double rangeSq;
    private Vec3d tileVec;
    @DescSynced
    public float idleYaw;

    public TileEntitySentryTurret() {
        super((TileEntityType)ModTileEntities.SENTRY_TURRET.get(), 4);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.func_145831_w().field_72995_K) {
            LivingEntity target;
            if (this.getMinigun().getAttackTarget() == null && this.redstoneAllows()) {
                if (!PneumaticCraftUtils.areFloatsEqual(this.getMinigun().minigunYaw, this.getMinigun().getIdleYaw())) {
                    this.getMinigun().setReturning(true);
                }
                this.getMinigun().setSweeping(true);
                if ((this.func_145831_w().func_82737_E() & 0xFL) == 0L) {
                    List entities = this.func_145831_w().func_175647_a(LivingEntity.class, this.getTargetingBoundingBox(), (Predicate)((Object)this.entitySelector));
                    if (entities.size() > 0) {
                        entities.sort(new EntityDistanceComparator(this.func_174877_v()));
                        this.getMinigun().setAttackTarget((LivingEntity)entities.get(0));
                        this.targetEntityId = ((LivingEntity)entities.get(0)).func_145782_y();
                    } else {
                        this.targetEntityId = -1;
                    }
                }
            } else {
                this.getMinigun().setSweeping(false);
            }
            if ((target = this.getMinigun().getAttackTarget()) != null) {
                if (!this.redstoneAllows() || !this.entitySelector.apply((Entity)target)) {
                    this.getMinigun().setAttackTarget(null);
                    this.getMinigun().minigunYaw = this.idleYaw;
                    this.targetEntityId = -1;
                } else if ((this.func_145831_w().func_82737_E() & 7L) == 0L) {
                    this.getFakePlayer().func_70107_b((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5);
                    boolean usedAmmo = this.getMinigun().tryFireMinigun((Entity)target);
                    if (usedAmmo) {
                        for (int i = 0; i < this.inventory.getSlots(); ++i) {
                            if (this.inventory.getStackInSlot(i).func_190926_b()) continue;
                            this.inventory.setStackInSlot(i, ItemStack.field_190927_a);
                            break;
                        }
                    }
                }
            }
        }
        this.getMinigun().update((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5);
    }

    @Override
    public void serializeExtraItemData(CompoundNBT blockEntityTag, boolean preserveState) {
        blockEntityTag.func_74778_a(NBT_ENTITY_FILTER, this.getText(0));
    }

    private boolean canSeeEntity(Entity entity) {
        Vec3d entityVec = new Vec3d(entity.func_226277_ct_() + (double)(entity.func_213311_cf() / 2.0f), entity.func_226278_cu_() + (double)(entity.func_213302_cg() / 2.0f), entity.func_226281_cx_() + (double)(entity.func_213311_cf() / 2.0f));
        RayTraceContext ctx = new RayTraceContext(entityVec, this.tileVec, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, entity);
        BlockRayTraceResult trace = this.func_145831_w().func_217299_a(ctx);
        return trace.func_216350_a().equals((Object)this.func_174877_v());
    }

    private AxisAlignedBB getTargetingBoundingBox() {
        return new AxisAlignedBB(this.func_174877_v()).func_186662_g(this.range);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return RenderMinigunTracers.shouldRender(this.getMinigun()) ? new AxisAlignedBB(this.func_174877_v(), this.getMinigun().getAttackTarget().func_180425_c()) : super.getRenderBoundingBox();
    }

    @Override
    protected void onFirstServerTick() {
        super.onFirstServerTick();
        this.tileVec = new Vec3d((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5);
        this.updateAmmo();
        this.onFilterChanged(this.entityFilter);
    }

    @Override
    public void onDescUpdate() {
        super.onDescUpdate();
        Entity entity = this.func_145831_w().func_73045_a(this.targetEntityId);
        if (entity instanceof LivingEntity) {
            this.getMinigun().setAttackTarget((LivingEntity)entity);
        } else {
            this.getMinigun().setAttackTarget(null);
            this.getMinigun().setReturning(true);
        }
    }

    public Minigun getMinigun() {
        if (this.minigun == null) {
            this.minigun = new MinigunSentryTurret();
            this.minigun.setWorld(this.func_145831_w());
            if (!this.func_145831_w().field_72995_K) {
                this.minigun.setPlayer(this.getFakePlayer());
            }
            this.minigun.minigunYaw = this.idleYaw;
            this.minigun.setIdleYaw(this.idleYaw);
        }
        return this.minigun;
    }

    private PlayerEntity getFakePlayer() {
        FakePlayer fakePlayer = FakePlayerFactory.get((ServerWorld)((ServerWorld)this.func_145831_w()), (GameProfile)new GameProfile(null, "Sentry Turret"));
        if (fakePlayer.field_71135_a == null) {
            fakePlayer.field_71135_a = new FakeNetHandlerPlayerServer(ServerLifecycleHooks.getCurrentServer(), (ServerPlayerEntity)fakePlayer);
        }
        return fakePlayer;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_218657_a("Items", (INBT)this.inventory.serializeNBT());
        tag.func_74774_a("redstoneMode", (byte)this.redstoneMode);
        tag.func_74778_a(NBT_ENTITY_FILTER, this.entityFilter);
        tag.func_74776_a("idleYaw", this.idleYaw);
        return tag;
    }

    @Override
    public void func_145839_a(CompoundNBT tag) {
        super.func_145839_a(tag);
        this.inventory.deserializeNBT(tag.func_74775_l("Items"));
        this.redstoneMode = tag.func_74771_c("redstoneMode");
        this.idleYaw = tag.func_74760_g("idleYaw");
        this.setText(0, tag.func_74779_i(NBT_ENTITY_FILTER));
    }

    @Override
    public boolean redstoneAllows() {
        return this.redstoneMode == 3 || super.redstoneAllows();
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return this.inventory;
    }

    @Override
    public int getRedstoneMode() {
        return this.redstoneMode;
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, PlayerEntity player) {
        if (tag.equals("redstone")) {
            ++this.redstoneMode;
            if (this.redstoneMode > 2) {
                this.redstoneMode = 0;
            }
        }
    }

    public ITextComponent func_145748_c_() {
        return this.getDisplayNameInternal();
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerSentryTurret(i, playerInventory, this.func_174877_v());
    }

    private void updateAmmo() {
        ItemStack ammo = ItemStack.field_190927_a;
        for (int i = 0; i < this.inventory.getSlots() && (ammo = this.inventory.getStackInSlot(i)).func_190926_b(); ++i) {
        }
        this.getMinigun().setAmmoStack(ammo);
        this.recalculateRange();
    }

    @Override
    protected LazyOptional<IItemHandler> getInventoryCap() {
        return this.invCap;
    }

    @Override
    public void onUpgradesChanged() {
        super.onUpgradesChanged();
        if (this.func_145831_w() != null) {
            this.recalculateRange();
        }
    }

    private void recalculateRange() {
        this.range = 16.0 + (double)Math.min(16, this.getUpgrades(EnumUpgrade.RANGE));
        ItemStack ammoStack = this.getMinigun().getAmmoStack();
        if (ammoStack.func_77973_b() instanceof ItemGunAmmo) {
            this.range *= (double)((ItemGunAmmo)ammoStack.func_77973_b()).getRangeMultiplier(ammoStack);
        }
        this.rangeSq = this.range * this.range;
    }

    @Override
    public void setText(int textFieldID, String text) {
        this.entityFilter = text;
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.onFilterChanged(text);
            if (this.minigun != null) {
                this.minigun.setAttackTarget(null);
            }
        }
    }

    private void onFilterChanged(String text) {
        this.entitySelector.setFilter(text);
        this.func_70296_d();
    }

    @Override
    public String getText(int textFieldID) {
        return this.entityFilter;
    }

    private class SentryTurretEntitySelector
    extends StringFilterEntitySelector {
        private SentryTurretEntitySelector() {
        }

        @Override
        public boolean apply(Entity entity) {
            PlayerEntity player;
            if (entity instanceof PlayerEntity && ((player = (PlayerEntity)entity).func_184812_l_() || player.func_175149_v() || this.isExcludedBySecurityStations(player))) {
                return false;
            }
            return super.apply(entity) && this.inRange(entity) && TileEntitySentryTurret.this.canSeeEntity(entity);
        }

        private boolean inRange(Entity entity) {
            return PneumaticCraftUtils.distBetweenSq((Vec3i)new BlockPos(TileEntitySentryTurret.this.func_174877_v().func_177958_n(), TileEntitySentryTurret.this.func_174877_v().func_177956_o(), TileEntitySentryTurret.this.func_174877_v().func_177952_p()), entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_()) <= TileEntitySentryTurret.this.rangeSq;
        }

        private boolean isExcludedBySecurityStations(PlayerEntity player) {
            Iterator iterator = TileEntitySecurityStation.getSecurityStations(TileEntitySentryTurret.this.func_145831_w(), TileEntitySentryTurret.this.func_174877_v(), false).iterator();
            if (iterator.hasNext()) {
                while (iterator.hasNext()) {
                    if (((TileEntitySecurityStation)iterator.next()).doesAllowPlayer(player)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    private class MinigunSentryTurret
    extends Minigun {
        MinigunSentryTurret() {
            super(true);
        }

        @Override
        public boolean isMinigunActivated() {
            return TileEntitySentryTurret.this.activated;
        }

        @Override
        public void setMinigunActivated(boolean activated) {
            TileEntitySentryTurret.this.activated = activated;
        }

        @Override
        public void setAmmoColorStack(@Nonnull ItemStack ammo) {
            TileEntitySentryTurret.this.minigunColorStack = ammo;
        }

        @Override
        public int getAmmoColor() {
            return this.getAmmoColor(TileEntitySentryTurret.this.minigunColorStack);
        }

        @Override
        public void playSound(SoundEvent soundName, float volume, float pitch) {
            NetworkHandler.sendToAllAround(new PacketPlaySound(soundName, SoundCategory.BLOCKS, (double)TileEntitySentryTurret.this.func_174877_v().func_177958_n() + 0.5, (double)TileEntitySentryTurret.this.func_174877_v().func_177956_o() + 0.5, (double)TileEntitySentryTurret.this.func_174877_v().func_177952_p() + 0.5, volume, pitch, false), this.world);
        }

        @Override
        public void setSweeping(boolean sweeping) {
            TileEntitySentryTurret.this.sweeping = sweeping;
        }

        @Override
        public boolean isSweeping() {
            return TileEntitySentryTurret.this.sweeping;
        }

        @Override
        public Object getSoundSource() {
            return TileEntitySentryTurret.this.func_174877_v();
        }

        @Override
        public boolean isValid() {
            return !TileEntitySentryTurret.this.func_145837_r();
        }
    }

    private class TurretItemStackHandler
    extends BaseItemStackHandler {
        TurretItemStackHandler(TileEntity te) {
            super(te, 4);
        }

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            TileEntitySentryTurret.this.updateAmmo();
        }

        public boolean isItemValid(int slot, ItemStack itemStack) {
            return itemStack.func_190926_b() || itemStack.func_77973_b() instanceof ItemGunAmmo;
        }
    }
}

