/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import com.google.common.collect.ImmutableList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.api.item.IPositionProvider;
import me.desht.pneumaticcraft.api.universal_sensor.IEventSensorSetting;
import me.desht.pneumaticcraft.api.universal_sensor.IPollSensorSetting;
import me.desht.pneumaticcraft.api.universal_sensor.ISensorSetting;
import me.desht.pneumaticcraft.client.gui.GuiUniversalSensor;
import me.desht.pneumaticcraft.client.util.RangeLines;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.core.ModTileEntities;
import me.desht.pneumaticcraft.common.inventory.ContainerUniversalSensor;
import me.desht.pneumaticcraft.common.item.ItemGPSTool;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketRenderRangeLines;
import me.desht.pneumaticcraft.common.sensor.SensorHandler;
import me.desht.pneumaticcraft.common.thirdparty.ThirdPartyManager;
import me.desht.pneumaticcraft.common.thirdparty.computer_common.ComputerEventManager;
import me.desht.pneumaticcraft.common.thirdparty.computer_common.LuaMethod;
import me.desht.pneumaticcraft.common.thirdparty.computer_common.LuaMethodRegistry;
import me.desht.pneumaticcraft.common.tileentity.IGUITextFieldSensitive;
import me.desht.pneumaticcraft.common.tileentity.IMinWorkingPressure;
import me.desht.pneumaticcraft.common.tileentity.IRangeLineShower;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControl;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticBase;
import me.desht.pneumaticcraft.common.util.GlobalTileEntityCacheManager;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityUniversalSensor
extends TileEntityPneumaticBase
implements IRangeLineShower,
IGUITextFieldSensitive,
IMinWorkingPressure,
IRedstoneControl,
INamedContainerProvider {
    private static final List<String> REDSTONE_LABELS = ImmutableList.of((Object)"pneumaticcraft.gui.tab.redstoneBehaviour.universalSensor.button.normal", (Object)"pneumaticcraft.gui.tab.redstoneBehaviour.universalSensor.button.inverted");
    @GuiSynced
    private String sensorSetting = "";
    private int tickTimer;
    public int redstoneStrength;
    private int redstonePulseCounter;
    public float dishRotation;
    public float oldDishRotation;
    private float dishSpeed;
    @GuiSynced
    private boolean invertedRedstone;
    @DescSynced
    public boolean isSensorActive;
    @GuiSynced
    public String lastSensorExceptionText = "";
    @GuiSynced
    private String sensorGuiText = "";
    @GuiSynced
    public SensorStatus sensorStatus = SensorStatus.OK;
    private boolean requestPollPullEvent;
    private final Set<BlockPos> positions = new HashSet<BlockPos>();
    private int oldSensorRange;
    public final RangeLines rangeLines = new RangeLines(0x600060FF);
    private final ItemStackHandler itemHandler = new UniversalSensorItemHandler();
    private final LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.itemHandler);
    @GuiSynced
    public int outOfRange;

    public TileEntityUniversalSensor() {
        super((TileEntityType)ModTileEntities.UNIVERSAL_SENSOR.get(), 5.0f, 7.0f, 5000, 4);
    }

    @Override
    public void func_73660_a() {
        this.oldDishRotation = this.dishRotation;
        this.dishSpeed = this.isSensorActive ? Math.min(this.dishSpeed + 0.2f, 10.0f) : Math.max(this.dishSpeed - 0.2f, 0.0f);
        this.dishRotation += this.dishSpeed;
        if (this.func_145831_w().field_72995_K) {
            int sensorRange = this.getRange();
            if (this.oldSensorRange != sensorRange || this.oldSensorRange == 0) {
                this.oldSensorRange = sensorRange;
                if (!this.firstRun) {
                    this.rangeLines.startRendering(sensorRange);
                }
            }
            this.rangeLines.tick(this.field_145850_b.field_73012_v);
        }
        super.func_73660_a();
        if (!this.func_145831_w().field_72995_K) {
            ++this.tickTimer;
            ISensorSetting sensor = SensorHandler.getInstance().getSensorFromPath(this.sensorSetting);
            if (this.updateStatus(sensor) == SensorStatus.OK && sensor != null && this.getPressure() > 0.5f) {
                this.isSensorActive = true;
                this.addAir(-sensor.getAirUsage(this.func_145831_w(), this.func_174877_v()));
                if (sensor instanceof IPollSensorSetting) {
                    if (this.tickTimer >= ((IPollSensorSetting)sensor).getPollFrequency(this)) {
                        try {
                            int newRedstoneStrength = ((IPollSensorSetting)sensor).getRedstoneValue(this.func_145831_w(), this.func_174877_v(), this.getRange(), this.sensorGuiText);
                            if (this.invertedRedstone) {
                                newRedstoneStrength = 15 - newRedstoneStrength;
                            }
                            if (newRedstoneStrength != this.redstoneStrength) {
                                this.redstoneStrength = newRedstoneStrength;
                                if (this.requestPollPullEvent) {
                                    this.notifyComputers(this.redstoneStrength);
                                }
                                this.updateNeighbours();
                            }
                            this.tickTimer = 0;
                        }
                        catch (Exception e) {
                            this.lastSensorExceptionText = e.getMessage() == null ? "" : e.getMessage();
                        }
                    }
                    this.redstonePulseCounter = 0;
                } else if (this.redstonePulseCounter > 0) {
                    --this.redstonePulseCounter;
                    if (this.redstonePulseCounter == 0 && this.redstoneStrength != (this.invertedRedstone ? 15 : 0)) {
                        this.redstoneStrength = this.invertedRedstone ? 15 : 0;
                        this.updateNeighbours();
                    }
                }
            } else {
                this.isSensorActive = false;
                if (this.redstoneStrength != (this.invertedRedstone ? 15 : 0)) {
                    this.redstoneStrength = this.invertedRedstone ? 15 : 0;
                    this.updateNeighbours();
                }
            }
        }
    }

    private void notifyComputers(Object ... params) {
        ComputerEventManager.getInstance().sendEvents(this, "universalSensor", params);
    }

    private SensorStatus updateStatus(ISensorSetting sensor) {
        this.sensorStatus = SensorStatus.OK;
        if (sensor != null) {
            if (sensor.needsGPSTool() && this.getPrimaryInventory().getStackInSlot(0).func_190926_b()) {
                this.sensorStatus = SensorStatus.MISSING_GPS;
            } else {
                for (EnumUpgrade upgrade : sensor.getRequiredUpgrades()) {
                    if (this.getUpgrades(upgrade) != 0) continue;
                    this.sensorStatus = SensorStatus.MISSING_UPGRADE;
                    break;
                }
            }
        } else {
            this.sensorStatus = SensorStatus.NO_SENSOR;
        }
        return this.sensorStatus;
    }

    @Override
    protected boolean shouldRerenderChunkOnDescUpdate() {
        return true;
    }

    @Override
    public boolean canConnectPneumatic(Direction side) {
        return side != Direction.UP;
    }

    @Override
    public void showRangeLines() {
        if (this.func_145831_w().field_72995_K) {
            this.rangeLines.startRendering(this.getRange());
        } else {
            NetworkHandler.sendToAllAround(new PacketRenderRangeLines(this), this.func_145831_w(), 64.0 + (double)this.getRange());
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return this.rangeLines == null || !this.rangeLines.shouldRender() ? super.getRenderBoundingBox() : new AxisAlignedBB(this.func_174877_v()).func_186662_g((double)this.getRange());
    }

    public void onEvent(Event event) {
        ISensorSetting sensor = SensorHandler.getInstance().getSensorFromPath(this.sensorSetting);
        if (sensor instanceof IEventSensorSetting && this.getPressure() >= this.getMinWorkingPressure()) {
            int newRedstoneStrength = ((IEventSensorSetting)sensor).emitRedstoneOnEvent(event, this, this.getRange(), this.sensorGuiText);
            if (newRedstoneStrength != 0) {
                this.redstonePulseCounter = ((IEventSensorSetting)sensor).getRedstonePulseLength();
            }
            if (this.invertedRedstone) {
                newRedstoneStrength = 15 - newRedstoneStrength;
            }
            if (this.redstonePulseCounter > 0 && ThirdPartyManager.instance().isModTypeLoaded(ThirdPartyManager.ModType.COMPUTER)) {
                if (event instanceof PlayerInteractEvent) {
                    PlayerInteractEvent e = (PlayerInteractEvent)event;
                    this.notifyComputers(newRedstoneStrength, e.getPos().func_177958_n(), e.getPos().func_177956_o(), e.getPos().func_177952_p());
                } else {
                    this.notifyComputers(newRedstoneStrength);
                }
            }
            if (newRedstoneStrength != this.redstoneStrength) {
                this.redstoneStrength = newRedstoneStrength;
                this.updateNeighbours();
            }
        }
    }

    public int getRange() {
        return this.getUpgrades(EnumUpgrade.RANGE) + 8;
    }

    private void setSensorSetting(String sensorPath) {
        this.sensorSetting = sensorPath;
        if (this.func_145831_w() != null && this.func_145831_w().field_72995_K) {
            GuiUniversalSensor.maybeUpdateButtons();
        }
    }

    private boolean setSensorSetting(ISensorSetting sensor) {
        if (this.areGivenUpgradesInserted(sensor.getRequiredUpgrades())) {
            this.setSensorSetting(sensor.getSensorPath());
            return true;
        }
        return false;
    }

    public String getSensorSetting() {
        return this.sensorSetting;
    }

    @Override
    public void onGuiUpdate() {
        this.setSensorSetting(this.sensorSetting);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_218657_a("Items", (INBT)this.itemHandler.serializeNBT());
        tag.func_74778_a("sensorSetting", this.sensorSetting);
        tag.func_74757_a("invertedRedstone", this.invertedRedstone);
        tag.func_74776_a("dishSpeed", this.dishSpeed);
        tag.func_74778_a("sensorText", this.sensorGuiText);
        return tag;
    }

    @Override
    public void func_145839_a(CompoundNBT tag) {
        super.func_145839_a(tag);
        this.itemHandler.deserializeNBT(tag.func_74775_l("Items"));
        this.setSensorSetting(tag.func_74779_i("sensorSetting"));
        this.invertedRedstone = tag.func_74767_n("invertedRedstone");
        this.dishSpeed = tag.func_74760_g("dishSpeed");
        this.sensorGuiText = tag.func_74779_i("sensorText");
        this.setupGPSPositions();
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, PlayerEntity player) {
        if (tag.equals("back")) {
            String[] folders = this.getSensorSetting().split("/");
            String newPath = this.getSensorSetting().replace(folders[folders.length - 1], "");
            if (newPath.endsWith("/")) {
                newPath = newPath.substring(0, newPath.length() - 1);
            }
            this.setSensorSetting(newPath);
            this.setText(0, "");
        } else if (tag.equals("redstone")) {
            this.invertedRedstone = !this.invertedRedstone;
            this.redstoneStrength = 15 - this.redstoneStrength;
            this.updateNeighbours();
        } else if (tag.startsWith("set:")) {
            try {
                int t = Integer.parseInt(tag.split(":")[1]);
                String[] directories = SensorHandler.getInstance().getDirectoriesAtLocation(this.getSensorSetting());
                if (t / 10 <= directories.length) {
                    if (this.getSensorSetting().equals("")) {
                        this.setSensorSetting(directories[t / 10 - 1]);
                    } else {
                        this.setSensorSetting(this.getSensorSetting() + "/" + directories[t / 10 - 1]);
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    @Override
    public void onUpgradesChanged() {
        super.onUpgradesChanged();
        this.setupGPSPositions();
    }

    public boolean areGivenUpgradesInserted(Set<EnumUpgrade> requiredUpgrades) {
        for (EnumUpgrade upgrade : requiredUpgrades) {
            if (this.getUpgrades(upgrade) != 0) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public Set<BlockPos> getGPSPositions() {
        return this.positions;
    }

    private void setupGPSPositions() {
        this.positions.clear();
        this.outOfRange = 0;
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        if (stack.func_77973_b() instanceof IPositionProvider) {
            int sensorRange = this.getRange();
            List<BlockPos> posList = ((IPositionProvider)stack.func_77973_b()).getStoredPositions(this.field_145850_b, stack);
            List gpsPositions = posList.stream().filter(pos -> pos != null && Math.abs(pos.func_177958_n() - this.func_174877_v().func_177958_n()) <= sensorRange && Math.abs(pos.func_177956_o() - this.func_174877_v().func_177956_o()) <= sensorRange && Math.abs(pos.func_177952_p() - this.func_174877_v().func_177952_p()) <= sensorRange).collect(Collectors.toList());
            this.positions.addAll(gpsPositions);
            this.outOfRange = posList.size() - gpsPositions.size();
            this.updateStatus(SensorHandler.getInstance().getSensorFromPath(this.sensorSetting));
        }
        if (this.func_145831_w() != null && this.func_145831_w().field_72995_K) {
            GuiUniversalSensor.maybeUpdateButtons();
        }
    }

    @Override
    public void setText(int textFieldID, String text) {
        this.sensorGuiText = text;
        ISensorSetting sensor = SensorHandler.getInstance().getSensorFromPath(this.sensorSetting);
        if (sensor != null) {
            try {
                this.lastSensorExceptionText = "";
                sensor.notifyTextChange(this.sensorGuiText);
            }
            catch (Exception e) {
                String string = this.lastSensorExceptionText = e.getMessage() == null ? "" : e.getMessage();
            }
        }
        if (!this.func_145831_w().field_72995_K) {
            this.scheduleDescriptionPacket();
        }
    }

    @Override
    public String getText(int textFieldID) {
        return this.sensorGuiText;
    }

    @Override
    public void addLuaMethods(LuaMethodRegistry registry) {
        super.addLuaMethods(registry);
        registry.registerLuaMethod(new LuaMethod("getSensorNames"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                return SensorHandler.getInstance().getSensorNames();
            }
        });
        registry.registerLuaMethod(new LuaMethod("setSensor"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 0, 1, "sensor_name?");
                if (args.length == 1) {
                    ISensorSetting sensor = args[0] instanceof String ? SensorHandler.getInstance().getSensorForName((String)args[0]) : SensorHandler.getInstance().getSensorByIndex(((Double)args[0]).intValue() - 1);
                    if (sensor != null) {
                        return new Object[]{TileEntityUniversalSensor.this.setSensorSetting(sensor)};
                    }
                    throw new IllegalArgumentException("Invalid sensor name/index: " + args[0]);
                }
                TileEntityUniversalSensor.this.setSensorSetting("");
                return new Object[]{true};
            }
        });
        registry.registerLuaMethod(new LuaMethod("getSensor"){

            @Override
            public Object[] call(Object[] args) {
                Object[] objectArray;
                this.requireNoArgs(args);
                ISensorSetting curSensor = SensorHandler.getInstance().getSensorFromPath(TileEntityUniversalSensor.this.getSensorSetting());
                if (curSensor == null) {
                    objectArray = null;
                } else {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = TileEntityUniversalSensor.this.getSensorSetting().substring(TileEntityUniversalSensor.this.getSensorSetting().lastIndexOf(47) + 1);
                }
                return objectArray;
            }
        });
        registry.registerLuaMethod(new LuaMethod("setTextfield"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "textfield_value");
                TileEntityUniversalSensor.this.setText(0, (String)args[0]);
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("getTextfield"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                return new Object[]{TileEntityUniversalSensor.this.getText(0)};
            }
        });
        registry.registerLuaMethod(new LuaMethod("isSensorEventBased"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                return new Object[]{SensorHandler.getInstance().getSensorFromPath(TileEntityUniversalSensor.this.getSensorSetting()) instanceof IEventSensorSetting};
            }
        });
        registry.registerLuaMethod(new LuaMethod("getSensorValue"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                ISensorSetting s = SensorHandler.getInstance().getSensorFromPath(TileEntityUniversalSensor.this.getSensorSetting());
                if (s instanceof IPollSensorSetting) {
                    TileEntityUniversalSensor.this.requestPollPullEvent = true;
                    return new Object[]{TileEntityUniversalSensor.this.redstoneStrength};
                }
                if (s != null) {
                    throw new IllegalArgumentException("The selected sensor is pull event based. You can't poll the value.");
                }
                throw new IllegalArgumentException("There's no sensor selected!");
            }
        });
        registry.registerLuaMethod(new LuaMethod("setGPSToolCoordinate"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 4, "slot, x, y, z");
                ItemStack stack = TileEntityUniversalSensor.this.getUpgradeHandler().getStackInSlot(((Double)args[0]).intValue() - 1);
                if (stack.func_77973_b() == ModItems.GPS_TOOL.get()) {
                    ItemGPSTool.setGPSLocation(stack, new BlockPos(((Double)args[1]).doubleValue(), ((Double)args[2]).doubleValue(), ((Double)args[3]).doubleValue()));
                    return new Object[]{true};
                }
                return new Object[]{false};
            }
        });
        registry.registerLuaMethod(new LuaMethod("getGPSToolCoordinate"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "upgrade_slot");
                ItemStack stack = TileEntityUniversalSensor.this.getUpgradeHandler().getStackInSlot(((Double)args[0]).intValue() - 1);
                if (stack.func_77973_b() == ModItems.GPS_TOOL.get()) {
                    BlockPos pos = ItemGPSTool.getGPSLocation(TileEntityUniversalSensor.this.field_145850_b, stack);
                    if (pos != null) {
                        return new Object[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()};
                    }
                    return new Object[]{0, 0, 0};
                }
                return null;
            }
        });
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return this.itemHandler;
    }

    @Override
    @Nonnull
    protected LazyOptional<IItemHandler> getInventoryCap() {
        return this.inventoryCap;
    }

    @Override
    public int getRedstoneMode() {
        return this.invertedRedstone ? 1 : 0;
    }

    @Override
    public float getMinWorkingPressure() {
        return 0.5f;
    }

    @Override
    public String getRedstoneTabTitle() {
        return "pneumaticcraft.gui.tab.redstoneBehaviour.universalSensor.redstoneEmission";
    }

    @Override
    protected List<String> getRedstoneButtonLabels() {
        return REDSTONE_LABELS;
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        GlobalTileEntityCacheManager.getInstance().universalSensors.remove(this);
    }

    @Override
    public void func_145829_t() {
        super.func_145829_t();
        GlobalTileEntityCacheManager.getInstance().universalSensors.add(this);
    }

    public ITextComponent func_145748_c_() {
        return this.getDisplayNameInternal();
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerUniversalSensor(i, playerInventory, this.func_174877_v());
    }

    public static enum SensorStatus {
        OK,
        MISSING_GPS,
        MISSING_UPGRADE,
        NO_SENSOR;


        public String getTranslationKey() {
            return "pneumaticcraft.gui.universalSensor.status." + this.toString().toLowerCase();
        }
    }

    private class UniversalSensorItemHandler
    extends ItemStackHandler {
        UniversalSensorItemHandler() {
            super(1);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            if (stack.func_77973_b() instanceof IPositionProvider) {
                List<BlockPos> l = ((IPositionProvider)stack.func_77973_b()).getStoredPositions(TileEntityUniversalSensor.this.field_145850_b, stack);
                return !l.isEmpty() && l.get(0) != null;
            }
            return false;
        }

        protected void onContentsChanged(int slot) {
            TileEntityUniversalSensor.this.setupGPSPositions();
        }
    }
}

