/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ConcurrentLinkedQueue;
import me.desht.pneumaticcraft.common.config.PNCConfig;
import me.desht.pneumaticcraft.lib.Log;
import org.apache.commons.io.IOUtils;

public class DramaSplash {
    private static final int MIN_SIZE = 5;
    private static final int MAX_SIZE = 10;
    private static final long SLEEP_TIME = 5000L;
    private static DramaSplash INSTANCE;
    private URL splashSite;
    private final ConcurrentLinkedQueue<String> dramaFifo;
    private Thread grabberThread = null;

    private DramaSplash() {
        try {
            this.splashSite = new URL("http://mc-drama.herokuapp.com/raw");
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            this.splashSite = null;
        }
        this.dramaFifo = new ConcurrentLinkedQueue();
        if (PNCConfig.Client.aphorismDrama) {
            this.fetchMoreSplash();
        }
    }

    public static DramaSplash getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DramaSplash();
        }
        return INSTANCE;
    }

    public String getSplash() {
        String res = this.dramaFifo.poll();
        if (this.dramaFifo.size() < 5) {
            this.fetchMoreSplash();
        }
        return res == null ? "" : res;
    }

    private void fetchMoreSplash() {
        if (this.grabberThread == null && this.splashSite != null) {
            this.grabberThread = new Thread(new SplashGrabber());
            this.grabberThread.start();
            Log.info("Started splash fetcher: thread " + this.grabberThread.getName(), new Object[0]);
        }
    }

    private class SplashGrabber
    implements Runnable {
        private SplashGrabber() {
        }

        @Override
        public void run() {
            block4: while (true) {
                try {
                    while (DramaSplash.this.dramaFifo.size() < 10) {
                        String s = IOUtils.toString((URL)DramaSplash.this.splashSite, (Charset)StandardCharsets.UTF_8);
                        DramaSplash.this.dramaFifo.offer(s);
                        if (DramaSplash.this.dramaFifo.size() < 5) continue;
                        try {
                            Thread.sleep(5000L);
                            continue block4;
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    break;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    break;
                }
            }
            DramaSplash.this.grabberThread = null;
            Log.info("Finished fetching splash: " + DramaSplash.this.dramaFifo.size() + " texts in queue", new Object[0]);
        }
    }
}

