/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.crafting.ingredient.FluidIngredient;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.FluidTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.PlayerInvWrapper;

public class FluidUtils {
    public static boolean tryFluidExtraction(IFluidHandler srcHandler, ItemStack destStack, NonNullList<ItemStack> returnedItems) {
        FluidActionResult result = FluidUtil.tryFillContainer((ItemStack)destStack, (IFluidHandler)srcHandler, (int)1000, null, (boolean)true);
        if (result.isSuccess()) {
            returnedItems.add((Object)result.getResult());
            destStack.func_190918_g(1);
            return true;
        }
        return false;
    }

    public static boolean tryFluidInsertion(IFluidHandler handler, ItemStack srcStack, NonNullList<ItemStack> returnedItems) {
        FluidActionResult result = FluidUtil.tryEmptyContainer((ItemStack)srcStack, (IFluidHandler)handler, (int)1000, null, (boolean)true);
        if (result.isSuccess()) {
            returnedItems.add((Object)result.getResult());
            srcStack.func_190918_g(1);
            return true;
        }
        return false;
    }

    public static boolean tryFluidInsertion(TileEntity te, Direction face, PlayerEntity player, Hand hand) {
        return FluidUtils.doFluidInteraction(te, face, player, hand, true);
    }

    public static boolean tryFluidExtraction(TileEntity te, Direction face, PlayerEntity player, Hand hand) {
        return FluidUtils.doFluidInteraction(te, face, player, hand, false);
    }

    private static boolean doFluidInteraction(TileEntity te, Direction face, PlayerEntity player, Hand hand, boolean isInserting) {
        ItemStack stack = player.func_184586_b(hand);
        return (Boolean)FluidUtil.getFluidHandler((ItemStack)stack).map(stackHandler -> {
            if (te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, face).isPresent()) {
                if (stackHandler.getTanks() == 0) {
                    return false;
                }
                int capacity = stackHandler.getTankCapacity(0);
                return (Boolean)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, face).map(handler -> {
                    FluidActionResult result;
                    PlayerInvWrapper invWrapper = new PlayerInvWrapper(player.field_71071_by);
                    FluidActionResult fluidActionResult = result = isInserting ? FluidUtils.tryEmptyContainerAndStow(player.func_184586_b(hand), handler, (IItemHandler)invWrapper, capacity, player, true) : FluidUtil.tryFillContainerAndStow((ItemStack)player.func_184586_b(hand), (IFluidHandler)handler, (IItemHandler)invWrapper, (int)capacity, (PlayerEntity)player, (boolean)true);
                    if (result.isSuccess()) {
                        player.func_184611_a(hand, result.getResult());
                        return true;
                    }
                    return false;
                }).orElse((Object)false);
            }
            return false;
        }).orElse((Object)false);
    }

    public static boolean isSourceFluidBlock(World world, BlockPos pos) {
        return FluidUtils.isSourceFluidBlock(world, pos, null);
    }

    public static boolean isSourceFluidBlock(World world, BlockPos pos, @Nullable Fluid fluid) {
        IFluidState state = world.func_204610_c(pos);
        return state.func_206889_d() && fluid == null || state.func_206886_c() == fluid;
    }

    public static boolean isFlowingFluidBlock(World world, BlockPos pos) {
        return FluidUtils.isFlowingFluidBlock(world, pos, null);
    }

    public static boolean isFlowingFluidBlock(World world, BlockPos pos, @Nullable Fluid fluid) {
        IFluidState state = world.func_204610_c(pos);
        return !state.func_206888_e() && !state.func_206889_d() && (fluid == null || fluid == state.func_206886_c());
    }

    public static FluidStack tryPickupFluid(LazyOptional<IFluidHandler> fluidCap, World world, BlockPos pos, boolean playSound, IFluidHandler.FluidAction action) {
        BlockState state = world.func_180495_p(pos);
        if (!(state.func_177230_c() instanceof IBucketPickupHandler)) {
            return FluidStack.EMPTY;
        }
        IFluidState fluidState = state.func_204520_s();
        Fluid fluid = fluidState.func_206886_c();
        if (fluid == Fluids.field_204541_a || !fluid.func_207193_c(fluidState)) {
            return FluidStack.EMPTY;
        }
        FluidTank tank = new FluidTank(1000);
        tank.setFluid(new FluidStack(fluid, 1000));
        FluidStack maybeSent = (FluidStack)fluidCap.map(h -> FluidUtil.tryFluidTransfer((IFluidHandler)h, (IFluidHandler)tank, (int)1000, (boolean)false)).orElse((Object)FluidStack.EMPTY);
        if (maybeSent.getAmount() != 1000) {
            return FluidStack.EMPTY;
        }
        ((IBucketPickupHandler)state.func_177230_c()).func_204508_a((IWorld)world, pos, state);
        FluidStack transferred = (FluidStack)fluidCap.map(h -> FluidUtil.tryFluidTransfer((IFluidHandler)h, (IFluidHandler)tank, (int)1000, (boolean)action.execute())).orElse((Object)FluidStack.EMPTY);
        if (!transferred.isEmpty() && playSound) {
            FluidUtils.playFillSound(world, pos, fluid);
        }
        return transferred;
    }

    public static boolean tryPourOutFluid(LazyOptional<IFluidHandler> fluidCap, World world, BlockPos pos, boolean playSound, boolean force, IFluidHandler.FluidAction action) {
        boolean isNotSolid;
        BlockState blockstate = world.func_180495_p(pos);
        Material material = blockstate.func_185904_a();
        boolean isReplaceable = material.func_76222_j();
        boolean bl = isNotSolid = !material.func_76220_a();
        if (!(force || blockstate.func_177230_c() instanceof ILiquidContainer || !FluidUtils.isSourceFluidBlock(world, pos) && isReplaceable)) {
            return false;
        }
        boolean didWork = (Boolean)fluidCap.map(handler -> {
            FluidStack toPlace = handler.drain(1000, IFluidHandler.FluidAction.SIMULATE);
            if (toPlace.getAmount() < 1000) {
                return false;
            }
            Fluid fluid = toPlace.getFluid();
            Block block = blockstate.func_177230_c();
            if (world.func_175623_d(pos) || isNotSolid || isReplaceable || block instanceof ILiquidContainer && ((ILiquidContainer)block).func_204510_a((IBlockReader)world, pos, blockstate, toPlace.getFluid())) {
                if (action.execute()) {
                    if (world.field_73011_w.func_177500_n() && fluid.func_207185_a(FluidTags.field_206959_a)) {
                        FluidUtils.playEvaporationEffects(world, pos);
                    } else if (block instanceof ILiquidContainer) {
                        IFluidState still;
                        IFluidState iFluidState = still = fluid instanceof FlowingFluid ? ((FlowingFluid)fluid).func_207204_a(false) : fluid.func_207188_f();
                        if (((ILiquidContainer)block).func_204509_a((IWorld)world, pos, blockstate, still) && playSound) {
                            FluidUtils.playEmptySound(world, pos, fluid);
                        }
                    } else {
                        if (playSound) {
                            FluidUtils.playEmptySound(world, pos, fluid);
                        }
                        if (isNotSolid || isReplaceable) {
                            world.func_175655_b(pos, true);
                        }
                        world.func_180501_a(pos, fluid.func_207188_f().func_206883_i(), 3);
                    }
                }
                return true;
            }
            return false;
        }).orElse((Object)false);
        if (didWork && action.execute()) {
            fluidCap.ifPresent(handler -> handler.drain(1000, IFluidHandler.FluidAction.EXECUTE));
        }
        return didWork;
    }

    private static void playEmptySound(World world, BlockPos pos, Fluid fluid) {
        SoundEvent soundevent = fluid.getAttributes().getEmptySound();
        if (soundevent == null) {
            soundevent = fluid.func_207185_a(FluidTags.field_206960_b) ? SoundEvents.field_187627_L : SoundEvents.field_187624_K;
        }
        world.func_184133_a(null, pos, soundevent, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    private static void playFillSound(World world, BlockPos pos, Fluid fluid) {
        SoundEvent soundEvent = fluid.getAttributes().getFillSound();
        if (soundEvent == null) {
            soundEvent = fluid.func_207185_a(FluidTags.field_206960_b) ? SoundEvents.field_187633_N : SoundEvents.field_187630_M;
        }
        world.func_184133_a(null, pos, soundEvent, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    private static void playEvaporationEffects(World world, BlockPos pos) {
        int i = pos.func_177958_n();
        int j = pos.func_177956_o();
        int k = pos.func_177952_p();
        world.func_184133_a(null, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
        for (int l = 0; l < 8; ++l) {
            world.func_195594_a((IParticleData)ParticleTypes.field_197594_E, (double)i + Math.random(), (double)j + Math.random(), (double)k + Math.random(), 0.0, 0.0, 0.0);
        }
    }

    public static boolean matchFluid(FluidIngredient fluidIngredient, FluidStack fluidStack, boolean matchTags) {
        return fluidIngredient.testFluid(fluidStack);
    }

    public static boolean matchFluid(FluidIngredient fluidIngredient, Fluid fluid, boolean matchTags) {
        return fluidIngredient.testFluid(fluid);
    }

    @Nonnull
    private static FluidActionResult tryEmptyContainerAndStow(@Nonnull ItemStack container, IFluidHandler fluidDestination, IItemHandler inventory, int maxAmount, @Nullable PlayerEntity player, boolean doDrain) {
        if (container.func_190926_b()) {
            return FluidActionResult.FAILURE;
        }
        if (player != null && player.field_71075_bZ.field_75098_d) {
            FluidActionResult emptiedReal = FluidUtils.tryEmptyContainer(container, fluidDestination, maxAmount, player, doDrain);
            if (emptiedReal.isSuccess()) {
                return new FluidActionResult(container);
            }
        } else if (container.func_190916_E() == 1) {
            FluidActionResult emptiedReal = FluidUtils.tryEmptyContainer(container, fluidDestination, maxAmount, player, doDrain);
            if (emptiedReal.isSuccess()) {
                return emptiedReal;
            }
        } else {
            ItemStack remainder;
            FluidActionResult emptiedSimulated = FluidUtils.tryEmptyContainer(container, fluidDestination, maxAmount, player, false);
            if (emptiedSimulated.isSuccess() && ((remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)emptiedSimulated.getResult(), (boolean)true)).func_190926_b() || player != null)) {
                FluidActionResult emptiedReal = FluidUtils.tryEmptyContainer(container, fluidDestination, maxAmount, player, doDrain);
                remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)emptiedReal.getResult(), (!doDrain ? 1 : 0) != 0);
                if (!remainder.func_190926_b() && player != null && doDrain) {
                    ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)remainder);
                }
                ItemStack containerCopy = container.func_77946_l();
                containerCopy.func_190918_g(1);
                return new FluidActionResult(containerCopy);
            }
        }
        return FluidActionResult.FAILURE;
    }

    @Nonnull
    private static FluidActionResult tryEmptyContainer(@Nonnull ItemStack container, IFluidHandler fluidDestination, int maxAmount, @Nullable PlayerEntity player, boolean doDrain) {
        ItemStack containerCopy = ItemHandlerHelper.copyStackWithSize((ItemStack)container, (int)1);
        return (FluidActionResult)FluidUtil.getFluidHandler((ItemStack)containerCopy).map(containerFluidHandler -> {
            FluidStack transfer = FluidUtil.tryFluidTransfer((IFluidHandler)fluidDestination, (IFluidHandler)containerFluidHandler, (int)maxAmount, (boolean)doDrain);
            if (transfer.isEmpty()) {
                return FluidActionResult.FAILURE;
            }
            if (doDrain && player != null) {
                SoundEvent soundevent = transfer.getFluid().getAttributes().getEmptySound(transfer);
                player.field_70170_p.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_() + 0.5, player.func_226281_cx_(), soundevent, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            ItemStack resultContainer = containerFluidHandler.getContainer();
            return new FluidActionResult(resultContainer);
        }).orElse((Object)FluidActionResult.FAILURE);
    }
}

