/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class IOHelper {
    public static LazyOptional<IItemHandler> getInventoryForTE(TileEntity te, Direction facing) {
        return te == null ? LazyOptional.empty() : te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing);
    }

    public static LazyOptional<IItemHandler> getInventoryForTE(TileEntity te) {
        return IOHelper.getInventoryForTE(te, null);
    }

    public static LazyOptional<IFluidHandler> getFluidHandlerForTE(TileEntity te, Direction facing) {
        return te == null ? LazyOptional.empty() : te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing);
    }

    public static LazyOptional<IFluidHandler> getFluidHandlerForTE(TileEntity te) {
        return IOHelper.getFluidHandlerForTE(te, null);
    }

    public static ItemStack extract(IItemHandler handler, ItemStack requestedStack, ExtractCount countType, boolean simulate, boolean matchNBT) {
        if (requestedStack.func_190926_b()) {
            return requestedStack;
        }
        if (handler != null) {
            int itemsFound = 0;
            ArrayList slotsOfInterest = Lists.newArrayList();
            for (int slot = 0; slot < handler.getSlots() && itemsFound < requestedStack.func_190916_E(); ++slot) {
                ItemStack stack = handler.getStackInSlot(slot);
                if (stack.func_190926_b() || !IOHelper.matchStacks(stack, requestedStack, matchNBT)) continue;
                if (countType == ExtractCount.FIRST_MATCHING) {
                    return handler.extractItem(slot, Math.min(requestedStack.func_190916_E(), stack.func_190916_E()), simulate);
                }
                itemsFound += stack.func_190916_E();
                slotsOfInterest.add(slot);
            }
            if (countType == ExtractCount.UP_TO || itemsFound >= requestedStack.func_190916_E()) {
                ItemStack exportedStack = ItemStack.field_190927_a;
                int itemsNeeded = requestedStack.func_190916_E();
                int totalExtracted = 0;
                Iterator iterator = slotsOfInterest.iterator();
                while (iterator.hasNext()) {
                    int slot = (Integer)iterator.next();
                    ItemStack stack = handler.getStackInSlot(slot);
                    if (!IOHelper.matchStacks(stack, requestedStack, matchNBT)) continue;
                    int itemsSubtracted = Math.min(itemsNeeded, stack.func_190916_E());
                    if (itemsSubtracted > 0) {
                        exportedStack = stack;
                    }
                    itemsNeeded -= itemsSubtracted;
                    ItemStack extracted = handler.extractItem(slot, itemsSubtracted, simulate);
                    totalExtracted += extracted.func_190916_E();
                }
                exportedStack = exportedStack.func_77946_l();
                exportedStack.func_190920_e(totalExtracted);
                return exportedStack;
            }
        }
        return ItemStack.field_190927_a;
    }

    private static boolean matchStacks(ItemStack stack1, ItemStack stack2, boolean matchNBT) {
        return ItemStack.func_179545_c((ItemStack)stack1, (ItemStack)stack2) && (!matchNBT || ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2));
    }

    @Nonnull
    public static ItemStack insert(ICapabilityProvider provider, ItemStack itemStack, Direction side, boolean simulate) {
        return (ItemStack)provider.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side).map(handler -> ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)itemStack, (boolean)simulate)).orElse((Object)itemStack);
    }

    @Nonnull
    public static ItemStack insertStacked(ICapabilityProvider provider, ItemStack itemStack, Direction side, boolean simulate) {
        return (ItemStack)provider.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side).map(handler -> ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)itemStack, (boolean)simulate)).orElse((Object)itemStack);
    }

    public static boolean transferOneItem(IItemHandler input, IItemHandler output) {
        if (input == null || output == null) {
            return false;
        }
        for (int i = 0; i < input.getSlots(); ++i) {
            ItemStack extracted = input.extractItem(i, 1, true);
            if (extracted.func_190926_b() || !ItemHandlerHelper.insertItemStacked((IItemHandler)output, (ItemStack)extracted, (boolean)false).func_190926_b()) continue;
            input.extractItem(i, 1, false);
            return true;
        }
        return false;
    }

    public static enum ExtractCount {
        EXACT,
        FIRST_MATCHING,
        UP_TO;

    }
}

