/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util;

import com.google.common.base.Splitter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.item.IInventoryItem;
import me.desht.pneumaticcraft.api.item.ITagFilteringItem;
import me.desht.pneumaticcraft.common.XPFluidManager;
import me.desht.pneumaticcraft.common.core.ModFluids;
import me.desht.pneumaticcraft.common.item.ItemRegistry;
import me.desht.pneumaticcraft.lib.GuiConstants;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class PneumaticCraftUtils {
    private static final List<Item> inventoryItemBlacklist = new ArrayList<Item>();
    public static final Direction[] HORIZONTALS = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};
    public static final double[] sin = new double[500];
    public static final double[] cos = new double[500];
    public static final int CIRCLE_POINTS = 500;

    public static Direction getDirectionFacing(LivingEntity entity, boolean includeUpAndDown) {
        double yaw;
        for (yaw = (double)entity.field_70177_z; yaw < 0.0; yaw += 360.0) {
        }
        yaw %= 360.0;
        if (includeUpAndDown) {
            if (entity.field_70125_A > 45.0f) {
                return Direction.DOWN;
            }
            if (entity.field_70125_A < -45.0f) {
                return Direction.UP;
            }
        }
        if (yaw < 45.0) {
            return Direction.SOUTH;
        }
        if (yaw < 135.0) {
            return Direction.WEST;
        }
        if (yaw < 225.0) {
            return Direction.NORTH;
        }
        if (yaw < 315.0) {
            return Direction.EAST;
        }
        return Direction.SOUTH;
    }

    public static int getYawFromFacing(Direction facing) {
        switch (facing) {
            case NORTH: {
                return 180;
            }
            case WEST: {
                return 90;
            }
            case EAST: {
                return -90;
            }
        }
        return 0;
    }

    public static List<String> splitString(String text, int maxCharPerLine) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder builder = new StringBuilder(text.length());
        String format = "";
        for (String para : text.split(Pattern.quote("${br}"))) {
            StringTokenizer tok = new StringTokenizer(para, " ");
            int lineLen = 0;
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                for (String word : Splitter.fixedLength((int)maxCharPerLine).split((CharSequence)token)) {
                    int idx = word.lastIndexOf("\u00a7");
                    if (idx >= 0 && idx < word.length() - 1) {
                        format = word.substring(idx, idx + 2);
                        lineLen -= 2;
                    }
                    if (lineLen + word.length() > maxCharPerLine) {
                        result.add(builder.toString());
                        builder.delete(0, builder.length());
                        builder.append(format);
                        lineLen = 0;
                    } else if (lineLen > 0) {
                        builder.append(" ");
                        ++lineLen;
                    }
                    builder.append(word);
                    lineLen += word.length();
                }
            }
            result.add(builder.toString());
            builder.delete(0, builder.length());
            builder.append(format);
        }
        return result;
    }

    public static List<String> splitString(String text) {
        return PneumaticCraftUtils.splitString(text, 26);
    }

    public static List<ITextComponent> asStringComponent(List<String> l) {
        return l.stream().map(StringTextComponent::new).collect(Collectors.toList());
    }

    public static String convertTicksToMinutesAndSeconds(long ticks, boolean fraction) {
        String part = ticks % 20L * 5L + "";
        if (part.length() < 2) {
            part = "0" + part;
        }
        if ((ticks /= 20L) < 60L) {
            return ticks + (fraction ? "." + part : "") + "s";
        }
        return ticks / 60L + "m " + ticks % 60L + "s";
    }

    public static String convertAmountToString(int amount) {
        if (amount < 1000) {
            return amount + "";
        }
        return amount / 1000 + "k";
    }

    public static String roundNumberTo(double value, int decimals) {
        return new BigDecimal(value).setScale(decimals, 5).toPlainString();
    }

    public static double roundNumberToDouble(double value, int decimals) {
        return new BigDecimal(value).setScale(decimals, 5).doubleValue();
    }

    public static String roundNumberTo(float value, int decimals) {
        return "" + (double)Math.round((double)value * Math.pow(10.0, decimals)) / Math.pow(10.0, decimals);
    }

    public static boolean areFloatsEqual(float f1, float f2) {
        return PneumaticCraftUtils.areFloatsEqual(f1, f2, 0.001f);
    }

    public static boolean areFloatsEqual(float f1, float f2, float maxDifference) {
        return Math.abs(f1 - f2) < maxDifference;
    }

    private static void quickSort(ItemStack[] stacks, int begin, int end) {
        if (begin < end) {
            int partitionIndex = PneumaticCraftUtils._partition(stacks, begin, end);
            PneumaticCraftUtils.quickSort(stacks, begin, partitionIndex - 1);
            PneumaticCraftUtils.quickSort(stacks, partitionIndex + 1, end);
        }
    }

    private static int _partition(ItemStack[] arr, int begin, int end) {
        ItemStack pivot = arr[end];
        int i = begin - 1;
        for (int j = begin; j < end; ++j) {
            if (arr[j].func_200301_q().func_150254_d().compareToIgnoreCase(pivot.func_200301_q().func_150254_d()) > 0) continue;
            ItemStack swapTemp = arr[++i];
            arr[i] = arr[j];
            arr[j] = swapTemp;
        }
        ItemStack swapTemp = arr[i + 1];
        arr[i + 1] = arr[end];
        arr[end] = swapTemp;
        return i + 1;
    }

    public static void sortCombineItemStacksAndToString(List<ITextComponent> textList, ItemStack[] originalStacks) {
        PneumaticCraftUtils.sortCombineItemStacksAndToString(textList, originalStacks, GuiConstants.bullet().func_150254_d());
    }

    public static void sortCombineItemStacksAndToString(List<ITextComponent> textList, ItemStack[] originalStacks, String prefix) {
        ItemStack[] stacks = Arrays.copyOf(originalStacks, originalStacks.length);
        PneumaticCraftUtils.quickSort(stacks, 0, stacks.length - 1);
        int itemCount = 0;
        ItemStack prevItemStack = ItemStack.field_190927_a;
        List<ItemStack> prevInventoryItems = null;
        for (ItemStack stack : stacks) {
            if (stack.func_190926_b()) continue;
            if (!stack.func_77969_a(prevItemStack) || prevInventoryItems != null && prevInventoryItems.size() > 0) {
                if (!prevItemStack.func_190926_b()) {
                    PneumaticCraftUtils.addText(textList, prefix + PneumaticCraftUtils.convertAmountToString(itemCount) + " x " + prevItemStack.func_200301_q().func_150254_d());
                }
                if (prevInventoryItems != null) {
                    PneumaticCraftUtils.sortCombineItemStacksAndToString(textList, prevInventoryItems.toArray(new ItemStack[0]), prefix + "\u21b3" + " ");
                }
                prevItemStack = stack;
                itemCount = stack.func_190916_E();
            } else {
                itemCount += stack.func_190916_E();
            }
            prevInventoryItems = PneumaticCraftUtils.getStacksInItem(stack);
        }
        if (itemCount > 0 && !prevItemStack.func_190926_b()) {
            PneumaticCraftUtils.addText(textList, prefix + PneumaticCraftUtils.convertAmountToString(itemCount) + " x " + prevItemStack.func_200301_q().func_150254_d());
            if (prevInventoryItems != null) {
                PneumaticCraftUtils.sortCombineItemStacksAndToString(textList, prevInventoryItems.toArray(new ItemStack[0]), prefix + "\u21b3" + " ");
            }
        }
    }

    public static List<ItemStack> getStacksInItem(@Nonnull ItemStack item) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (item.func_77973_b() instanceof IInventoryItem && !inventoryItemBlacklist.contains(item.func_77973_b())) {
            try {
                ((IInventoryItem)item.func_77973_b()).getStacksInItem(item, items);
            }
            catch (Throwable e) {
                Log.error("An InventoryItem crashed:", new Object[0]);
                e.printStackTrace();
                inventoryItemBlacklist.add(item.func_77973_b());
            }
        } else {
            Iterator<IInventoryItem> iterator = ItemRegistry.getInstance().inventoryItems.iterator();
            while (iterator.hasNext()) {
                try {
                    iterator.next().getStacksInItem(item, items);
                }
                catch (Throwable e) {
                    Log.error("An InventoryItem crashed:", new Object[0]);
                    e.printStackTrace();
                    iterator.remove();
                }
            }
        }
        return items;
    }

    public static int getRedstoneLevel(World world, BlockPos pos) {
        return world != null ? world.func_175687_A(pos) : 0;
    }

    public static String getPage(String urlString) throws IOException {
        StringBuilder all = new StringBuilder();
        URL myUrl = new URL(urlString);
        try (BufferedReader in = new BufferedReader(new InputStreamReader(myUrl.openStream()));){
            String line;
            while ((line = in.readLine()) != null) {
                all.append(line).append(System.getProperty("line.separator"));
            }
        }
        return all.toString();
    }

    public static RayTraceResult getEntityLookedObject(LivingEntity entity) {
        return PneumaticCraftUtils.getEntityLookedObject(entity, 4.5f);
    }

    public static RayTraceResult getEntityLookedObject(LivingEntity entity, float maxDistance) {
        Pair<Vec3d, Vec3d> vecs = PneumaticCraftUtils.getStartAndEndLookVec(entity, maxDistance);
        RayTraceContext ctx = new RayTraceContext((Vec3d)vecs.getLeft(), (Vec3d)vecs.getRight(), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)entity);
        return entity.field_70170_p.func_217299_a(ctx);
    }

    public static Pair<Vec3d, Vec3d> getStartAndEndLookVec(LivingEntity entity) {
        return PneumaticCraftUtils.getStartAndEndLookVec(entity, 4.5f);
    }

    public static Pair<Vec3d, Vec3d> getStartAndEndLookVec(LivingEntity entity, float maxDistance) {
        Vec3d entityVec = entity.field_70170_p.field_72995_K && entity instanceof PlayerEntity ? new Vec3d(entity.func_226277_ct_(), entity.func_226278_cu_() + 1.62, entity.func_226281_cx_()) : new Vec3d(entity.func_226277_ct_(), entity.func_226278_cu_() + (double)entity.func_70047_e() - (entity.func_225608_bj_() ? 0.08 : 0.0), entity.func_226281_cx_());
        Vec3d entityLookVec = entity.func_70676_i(1.0f);
        Vec3d maxDistVec = entityVec.func_178787_e(entityLookVec.func_186678_a((double)maxDistance));
        return new ImmutablePair((Object)entityVec, (Object)maxDistVec);
    }

    public static double distBetween(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Math.sqrt(PneumaticCraftUtils.distBetweenSq(x1, y1, z1, x2, y2, z2));
    }

    public static double distBetweenSq(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Math.pow(x1 - x2, 2.0) + Math.pow(y1 - y2, 2.0) + Math.pow(z1 - z2, 2.0);
    }

    public static double distBetweenSq(Vec3i pos, double x, double y, double z) {
        return PneumaticCraftUtils.distBetweenSq((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, x, y, z);
    }

    public static double distBetweenSq(BlockPos pos1, BlockPos pos2) {
        return PneumaticCraftUtils.distBetweenSq(pos1.func_177958_n(), pos1.func_177956_o(), pos1.func_177952_p(), pos2.func_177958_n(), pos2.func_177956_o(), pos2.func_177952_p());
    }

    public static double distBetween(double x1, double y1, double x2, double y2) {
        return Math.sqrt(Math.pow(x1 - x2, 2.0) + Math.pow(y1 - y2, 2.0));
    }

    public static double distBetweenSq(double x1, double y1, double x2, double y2) {
        return (x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2);
    }

    public static double distBetween(Vec3i pos, double x, double y, double z) {
        return PneumaticCraftUtils.distBetween((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, x, y, z);
    }

    public static double distBetween(Vec3i pos1, Vec3i pos2) {
        return PneumaticCraftUtils.distBetween(pos1, (double)pos2.func_177958_n() + 0.5, (double)pos2.func_177956_o() + 0.5, (double)pos2.func_177952_p() + 0.5);
    }

    public static boolean doesItemMatchFilter(@Nonnull ItemStack filterStack, @Nonnull ItemStack stack, boolean checkDurability, boolean checkNBT, boolean checkModSimilarity) {
        boolean durabilityOK;
        if (filterStack.func_190926_b() && stack.func_190926_b()) {
            return true;
        }
        if (filterStack.func_190926_b() || stack.func_190926_b()) {
            return false;
        }
        if (checkModSimilarity) {
            String mod1 = filterStack.func_77973_b().getRegistryName().func_110624_b();
            String mod2 = stack.func_77973_b().getRegistryName().func_110624_b();
            return mod1.equals(mod2);
        }
        if (filterStack.func_77973_b() instanceof ITagFilteringItem) {
            return ((ITagFilteringItem)filterStack.func_77973_b()).matchTags(filterStack, stack.func_77973_b());
        }
        if (filterStack.func_77973_b() != stack.func_77973_b()) {
            return false;
        }
        boolean bl = durabilityOK = !checkDurability || filterStack.func_77958_k() > 0 && filterStack.func_77952_i() == stack.func_77952_i();
        boolean nbtOK = !checkNBT || (filterStack.func_77942_o() ? filterStack.func_77978_p().equals((Object)stack.func_77978_p()) : !stack.func_77942_o());
        return durabilityOK && nbtOK;
    }

    public static boolean isBlockLiquid(Block block) {
        return block instanceof FlowingFluidBlock;
    }

    public static void dropItemOnGround(ItemStack stack, World world, BlockPos pos) {
        PneumaticCraftUtils.dropItemOnGround(stack, world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
    }

    public static void dropItemOnGround(ItemStack stack, World world, double x, double y, double z) {
        float dX = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
        float dY = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
        float dZ = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
        ItemEntity entityItem = new ItemEntity(world, x + (double)dX, y + (double)dY, z + (double)dZ, stack.func_77946_l());
        if (stack.func_77942_o()) {
            entityItem.func_92059_d().func_77982_d(stack.func_77978_p().func_74737_b());
        }
        float factor = 0.05f;
        entityItem.func_213293_j(world.field_73012_v.nextGaussian() * (double)factor, world.field_73012_v.nextGaussian() * (double)factor + 0.2, world.field_73012_v.nextGaussian() * (double)factor);
        world.func_217376_c((Entity)entityItem);
        stack.func_190920_e(0);
    }

    public static void dropItemOnGroundPrecisely(ItemStack stack, World world, double x, double y, double z) {
        ItemEntity entityItem = new ItemEntity(world, x, y, z, stack.func_77946_l());
        if (stack.func_77942_o()) {
            entityItem.func_92059_d().func_77982_d(stack.func_77978_p().func_74737_b());
        }
        entityItem.func_213293_j(0.0, 0.0, 0.0);
        world.func_217376_c((Entity)entityItem);
        stack.func_190920_e(0);
    }

    public static PlayerEntity getPlayerFromId(String uuid) {
        return ServerLifecycleHooks.getCurrentServer().func_184103_al().func_177451_a(UUID.fromString(uuid));
    }

    public static PlayerEntity getPlayerFromId(UUID uuid) {
        return ServerLifecycleHooks.getCurrentServer().func_184103_al().func_177451_a(uuid);
    }

    public static PlayerEntity getPlayerFromName(String name) {
        return ServerLifecycleHooks.getCurrentServer().func_184103_al().func_152612_a(name);
    }

    public static boolean isPlayerOp(PlayerEntity player) {
        return player.func_211513_k(2);
    }

    private static RayTraceResult raytraceEntityBlocks(LivingEntity entity, double range) {
        Pair<Vec3d, Vec3d> startAndEnd = PneumaticCraftUtils.getStartAndEndLookVec(entity, (float)range);
        RayTraceContext ctx = new RayTraceContext((Vec3d)startAndEnd.getLeft(), (Vec3d)startAndEnd.getRight(), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)entity);
        return entity.field_70170_p.func_217299_a(ctx);
    }

    public static RayTraceResult getMouseOverServer(LivingEntity lookingEntity, double range) {
        RayTraceResult result = PneumaticCraftUtils.raytraceEntityBlocks(lookingEntity, range);
        double rangeSq = range * range;
        Pair<Vec3d, Vec3d> startAndEnd = PneumaticCraftUtils.getStartAndEndLookVec(lookingEntity, (float)range);
        Vec3d eyePos = (Vec3d)startAndEnd.getLeft();
        if (result.func_216346_c() != RayTraceResult.Type.MISS) {
            rangeSq = result.func_216347_e().func_72436_e(eyePos);
        }
        double rangeSq2 = rangeSq;
        Vec3d hitVec = null;
        Entity focusedEntity = null;
        Vec3d lookVec = lookingEntity.func_70040_Z().func_186678_a(range + 1.0);
        AxisAlignedBB box = lookingEntity.func_174813_aQ().func_72314_b(lookVec.field_72450_a, lookVec.field_72448_b, lookVec.field_72449_c);
        for (Entity entity : lookingEntity.field_70170_p.func_175674_a((Entity)lookingEntity, box, Entity::func_70067_L)) {
            double rangeSq3;
            AxisAlignedBB aabb = entity.func_174813_aQ().func_186662_g((double)entity.func_70111_Y());
            Optional vec = aabb.func_216365_b(eyePos, (Vec3d)startAndEnd.getRight());
            if (aabb.func_72318_a(eyePos)) {
                if (!(rangeSq2 >= 0.0)) continue;
                focusedEntity = entity;
                hitVec = vec.orElse(eyePos);
                rangeSq2 = 0.0;
                continue;
            }
            if (!vec.isPresent() || !((rangeSq3 = eyePos.func_72436_e((Vec3d)vec.get())) < rangeSq2) && rangeSq2 != 0.0) continue;
            if (entity == entity.func_184187_bx() && !entity.canRiderInteract()) {
                if (rangeSq2 != 0.0) continue;
                focusedEntity = entity;
                hitVec = (Vec3d)vec.get();
                continue;
            }
            focusedEntity = entity;
            hitVec = (Vec3d)vec.get();
            rangeSq2 = rangeSq3;
        }
        if (focusedEntity != null && (rangeSq2 < rangeSq || result == null)) {
            result = new EntityRayTraceResult(focusedEntity, hitVec);
        }
        return result;
    }

    public static boolean tryPlaceBlock(World w, BlockPos pos, PlayerEntity player, Direction face, BlockState newState) {
        BlockSnapshot snapshot = BlockSnapshot.getBlockSnapshot((IWorld)w, (BlockPos)pos);
        if (!ForgeEventFactory.onBlockPlace((Entity)player, (BlockSnapshot)snapshot, (Direction)face)) {
            w.func_175656_a(pos, newState);
            return true;
        }
        return false;
    }

    public static MobEntity createDummyEntity(PlayerEntity player) {
        ZombieEntity dummy = new ZombieEntity(player.field_70170_p){

            protected void func_110147_ax() {
                super.func_110147_ax();
                this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(150.0);
            }
        };
        dummy.func_70107_b(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
        return dummy;
    }

    public static boolean consumeInventoryItem(PlayerInventory inv, Item item) {
        for (int i = 0; i < inv.field_70462_a.size(); ++i) {
            if (((ItemStack)inv.field_70462_a.get(i)).func_77973_b() != item) continue;
            ((ItemStack)inv.field_70462_a.get(i)).func_190918_g(1);
            if (((ItemStack)inv.field_70462_a.get(i)).func_190916_E() <= 0) {
                inv.field_70462_a.set(i, (Object)ItemStack.field_190927_a);
            }
            return true;
        }
        return false;
    }

    public static void collectNonEmptyItems(IItemHandler handler, NonNullList<ItemStack> items) {
        if (handler != null) {
            for (int i = 0; i < handler.getSlots(); ++i) {
                if (handler.getStackInSlot(i).func_190926_b()) continue;
                items.add((Object)handler.getStackInSlot(i));
            }
        }
    }

    public static boolean consumeInventoryItem(PlayerInventory inv, ItemStack stack) {
        int toConsume = stack.func_190916_E();
        for (int i = 0; i < inv.field_70462_a.size(); ++i) {
            ItemStack invStack = (ItemStack)inv.field_70462_a.get(i);
            if (!ItemStack.func_179545_c((ItemStack)invStack, (ItemStack)stack)) continue;
            int consumed = Math.min(invStack.func_190916_E(), stack.func_190916_E());
            invStack.func_190918_g(consumed);
            if ((toConsume -= consumed) > 0) continue;
            return true;
        }
        return toConsume <= 0;
    }

    public static ResourceLocation RL(String path) {
        return new ResourceLocation("pneumaticcraft", path);
    }

    public static ITextComponent xlate(String s, Object ... args) {
        return new TranslationTextComponent(s, args);
    }

    public static void addText(List<ITextComponent> l, String s) {
        l.add((ITextComponent)new StringTextComponent(s));
    }

    public static String dyeColorDesc(int c) {
        return TextFormatting.BOLD + StringUtils.capitalize((String)DyeColor.func_196056_a((int)c).func_176762_d()) + TextFormatting.RESET;
    }

    public static int getBurnTime(ItemStack stack) {
        int ret = stack.getBurnTime();
        return ForgeEventFactory.getItemBurnTime((ItemStack)stack, (int)(ret == -1 ? ForgeHooks.getBurnTime((ItemStack)stack) : ret));
    }

    public static Vec3d getBlockCentre(BlockPos pos) {
        return new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
    }

    public static void copyItemHandler(IItemHandler source, ItemStackHandler dest) {
        dest.setSize(source.getSlots());
        for (int i = 0; i < source.getSlots(); ++i) {
            dest.setStackInSlot(i, source.getStackInSlot(i).func_77946_l());
        }
    }

    public static String posToString(BlockPos pos) {
        return String.format("%d,%d,%d", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public static <T extends TileEntity> Optional<T> getTileEntityAt(IBlockReader w, BlockPos pos, Class<T> cls) {
        TileEntity te;
        if (w != null && pos != null && (te = w.func_175625_s(pos)) != null && cls.isAssignableFrom(te.getClass())) {
            return Optional.of(te);
        }
        return Optional.empty();
    }

    public static boolean fillTankWithOrb(IFluidHandler handler, ExperienceOrbEntity orb, IFluidHandler.FluidAction action) {
        int ratio = XPFluidManager.getInstance().getXPRatio((Fluid)ModFluids.MEMORY_ESSENCE.get());
        int fluidAmount = orb.func_70526_d() * ratio;
        FluidStack toFill = new FluidStack((Fluid)ModFluids.MEMORY_ESSENCE.get(), fluidAmount);
        int filled = handler.fill(toFill, action);
        if (filled > 0 && filled < fluidAmount && action.execute()) {
            orb.field_70530_e -= Math.max(1, filled / ratio);
        }
        return filled == fluidAmount;
    }

    static {
        for (int i = 0; i < 500; ++i) {
            double angle = Math.PI * 2 * (double)i / 500.0;
            PneumaticCraftUtils.sin[i] = Math.sin(angle);
            PneumaticCraftUtils.cos[i] = Math.cos(angle);
        }
    }
}

