/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util;

import java.util.Arrays;
import me.desht.pneumaticcraft.common.entity.living.EntityAmadrone;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetArea;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetDropItem;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetGoToLocation;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetInventoryExport;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetInventoryImport;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetItemFilter;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetLiquidExport;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetLiquidFilter;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetLiquidImport;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetStart;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetSuicide;
import me.desht.pneumaticcraft.common.util.DroneProgramBuilder;
import me.desht.pneumaticcraft.common.util.GlobalPosUtils;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.apache.commons.lang3.Validate;

public class ProgrammedDroneUtils {
    public static CreatureEntity deliverItemsAmazonStyle(GlobalPos gPos, ItemStack ... deliveredStacks) {
        int i;
        World world = GlobalPosUtils.getWorldForGlobalPos(gPos);
        BlockPos pos = gPos.func_218180_b();
        if (world == null || world.field_72995_K) {
            return null;
        }
        Validate.isTrue((deliveredStacks.length > 0 && deliveredStacks.length <= 36 ? 1 : 0) != 0, (String)"You can only deliver between 0 & 36 stacks at once!", (Object[])new Object[0]);
        Arrays.stream(deliveredStacks).forEach(stack -> Validate.isTrue((!stack.func_190926_b() ? 1 : 0) != 0, (String)"You can't supply an empty stack to be delivered!", (Object[])new Object[0]));
        EntityAmadrone drone = EntityAmadrone.makeAmadrone(world, pos);
        DroneProgramBuilder builder = new DroneProgramBuilder();
        builder.add(new ProgWidgetStart(), new IProgWidget[0]);
        builder.add(new ProgWidgetInventoryExport(), ProgWidgetArea.fromPosition(pos));
        ProgWidgetArea area = ProgWidgetArea.fromPosition(pos);
        if (drone.isBlockValidPathfindBlock(pos)) {
            for (i = 0; i < 5 && drone.isBlockValidPathfindBlock(new BlockPos(area.x1, area.y1, area.z1)); ++i) {
                area.y1 = pos.func_177956_o() + i;
            }
        } else {
            area.y1 = world.func_205770_a(Heightmap.Type.WORLD_SURFACE, pos).func_177956_o() + 10;
            if (!drone.isBlockValidPathfindBlock(new BlockPos(area.x1, area.y1, area.z1))) {
                area.y1 = 260;
            }
        }
        builder.add(new ProgWidgetDropItem(), area);
        builder.add(new ProgWidgetGoToLocation(), ProgWidgetArea.fromPosition(drone.func_180425_c()));
        builder.add(new ProgWidgetSuicide(), new IProgWidget[0]);
        drone.progWidgets.addAll(builder.build());
        for (i = 0; i < deliveredStacks.length; ++i) {
            drone.getInv().setStackInSlot(i, deliveredStacks[i].func_77946_l());
        }
        world.func_217376_c((Entity)drone);
        return drone;
    }

    public static CreatureEntity deliverFluidAmazonStyle(GlobalPos gPos, FluidStack deliveredFluid) {
        World world = GlobalPosUtils.getWorldForGlobalPos(gPos);
        BlockPos pos = gPos.func_218180_b();
        if (world == null || world.field_72995_K) {
            return null;
        }
        Validate.notNull((Object)deliveredFluid, (String)"Can't deliver a null FluidStack", (Object[])new Object[0]);
        Validate.isTrue((deliveredFluid.getAmount() > 0 ? 1 : 0) != 0, (String)"Can't deliver a FluidStack with an amount of <= 0", (Object[])new Object[0]);
        EntityAmadrone drone = EntityAmadrone.makeAmadrone(world, pos);
        DroneProgramBuilder builder = new DroneProgramBuilder();
        builder.add(new ProgWidgetStart(), new IProgWidget[0]);
        builder.add(new ProgWidgetLiquidExport(), ProgWidgetArea.fromPosition(pos));
        builder.add(new ProgWidgetGoToLocation(), ProgWidgetArea.fromPosition(drone.func_180425_c()));
        builder.add(new ProgWidgetSuicide(), new IProgWidget[0]);
        drone.progWidgets.addAll(builder.build());
        drone.getFluidTank().fill(deliveredFluid, IFluidHandler.FluidAction.EXECUTE);
        world.func_217376_c((Entity)drone);
        return drone;
    }

    public static CreatureEntity retrieveItemsAmazonStyle(GlobalPos gPos, ItemStack ... queriedStacks) {
        World world = GlobalPosUtils.getWorldForGlobalPos(gPos);
        BlockPos pos = gPos.func_218180_b();
        if (world == null || world.field_72995_K) {
            return null;
        }
        Validate.isTrue((queriedStacks.length > 0 && queriedStacks.length <= 36 ? 1 : 0) != 0, (String)"Must retrieve between 1 & 36 itemstacks!", (Object[])new Object[0]);
        Arrays.stream(queriedStacks).forEach(stack -> Validate.isTrue((!stack.func_190926_b() ? 1 : 0) != 0, (String)"Cannot retrieve an empty stack!", (Object[])new Object[0]));
        EntityAmadrone drone = EntityAmadrone.makeAmadrone(world, pos);
        DroneProgramBuilder builder = new DroneProgramBuilder();
        builder.add(new ProgWidgetStart(), new IProgWidget[0]);
        for (ItemStack stack2 : queriedStacks) {
            ProgWidgetInventoryImport widgetImport = new ProgWidgetInventoryImport();
            widgetImport.setUseCount(true);
            widgetImport.setCount(stack2.func_190916_E());
            ProgWidgetItemFilter filter = ProgWidgetItemFilter.withFilter(stack2);
            filter.useNBT = stack2.func_77942_o();
            builder.add(widgetImport, ProgWidgetArea.fromPosition(pos), filter);
        }
        builder.add(new ProgWidgetGoToLocation(), ProgWidgetArea.fromPosition(drone.func_180425_c()));
        builder.add(new ProgWidgetSuicide(), new IProgWidget[0]);
        drone.progWidgets.addAll(builder.build());
        world.func_217376_c((Entity)drone);
        return drone;
    }

    public static CreatureEntity retrieveFluidAmazonStyle(GlobalPos gPos, FluidStack queriedFluid) {
        World world = GlobalPosUtils.getWorldForGlobalPos(gPos);
        BlockPos pos = gPos.func_218180_b();
        if (world == null || world.field_72995_K) {
            return null;
        }
        Validate.notNull((Object)queriedFluid, (String)"Can't retrieve a null FluidStack", (Object[])new Object[0]);
        Validate.isTrue((queriedFluid.getAmount() > 0 ? 1 : 0) != 0, (String)"Can't retrieve a FluidStack with an amount of <= 0", (Object[])new Object[0]);
        EntityAmadrone drone = EntityAmadrone.makeAmadrone(world, pos);
        DroneProgramBuilder builder = new DroneProgramBuilder();
        builder.add(new ProgWidgetStart(), new IProgWidget[0]);
        ProgWidgetLiquidImport liquidImport = new ProgWidgetLiquidImport();
        liquidImport.setUseCount(true);
        liquidImport.setCount(queriedFluid.getAmount());
        builder.add(liquidImport, ProgWidgetArea.fromPosition(pos), ProgWidgetLiquidFilter.withFilter(queriedFluid.getFluid()));
        builder.add(new ProgWidgetGoToLocation(), ProgWidgetArea.fromPosition(drone.func_180425_c()));
        builder.add(new ProgWidgetSuicide(), new IProgWidget[0]);
        drone.progWidgets.addAll(builder.build());
        world.func_217376_c((Entity)drone);
        return drone;
    }
}

